/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BiVarHistogramOverlay;
import org.w3c.dom.Element;

public final class BiHistoParser {
    public static final String RB_KEY = "BiHistoParser.";

    public static BiVarHistogramOverlay load(StatGraph graph, Element elem) {
        BiVarHistogramOverlay bih = (BiVarHistogramOverlay)graph.getObjectFromElement(elem);
        if (bih == null) {
            bih = new BiVarHistogramOverlay();
        }
        return BiHistoParser.load(graph, bih, elem) ? bih : null;
    }

    public static boolean load(StatGraph graph, BiVarHistogramOverlay bih, Element elem) {
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, bih);
        String str = elem.getAttribute("primary");
        bih.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("z");
        String zVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        int ycol = m.getColumn(yVarID);
        int zcol = m.getColumn(zVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            graph.removeNamedGraph(bih);
            return false;
        }
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 1, true)) {
            graph.removeNamedGraph(bih);
            return false;
        }
        if (!StatGraph.checkVariable("Z", m.getColumnLabel(zcol), Double.class, 0, false, 1, true)) {
            graph.removeNamedGraph(bih);
            return false;
        }
        map.map(13, xcol);
        map.map(24, ycol);
        map.map(2, zcol);
        if (graph.casData) {
            bih.setPresortData(true);
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, bih);
        str = elem.getAttribute("xValues");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("LEFTPOINTS")) {
                bih.setXValues((byte)1);
            } else if (str.equalsIgnoreCase("RIGHTPOINTS")) {
                bih.setXValues((byte)2);
            } else if (str.equalsIgnoreCase("MIDPOINTS")) {
                bih.setXValues((byte)0);
            } else {
                bih.setXValues((byte)0);
                StatGraph.printOptionError("XVALUES", str);
            }
        }
        if ((str = elem.getAttribute("yValues")).length() > 0) {
            if (str.equalsIgnoreCase("LEFTPOINTS")) {
                bih.setYValues((byte)1);
            } else if (str.equalsIgnoreCase("RIGHTPOINTS")) {
                bih.setYValues((byte)2);
            } else if (str.equalsIgnoreCase("MIDPOINTS")) {
                bih.setYValues((byte)0);
            } else {
                bih.setYValues((byte)0);
                StatGraph.printOptionError("YVALUES", str);
            }
        }
        if ((str = elem.getAttribute("binAxis")).equalsIgnoreCase("false")) {
            bih.setBinAxis(false);
        }
        if ((str = elem.getAttribute("endLabels")).equalsIgnoreCase("true")) {
            bih.setEndLabels(true);
        }
        bih.setModel(crd);
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("all") && !str.equalsIgnoreCase("standard")) {
            bih.setEdgeOn(false);
            bih.setFillOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    bih.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    bih.setFillOn(true);
                    continue;
                }
                bih.setEdgeOn(false);
                bih.setFillOn(true);
                StatGraph.printOptionError("DISPLAY", opts[i]);
                break;
            }
        } else if (str.equalsIgnoreCase("all")) {
            bih.setEdgeOn(true);
            bih.setFillOn(true);
        } else {
            bih.setEdgeOn(false);
            bih.setFillOn(true);
        }
        String contextName = graph.style.getContextName();
        bih.setContextName(contextName);
        if (bih.isFillOn()) {
            FillAttrs fillStyle = bih.getFillStyle();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, bih.getContextName());
            Element elem2 = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
            if (elem2 != null) {
                StatGraph.parseFillAttrs(graph, elem2, fillStyle);
            }
        }
        if (bih.isEdgeOn()) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), bih.getEdgeStyle(), "Outlines");
            Element elem3 = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
            if (elem3 != null) {
                StatGraph.parseLineAttrs(graph, elem3, bih.getEdgeStyle());
            }
        }
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("z");
        String zVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        int ycol = m.getColumn(yVarID);
        int zcol = m.getColumn(zVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            return null;
        }
        types[0] = 0;
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 1, true)) {
            return null;
        }
        types[1] = 0;
        if (!StatGraph.checkVariable("Z", m.getColumnLabel(zcol), Double.class, 0, false, 1, true)) {
            return null;
        }
        types[2] = 0;
        return types;
    }
}

