/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.anno.PolygonAnno;
import com.sas.graphics.anno.PolylineAnno;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.UserDefinedCharacterMarker;
import com.sas.graphics.util.UserDefinedIconMarker;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BaseStatGraphPanel
extends JPanel {
    public static final String RB_KEY = "BaseStatGraphPanel.";
    private static LineBorder lineBorder = new LineBorder(new Color(1.0f, 1.0f, 1.0f, 0.0f));
    public StatGraph graph;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Border br = this.getBorder();
        this.setBorder(lineBorder);
        Graphics2D g2d = (Graphics2D)g.create();
        ArrayList<AbstractAnno> badAnnos = new ArrayList<AbstractAnno>();
        for (int i = 0; i < this.graph.annotationInFrontList.size(); ++i) {
            AbstractAnno anno = this.graph.annotationInFrontList.get(i);
            anno.paint(g2d);
            if (!anno.isBadData()) continue;
            Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)AnnotateParser.getStatement(anno)));
            badAnnos.add(anno);
        }
        for (AbstractAnno anno : badAnnos) {
            this.graph.annotationInFrontList.remove(anno);
        }
        this.setBorder(br);
        g2d.dispose();
        RepaintManager.currentManager(this).markCompletelyClean(this);
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle b = this.getBounds();
        Border br = this.getBorder();
        this.setBorder(null);
        Color c = null;
        if (!this.graph.isTransparentBackground()) {
            c = this.getBackground();
            g.setColor(c);
            g.fillRect(0, 0, b.width, b.height);
        }
        this.setBorder(lineBorder);
        Graphics2D g2d = (Graphics2D)g.create();
        ArrayList<AbstractAnno> badAnnos = new ArrayList<AbstractAnno>();
        for (int i = 0; i < this.graph.annotationInBackList.size(); ++i) {
            AbstractAnno anno = this.graph.annotationInBackList.get(i);
            anno.paint(g2d);
            if (!anno.isBadData()) continue;
            Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)AnnotateParser.getStatement(anno)));
            badAnnos.add(anno);
        }
        for (AbstractAnno anno : badAnnos) {
            this.graph.annotationInBackList.remove(anno);
        }
        this.setBorder(br);
        if (!this.graph.isTransparentBackground()) {
            this.setBackground(c);
        }
        g2d.dispose();
    }

    @Override
    protected synchronized void paintChildren(Graphics g) {
        Color c = this.getBackground();
        this.setBackground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 0));
        super.paintChildren(g);
        this.setBackground(c);
    }

    private static String parseUDMCommonOpts(Element elem, UserDefinedMarkerInterface udm) {
        double scale = 1.0;
        String str = elem.getAttribute("scale");
        if (str.length() > 0) {
            if (StatGraph.isNumber(str)) {
                scale = Double.parseDouble(str);
                if (scale <= 0.0) {
                    scale = 1.0;
                    StatGraph.printOptionError("SCALE", str);
                }
            } else {
                StatGraph.printOptionError("SCALE", str);
            }
        }
        str = elem.getAttribute("hOffset");
        double xOffset = 0.0;
        if (str.length() > 0) {
            if (StatGraph.isNumber(str)) {
                xOffset = Double.parseDouble(str);
            } else {
                StatGraph.printOptionError("HOFFSET", str);
            }
        }
        str = elem.getAttribute("vOffset");
        double yOffset = 0.0;
        if (str.length() > 0) {
            if (StatGraph.isNumber(str)) {
                yOffset = Double.parseDouble(str);
            } else {
                StatGraph.printOptionError("VOFFSET", str);
            }
        }
        double rotate = 0.0;
        str = elem.getAttribute("rotate");
        if (str.length() > 0) {
            if (StatGraph.isNumber(str)) {
                rotate = Double.parseDouble(str) * Math.PI / 180.0;
            } else {
                StatGraph.printOptionError("ROTATE", str);
            }
        }
        udm.setMarkerScaleX(scale);
        udm.setMarkerScaleY(scale);
        udm.setMarkerOffsetX(xOffset);
        udm.setMarkerOffsetY(yOffset);
        udm.setMarkerRotation(rotate);
        return elem.getAttribute("name");
    }

    public static void parseUserDefinedMarkers(BaseStatGraphPanel panel, Element sgElem, Style style) {
        StatGraph graph = panel.graph;
        GraphStyle gStyle = new GraphStyle();
        gStyle.setGraphStyle(style);
        graph.style = gStyle;
        NodeList charMarkers = sgElem.getElementsByTagName("SymbolChar");
        for (int i = 0; i < charMarkers.getLength(); ++i) {
            UserDefinedCharacterMarker udm;
            String name;
            Element elem = (Element)charMarkers.item(i);
            String charValue = elem.getAttribute("char");
            if (charValue.trim().length() == 0) continue;
            TextAttrs ta = new TextAttrs();
            String str = elem.hasAttribute("textAttrs") ? elem.getAttribute("textAttrs") : "UnicodeText";
            StyleElement se = style.getStyleElement(str);
            if (se == null && (se = style.getStyleElement("ValueText")) == null) {
                se = new TextStyleElement(null);
            }
            TextStyleElement tse = se.getAsTextStyle();
            int weight = tse.getFontWeight();
            int tstyle = tse.getFontStyle();
            int fontStyle = 0;
            if (tstyle == 2) {
                fontStyle |= 2;
            }
            if (weight == 1) {
                fontStyle |= 1;
            }
            ta.setFont(new Font(tse.getFontFamily(), fontStyle, 12));
            Element taElem = StatGraph.getOptionAttrsElement(elem, "TextAttrs");
            if (taElem != null) {
                StatGraph.parseTextAttrs(graph, taElem, ta);
            }
            if ((name = BaseStatGraphPanel.parseUDMCommonOpts(elem, (UserDefinedMarkerInterface)(udm = new UserDefinedCharacterMarker(charValue, ta.getFont(), StatGraph.dataDPIScaleFactor)))).length() == 0) continue;
            Markers.addUserDefinedMarker((String)name, (UserDefinedMarkerInterface)udm);
        }
        NodeList imageMarkers = sgElem.getElementsByTagName("SymbolImage");
        for (int i = 0; i < imageMarkers.getLength(); ++i) {
            Element elem = (Element)imageMarkers.item(i);
            String imageLoc = elem.getAttribute("image");
            if (imageLoc.length() == 0) continue;
            File file = new File(imageLoc);
            if (!new File(imageLoc).exists()) {
                Message msg = new Message(RB.getStringResource("AnnotateParser.", "imageNF.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"IMAGE", (Object)imageLoc));
                continue;
            }
            String ext = "";
            String s = file.getName();
            int idx = s.lastIndexOf(46);
            if (idx > 0 && idx < s.length() - 1) {
                ext = s.substring(idx + 1).toLowerCase();
            }
            if (!("jpeg".equalsIgnoreCase(ext) || "gif".equalsIgnoreCase(ext) || "jpg".equalsIgnoreCase(ext) || "png".equalsIgnoreCase(ext))) {
                Message msg = new Message(RB.getStringResource("StatGraph.", "imageINFF.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"IMAGE", (Object)imageLoc));
                continue;
            }
            UserDefinedIconMarker udi = new UserDefinedIconMarker(StatGraph.dataDPIScaleFactor);
            String name = BaseStatGraphPanel.parseUDMCommonOpts(elem, (UserDefinedMarkerInterface)udi);
            if (name.length() == 0) continue;
            if (udi.setImagePath(imageLoc)) {
                Markers.addUserDefinedMarker((String)name, (UserDefinedMarkerInterface)udi);
                continue;
            }
            Message msg = new Message(RB.getStringResource("StatGraph.", "imageINF.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)"IMAGE", (Object)imageLoc));
        }
        NodeList overlayMarkers = sgElem.getElementsByTagName("SymbolOverlay");
        for (int i = 0; i < overlayMarkers.getLength(); ++i) {
            BaseOverlayContainer boc;
            Simple2DOverlayComposite soc;
            Element elem = (Element)overlayMarkers.item(i);
            String name = BaseStatGraphPanel.parseUDMCommonOpts(elem, soc = (boc = (BaseOverlayContainer)LayoutOverlayParser.load(graph, elem)).getComposite());
            if (name.length() == 0) continue;
            Markers.addUserDefinedMarker((String)name, (UserDefinedMarkerInterface)soc);
        }
        NodeList regionMarkers = sgElem.getElementsByTagName("SymbolRegion");
        for (int i = 0; i < regionMarkers.getLength(); ++i) {
            String name;
            Element elem = (Element)regionMarkers.item(i);
            RegionContainer region = (RegionContainer)LayoutRegionParser.load(graph, elem);
            UserDefinedMarkerInterface udm = null;
            for (int j = 0; j < region.getComponentCount(); ++j) {
                if (!(region.getComponent(j) instanceof UserDefinedMarkerInterface)) continue;
                udm = (UserDefinedMarkerInterface)region.getComponent(j);
                break;
            }
            if (udm == null || (name = BaseStatGraphPanel.parseUDMCommonOpts(elem, udm)).length() == 0) continue;
            Markers.addUserDefinedMarker((String)name, (UserDefinedMarkerInterface)udm);
        }
        NodeList polygonMarkers = sgElem.getElementsByTagName("SymbolPolygon");
        SGAnnotationContainer ac = new SGAnnotationContainer(panel, panel);
        for (int i = 0; i < polygonMarkers.getLength(); ++i) {
            PolygonAnno anno;
            Element elem = (Element)polygonMarkers.item(i);
            String name = BaseStatGraphPanel.parseUDMCommonOpts(elem, (UserDefinedMarkerInterface)(anno = new PolygonAnno()));
            if (name.length() == 0) continue;
            AnnotateParser.loadPolygon(graph, elem, anno, (AnnotationContainer)ac);
            Markers.addUserDefinedMarker((String)name, (UserDefinedMarkerInterface)anno);
        }
        NodeList polylineMarkers = sgElem.getElementsByTagName("SymbolPolyline");
        for (int i = 0; i < polylineMarkers.getLength(); ++i) {
            PolylineAnno anno;
            Element elem = (Element)polylineMarkers.item(i);
            String name = BaseStatGraphPanel.parseUDMCommonOpts(elem, (UserDefinedMarkerInterface)(anno = new PolylineAnno()));
            if (name.length() == 0) continue;
            AnnotateParser.loadPolyline(graph, elem, anno, (AnnotationContainer)ac);
            Markers.addUserDefinedMarker((String)name, (UserDefinedMarkerInterface)anno);
        }
    }

    public void setSVGSelectionMode(boolean b) {
        StatGraph.SVGSelectionMode = b;
    }
}

