/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.MissingValues;
import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.anno.AreaAnno;
import com.sas.graphics.anno.Constants;
import com.sas.graphics.anno.DisplayAnno;
import com.sas.graphics.anno.ImageAnno;
import com.sas.graphics.anno.LineAnno;
import com.sas.graphics.anno.MarkerAnno;
import com.sas.graphics.anno.OvalAnno;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.anno.PolygonAnno;
import com.sas.graphics.anno.PolylineAnno;
import com.sas.graphics.anno.RectangleAnno;
import com.sas.graphics.anno.TextAnno;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.awt.image.ImageObserver;
import java.io.File;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.UIManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotateParser {
    public static final String RB_KEY = "AnnotateParser.";

    public static AbstractAnno load(StatGraph graph, Element elem, AnnotationContainer container) {
        String tag = elem.getTagName();
        TextAnno anno = null;
        if (tag.equals("DrawText")) {
            anno = AnnotateParser.loadText(graph, elem, null, container);
        } else if (tag.equals("DrawOval")) {
            anno = AnnotateParser.loadOval(graph, elem, null, container);
        } else if (tag.equals("DrawRectangle")) {
            anno = AnnotateParser.loadRect(graph, elem, null, container);
        } else if (tag.equals("DrawImage")) {
            anno = AnnotateParser.loadImage(graph, elem, null, container);
        } else if (tag.equals("DrawMarker")) {
            anno = AnnotateParser.loadMarker(graph, elem, null, container);
        } else if (tag.equals("DrawLine")) {
            anno = AnnotateParser.loadLine(graph, elem, null, container);
        } else if (tag.equals("DrawArrow")) {
            anno = AnnotateParser.loadArrow(graph, elem, null, container);
        } else if (tag.equals("DrawPolyline")) {
            anno = AnnotateParser.loadPolyline(graph, elem, null, container);
        } else if (tag.equals("DrawPolygon")) {
            anno = AnnotateParser.loadPolygon(graph, elem, null, container);
        }
        if (anno != null) {
            graph.addDrawObjectElementPair((AbstractAnno)anno, elem);
            anno.setSubpixelRendering(graph.subpixelRendering);
            graph.addSubpixelRenderer(anno);
        }
        return anno;
    }

    public static TextAnno loadText(StatGraph graph, Element elem, TextAnno anno, AnnotationContainer container) {
        String str;
        if (anno == null) {
            anno = new TextAnno();
        }
        if (!AnnotateParser.loadPositionAttributes(graph, elem, false, "widthUnit", null, container, (AreaAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        anno.setSVGRender(StatGraph.VGF);
        FillAttrs backAttrs = new FillAttrs();
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("backgroundAttrs"), backAttrs, "Backfill");
        backAttrs.setTransparency(1.0);
        LineAttrs borderAttrs = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("borderAttrs"), borderAttrs, "BorderLines");
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("BorderAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, borderAttrs);
                continue;
            }
            if (!elemTag.equals("BackgroundAttrs")) continue;
            StatGraph.parseFillAttrs(graph, (Element)node, backAttrs);
        }
        boolean flag = backAttrs.getTransparency() != 1.0;
        anno.setBackground(flag);
        if (flag) {
            double t = backAttrs.getTransparency();
            if (t < 0.0) {
                anno.setBackgroundColor(backAttrs.getColor());
            } else {
                Color c1 = backAttrs.getColor();
                Color c = new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), (int)(255.0 * (1.0 - t)));
                anno.setBackgroundColor(c);
            }
        }
        flag = "true".equalsIgnoreCase(elem.getAttribute("border"));
        anno.setBorder(flag);
        if (flag) {
            anno.setBorderColor(borderAttrs.getColor());
            anno.setBorderStroke(StatGraph.getStroke(borderAttrs.getLinePattern(), borderAttrs.getWidth()));
        }
        Element padAttrs = StatGraph.getOptionAttrsElement(elem, "PadAttrs");
        int left = 3;
        int right = 3;
        int top = 3;
        int bottom = 3;
        if (padAttrs == null) {
            String str2;
            if (elem.hasAttribute("pad") && StatGraph.isInteger(str2 = elem.getAttribute("pad"))) {
                right = left = Integer.parseInt(str2);
                top = left;
                bottom = right;
            }
        } else {
            String str3;
            if (padAttrs.hasAttribute("left") && StatGraph.isInteger(str3 = padAttrs.getAttribute("left"))) {
                left = Integer.parseInt(str3);
            }
            if (padAttrs.hasAttribute("right") && StatGraph.isInteger(str = padAttrs.getAttribute("right"))) {
                right = Integer.parseInt(str);
            }
            if (padAttrs.hasAttribute("top") && StatGraph.isInteger(str = padAttrs.getAttribute("top"))) {
                top = Integer.parseInt(str);
            }
            if (padAttrs.hasAttribute("bottom") && StatGraph.isInteger(str = padAttrs.getAttribute("bottom"))) {
                bottom = Integer.parseInt(str);
            }
        }
        anno.setMargins(new Insets(top, left, bottom, right));
        int anchor = 0;
        if (elem.hasAttribute("anchor")) {
            String str4 = elem.getAttribute("anchor");
            for (int i = 0; i < Constants.ALIGNMENT.length; ++i) {
                if (!Constants.ALIGNMENT[i].equalsIgnoreCase(str4)) continue;
                anchor = i;
                break;
            }
        }
        anno.setAnchor(anchor);
        if (elem.hasAttribute("rotate") && StatGraph.isNumber(str = elem.getAttribute("rotate"))) {
            double value = Double.parseDouble(str);
            anno.setRotationAngle(value * Math.PI / 180.0);
        }
        if (elem.hasAttribute("xAxis")) {
            anno.setXPrimary(elem.getAttribute("xAxis").equalsIgnoreCase("x"));
        }
        if (elem.hasAttribute("yAxis")) {
            anno.setYPrimary(elem.getAttribute("yAxis").equalsIgnoreCase("y"));
        }
        anno.setText(AnnotateParser.parseTextAndStyle(graph, elem));
        anno.setDataAntialias(graph.dataAntialiased);
        anno.setTextAntialias(graph.axisAntialiased);
        return anno;
    }

    public static TextStyle getTextandStyle(StatGraph graph, Element element, TextStyle defaultTextAttrs, String type, ArrayList<String> textList) {
        Element tae;
        TextStyle textAttrs = null;
        String str = "";
        if (type.equalsIgnoreCase("EntryItem")) {
            Node child = element.getFirstChild();
            if (child != null) {
                str = child.getNodeValue();
                str = str == null ? "" : AnnotateParser.formatValue(element.getAttribute("format"), str);
            }
        } else {
            String elemTag = "";
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node child;
                if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("EntryItem") || (child = node.getFirstChild()) == null) continue;
                String nv = child.getNodeValue();
                String fv = AnnotateParser.formatValue(((Element)node).getAttribute("format"), nv);
                str = str.concat(fv);
            }
        }
        textList.add(str);
        textAttrs = new TextStyle(defaultTextAttrs);
        str = element.getAttribute("textAttrs");
        if (str.length() > 0) {
            GraphStyle.updateTextStyle(graph, textAttrs, str);
        }
        if ((tae = StatGraph.getOptionAttrsElement(element, "TextAttrs")) != null) {
            StatGraph.parseTextAttrs(graph, tae, textAttrs);
        }
        return textAttrs;
    }

    public static AttributedString parseTextAndStyle(StatGraph graph, Element elem) {
        Font defaultFont = (Font)UIManager.get("TextPane.font");
        TextStyle textAttrs = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("textAttrs"), textAttrs, "AnnoText");
        Element tae = StatGraph.getOptionAttrsElement(elem, "TextAttrs");
        if (tae != null) {
            StatGraph.parseTextAttrs(graph, tae, textAttrs);
        }
        TextStyle defaultTextAttrs = new TextStyle(textAttrs);
        ArrayList<String> textList = new ArrayList<String>();
        ArrayList<Font> fonts = new ArrayList<Font>();
        ArrayList<Color> colors = new ArrayList<Color>();
        ArrayList<Integer> superscripts = new ArrayList<Integer>();
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String elemTag;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("EntryItem") && !elemTag.equals("Sup") && !elemTag.equals("Sub")) continue;
            Element eiElem = (Element)node;
            tae = StatGraph.getOptionAttrsElement(eiElem, "TextAttrs");
            textAttrs = tae != null ? AnnotateParser.getTextandStyle(graph, eiElem, defaultTextAttrs, elemTag, textList) : AnnotateParser.getTextandStyle(graph, eiElem, textAttrs, elemTag, textList);
            boolean superscript = elemTag.equals("Sup");
            boolean subscript = elemTag.equals("Sub");
            fonts.add(textAttrs.getFont());
            colors.add(textAttrs.getColor());
            if (superscript) {
                superscripts.add(TextAttribute.SUPERSCRIPT_SUPER);
                continue;
            }
            if (subscript) {
                superscripts.add(TextAttribute.SUPERSCRIPT_SUB);
                continue;
            }
            superscripts.add(new Integer(0));
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = textList.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
        }
        AttributedString at = new AttributedString(sb.toString());
        int start = 0;
        int end = 0;
        for (int i = 0; i < textList.size(); ++i) {
            if (textList.get(i) == null || (start = end) == (end = start + textList.get(i).length())) continue;
            Color c = (Color)colors.get(i);
            at.addAttribute(TextAttribute.FOREGROUND, c, start, end);
            Font font = (Font)fonts.get(i);
            Integer ss = (Integer)superscripts.get(i);
            if (ss == 0) {
                at.addAttribute(TextAttribute.FONT, font, start, end);
                continue;
            }
            at.addAttribute(TextAttribute.FAMILY, font.getFamily());
            at.addAttribute(TextAttribute.SIZE, new Float(font.getSize()));
            if (font.isBold()) {
                at.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, start, end);
            } else {
                at.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR, start, end);
            }
            if (font.isItalic()) {
                at.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, start, end);
            } else {
                at.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR, start, end);
            }
            at.addAttribute(TextAttribute.SUPERSCRIPT, superscripts.get(i), start, end);
        }
        if (StatGraph.useFontManager) {
            UIManager.put("TextPane.font", defaultFont);
        }
        return at;
    }

    static String formatValue(String format, String unformatted) {
        String formatted = unformatted;
        SASFormat fmt = null;
        if (format.length() > 0) {
            fmt = SASFormat.getInstance((String)format);
            if (fmt.isCharacterFormat()) {
                formatted = fmt.format((Object)unformatted);
            } else {
                try {
                    if (unformatted.startsWith(".") && unformatted.length() <= 2) {
                        if (unformatted.equals(".")) {
                            return fmt.format((Object)new Double(Double.NaN));
                        }
                        return fmt.format((Object)MissingValues.get((String)unformatted.toUpperCase()));
                    }
                    double d = Double.parseDouble(unformatted);
                    formatted = fmt.format((Object)new Double(d));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return formatted;
    }

    public static RectangleAnno loadRect(StatGraph graph, Element elem, RectangleAnno anno, AnnotationContainer container) {
        if (anno == null) {
            anno = new RectangleAnno();
        }
        if (!AnnotateParser.loadPositionAttributes(graph, elem, true, "widthUnit", "heightUnit", container, (AreaAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadDisplayAttributes(graph, elem, (DisplayAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadAreaAttributes(graph, elem, (AreaAnno)anno)) {
            return null;
        }
        if (elem.hasAttribute("cornerRadius")) {
            String str = elem.getAttribute("cornerRadius");
            if (StatGraph.isNumber(str)) {
                anno.setCornerRadius(Double.parseDouble(str));
            } else {
                StatGraph.printOptionError("CORNERRADIUS", str);
            }
        }
        return anno;
    }

    public static OvalAnno loadOval(StatGraph graph, Element elem, OvalAnno anno, AnnotationContainer container) {
        if (anno == null) {
            anno = new OvalAnno();
        }
        if (!AnnotateParser.loadPositionAttributes(graph, elem, true, "widthUnit", "heightUnit", container, (AreaAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadDisplayAttributes(graph, elem, (DisplayAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadAreaAttributes(graph, elem, (AreaAnno)anno)) {
            return null;
        }
        return anno;
    }

    public static boolean loadDisplayAttributes(StatGraph graph, Element elem, DisplayAnno anno) {
        FillAttrs fillAttrs = new FillAttrs();
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillAttrs, "AnnoShape");
        LineAttrs outlineAttrs = new LineAttrs();
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), outlineAttrs, "AnnoLine");
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("OutlineAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, outlineAttrs);
                continue;
            }
            if (!elemTag.equals("FillAttrs")) continue;
            StatGraph.parseFillAttrs(graph, (Element)node, fillAttrs);
        }
        String str = "outline";
        if (elem.hasAttribute("display")) {
            str = elem.getAttribute("display").toLowerCase().trim();
        }
        boolean flag = str.equals("all") || str.contains("fill");
        anno.setBackground(flag);
        if (flag) {
            double t = fillAttrs.getTransparency();
            if (t < 0.0) {
                anno.setBackgroundColor(fillAttrs.getColor());
            } else {
                Color c1 = fillAttrs.getColor();
                Color c = new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), (int)(255.0 * (1.0 - t)));
                anno.setBackgroundColor(c);
            }
        }
        flag = str.contains("outline") || str.equals("all") || str.equals("standard");
        anno.setBorder(flag);
        if (flag) {
            anno.setBorderColor(outlineAttrs.getColor());
            anno.setBorderStroke(StatGraph.getStroke(outlineAttrs.getLinePattern(), outlineAttrs.getWidth()));
        }
        return true;
    }

    public static boolean loadAreaAttributes(StatGraph graph, Element elem, AreaAnno anno) {
        double value;
        String str;
        int anchor = 0;
        if (elem.hasAttribute("xAxis")) {
            anno.setXPrimary(elem.getAttribute("xAxis").equalsIgnoreCase("x"));
        }
        if (elem.hasAttribute("yAxis")) {
            anno.setYPrimary(elem.getAttribute("yAxis").equalsIgnoreCase("y"));
        }
        if (elem.hasAttribute("anchor")) {
            str = elem.getAttribute("anchor");
            for (int i = 0; i < Constants.ALIGNMENT.length; ++i) {
                if (!Constants.ALIGNMENT[i].equalsIgnoreCase(str)) continue;
                anchor = i;
                break;
            }
        }
        anno.setAnchor(anchor);
        if (elem.hasAttribute("rotate") && StatGraph.isNumber(str = elem.getAttribute("rotate"))) {
            double value2 = Double.parseDouble(str);
            anno.setRotationAngle(value2 * Math.PI / 180.0);
        }
        AreaAnno aa = anno;
        if (elem.hasAttribute("xOffset") && StatGraph.isNumber(str = elem.getAttribute("xOffset"))) {
            value = Double.parseDouble(str);
            aa.setXDiscreteOffset(value);
        }
        if (elem.hasAttribute("yOffset") && StatGraph.isNumber(str = elem.getAttribute("yOffset"))) {
            value = Double.parseDouble(str);
            aa.setYDiscreteOffset(value);
        }
        return true;
    }

    public static ImageAnno loadImage(StatGraph graph, Element elem, ImageAnno anno, AnnotationContainer container) {
        if (anno == null) {
            anno = new ImageAnno();
        }
        if (!AnnotateParser.loadPositionAttributes(graph, elem, false, "sizeUnit", "sizeUnit", container, (AreaAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadAreaAttributes(graph, elem, (AreaAnno)anno)) {
            return null;
        }
        FillAttrs backAttrs = new FillAttrs();
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("backgroundAttrs"), backAttrs, "Backfill");
        backAttrs.setTransparency(1.0);
        LineAttrs borderAttrs = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("borderAttrs"), borderAttrs, "BorderLines");
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("BorderAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, borderAttrs);
                continue;
            }
            if (!elemTag.equals("BackgroundAttrs")) continue;
            StatGraph.parseFillAttrs(graph, (Element)node, backAttrs);
        }
        boolean flag = backAttrs.getTransparency() != 1.0;
        anno.setBackground(flag);
        double t = backAttrs.getTransparency();
        if (t < 0.0) {
            anno.setBackgroundColor(backAttrs.getColor());
        } else {
            Color c1 = backAttrs.getColor();
            Color c = new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), (int)(255.0 * (1.0 - t)));
            anno.setBackgroundColor(c);
        }
        flag = false;
        if (elem.hasAttribute("border")) {
            flag = elem.getAttribute("border").equalsIgnoreCase("true");
        }
        anno.setBorder(flag);
        anno.setBorderColor(borderAttrs.getColor());
        anno.setBorderStroke(StatGraph.getStroke(borderAttrs.getLinePattern(), borderAttrs.getWidth()));
        if (elem.hasAttribute("scale")) {
            String str = elem.getAttribute("scale");
            for (int i = 0; i < Constants.SCALE.length; ++i) {
                if (!Constants.SCALE[i].equalsIgnoreCase(str)) continue;
                anno.setScale(i);
                break;
            }
        }
        if (elem.hasAttribute("image")) {
            String path = elem.getAttribute("image");
            File file = new File(path);
            if (!new File(path).exists()) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "imageNF.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"IMAGE", (Object)path));
            }
            String ext = "";
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            if (!("jpeg".equalsIgnoreCase(ext) || "gif".equalsIgnoreCase(ext) || "jpg".equalsIgnoreCase(ext) || "png".equalsIgnoreCase(ext))) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "imageINFF.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"IMAGE", (Object)path));
            } else if (!anno.setResource(path)) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "imageINF.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)"IMAGE", (Object)path));
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "imageMissing.txt"));
            return null;
        }
        return anno;
    }

    public static MarkerAnno loadMarker(StatGraph graph, Element elem, MarkerAnno anno, AnnotationContainer container) {
        String str;
        if (anno == null) {
            anno = new MarkerAnno();
        }
        if (!AnnotateParser.loadPositionAttributes(graph, elem, false, null, null, container, (AreaAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        if (!AnnotateParser.loadAreaAttributes(graph, elem, (AreaAnno)anno)) {
            return null;
        }
        MarkerAttrs markerAttrs = new MarkerAttrs();
        GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("markerAttrs"), markerAttrs, "AnnoShape");
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("MarkerAttrs")) continue;
            StatGraph.parseMarkerAttrs(graph, (Element)node, markerAttrs);
        }
        anno.setColor(markerAttrs.getColor());
        anno.setSymbol(markerAttrs.getShape());
        if (elem.hasAttribute("size") && StatGraph.isNumber(str = elem.getAttribute("size"))) {
            double value = Double.parseDouble(str);
            anno.setSize((int)value);
        }
        return anno;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean loadPositionAttributes(StatGraph graph, Element elem, boolean xyreq, String widthAttribute, String heightAttribute, AnnotationContainer container, AreaAnno anno) {
        block47: {
            block55: {
                String str;
                int[] spaces;
                block46: {
                    block54: {
                        block45: {
                            block52: {
                                block53: {
                                    int heightUnit;
                                    block51: {
                                        block44: {
                                            block49: {
                                                block50: {
                                                    int widthUnit;
                                                    block48: {
                                                        int drawSpace = graph.getDrawSpace();
                                                        spaces = AnnotateParser.getSpaceTypes(graph, elem, "xSpace", drawSpace, "ySpace", drawSpace, container);
                                                        if (spaces == null) {
                                                            return false;
                                                        }
                                                        widthUnit = 0;
                                                        heightUnit = 0;
                                                        if (widthAttribute == null && heightAttribute == null) {
                                                            widthUnit = 1;
                                                            heightUnit = 1;
                                                        } else {
                                                            int i;
                                                            if (elem.hasAttribute(widthAttribute)) {
                                                                str = elem.getAttribute(widthAttribute);
                                                                for (i = 0; i < Constants.UNIT_TYPE.length; ++i) {
                                                                    if (!Constants.UNIT_TYPE[i].equalsIgnoreCase(str)) continue;
                                                                    widthUnit = i;
                                                                    break;
                                                                }
                                                            }
                                                            if (heightAttribute != null && widthAttribute.equalsIgnoreCase(heightAttribute)) {
                                                                heightUnit = widthUnit;
                                                            } else if (heightAttribute != null) {
                                                                str = elem.getAttribute(heightAttribute);
                                                                for (i = 0; i < Constants.UNIT_TYPE.length; ++i) {
                                                                    if (!Constants.UNIT_TYPE[i].equalsIgnoreCase(str)) continue;
                                                                    heightUnit = i;
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                        anno.setXSpace(spaces[0]);
                                                        anno.setYSpace(spaces[1]);
                                                        if (widthUnit != true) break block48;
                                                        anno.setWidthSpace(0);
                                                        break block44;
                                                    }
                                                    if (widthUnit != 0) break block49;
                                                    if (spaces[0] != 1 && spaces[0] != 0) break block50;
                                                    anno.setWidthSpace(1);
                                                    break block44;
                                                }
                                                if (spaces[0] == 3 || spaces[0] == 2) {
                                                    anno.setWidthSpace(3);
                                                    break block44;
                                                } else if (spaces[0] == 5 || spaces[0] == 4) {
                                                    anno.setWidthSpace(5);
                                                    break block44;
                                                } else {
                                                    anno.setWidthSpace(7);
                                                }
                                                break block44;
                                            }
                                            if (spaces[0] != 7 && spaces[0] != 6 && spaces[0] != 8) {
                                                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                                                StatGraph.printWarning(msg.toString((Object)widthAttribute.toUpperCase(), (Object)elem.getAttribute(widthAttribute)));
                                                return false;
                                            }
                                            anno.setWidthSpace(8);
                                        }
                                        if (heightAttribute == null) break block45;
                                        if (heightUnit != 1) break block51;
                                        anno.setHeightSpace(0);
                                        break block45;
                                    }
                                    if (heightUnit != 0) break block52;
                                    if (spaces[1] != 1 && spaces[1] != 0) break block53;
                                    anno.setHeightSpace(1);
                                    break block45;
                                }
                                if (spaces[1] == 3 || spaces[1] == 2) {
                                    anno.setHeightSpace(3);
                                    break block45;
                                } else if (spaces[1] == 5 || spaces[1] == 4) {
                                    anno.setHeightSpace(5);
                                    break block45;
                                } else {
                                    anno.setHeightSpace(7);
                                }
                                break block45;
                            }
                            if (spaces[1] != 7 && spaces[1] != 6 && spaces[1] != 8) {
                                StatGraph.printOptionError(heightAttribute.toUpperCase(), elem.getAttribute(heightAttribute));
                                return false;
                            }
                            anno.setHeightSpace(8);
                        }
                        if (elem.hasAttribute("width")) {
                            str = elem.getAttribute("width");
                            if (!StatGraph.isNumber(str)) {
                                StatGraph.printOptionError("WIDTH", str);
                                return false;
                            }
                            anno.setWidth(Double.parseDouble(str));
                        } else if (anno instanceof ImageAnno) {
                            anno.setWidth(new Double(Double.NaN).doubleValue());
                        } else if (anno instanceof MarkerAnno) {
                            str = elem.getAttribute("size");
                            if (!StatGraph.isNumber(str)) {
                                StatGraph.printOptionError("SIZE", str);
                                return false;
                            }
                            ((MarkerAnno)anno).setSize((int)Double.parseDouble(str));
                        }
                        if (elem.hasAttribute("height")) {
                            str = elem.getAttribute("height");
                            if (!StatGraph.isNumber(str)) {
                                StatGraph.printOptionError("HEIGHT", str);
                                return false;
                            }
                            anno.setHeight(Double.parseDouble(str));
                        } else if (anno instanceof ImageAnno) {
                            anno.setHeight(new Double(Double.NaN).doubleValue());
                        }
                        if (!elem.hasAttribute("x")) break block54;
                        str = elem.getAttribute("x");
                        if (spaces[0] == 8) {
                            if ("numeric".equalsIgnoreCase(elem.getAttribute("x_type"))) {
                                anno.setX((Object)new Double(str));
                                break block46;
                            } else {
                                anno.setX((Object)str);
                            }
                            break block46;
                        } else if (StatGraph.isNumber(str)) {
                            anno.setX((Object)new Double(str));
                            break block46;
                        } else {
                            anno.setX((Object)str);
                        }
                        break block46;
                    }
                    if (xyreq) {
                        return false;
                    }
                    anno.setX((Object)new Double(50.0));
                }
                if (!elem.hasAttribute("y")) break block55;
                str = elem.getAttribute("y");
                if (spaces[1] == 8) {
                    if ("numeric".equalsIgnoreCase(elem.getAttribute("y_type"))) {
                        anno.setY((Object)new Double(str));
                        break block47;
                    } else {
                        anno.setY((Object)str);
                    }
                    break block47;
                } else if (StatGraph.isNumber(str)) {
                    anno.setY((Object)new Double(str));
                    break block47;
                } else {
                    anno.setY((Object)str);
                }
                break block47;
            }
            if (xyreq) {
                return false;
            }
            anno.setY((Object)new Double(50.0));
        }
        anno.setContainer(container);
        return true;
    }

    public static boolean loadGeneralAttributes(StatGraph graph, Element elem, AbstractAnno anno) {
        double transparency = 0.0;
        String str = elem.getAttribute("transparency");
        if (StatGraph.isNumber(str)) {
            transparency = Double.parseDouble(str);
        }
        anno.setTransparency(transparency);
        if (elem.hasAttribute("discreteOffset")) {
            str = elem.getAttribute("discreteOffset");
            if (StatGraph.isNumber(str)) {
                double value = Double.parseDouble(str);
                if (value >= -0.5 && value <= 0.5) {
                    anno.setDiscreteOffset(value);
                } else {
                    StatGraph.printOptionError("DISCRETEOFFSET", str);
                }
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        }
        if (elem.hasAttribute("url")) {
            anno.setURL(elem.getAttribute("url"));
        }
        if (elem.hasAttribute("tooltip")) {
            anno.setTooltip(elem.getAttribute("url"));
        }
        if (elem.hasAttribute("name")) {
            anno.setName(elem.getAttribute("name"));
        }
        if (elem.hasAttribute("label")) {
            anno.setLabel(elem.getAttribute("label"));
        }
        if (elem.hasAttribute("clip")) {
            anno.setClip("true".equalsIgnoreCase(elem.getAttribute("clip")));
        }
        int justify = 1;
        if (elem.hasAttribute("justify")) {
            str = elem.getAttribute("justify");
            for (int i = 0; i < Constants.JUSTIFY.length; ++i) {
                if (!Constants.JUSTIFY[i].equalsIgnoreCase(str)) continue;
                justify = i;
                break;
            }
        }
        anno.setJustify(justify);
        TextStyle textAttrs = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("textAttrs"), textAttrs, "AnnoText");
        Element tae = StatGraph.getOptionAttrsElement(elem, "TextAttrs");
        if (tae != null) {
            StatGraph.parseTextAttrs(graph, tae, textAttrs);
        }
        anno.setFont(textAttrs.getFont());
        anno.setTextColor(textAttrs.getColor());
        int anchor = 0;
        if (elem.hasAttribute("labelPosition") || elem.hasAttribute("textAnchor")) {
            int i;
            str = elem.hasAttribute("labelPosition") ? elem.getAttribute("labelPosition") : elem.getAttribute("textAnchor");
            for (i = 0; i < Constants.POSITION.length; ++i) {
                if (!Constants.POSITION[i].equalsIgnoreCase(str)) continue;
                anchor = i;
                break;
            }
            if (anchor == 0) {
                for (i = 0; i < Constants.ALIGNMENT.length; ++i) {
                    if (!Constants.ALIGNMENT[i].equalsIgnoreCase(str)) continue;
                    anchor = i;
                    break;
                }
            }
        }
        anno.setTextAnchor(anchor);
        if (elem.hasAttribute("index")) {
            str = elem.getAttribute("index");
            if (StatGraph.isNumber(str)) {
                int value = (int)Double.parseDouble(str);
                anno.setIndex(value);
            } else {
                StatGraph.printOptionError("INDEX", str);
            }
        }
        if (elem.hasAttribute("clip")) {
            anno.setClip("true".equalsIgnoreCase(elem.getAttribute("clip")));
        }
        anno.setDataAntialias(graph.dataAntialiased);
        anno.setTextAntialias(graph.axisAntialiased);
        anno.setDataDPIScaleFactor(StatGraph.dataDPIScaleFactor);
        anno.setLinearScaleFactor(StatGraph.linearScaleFactor);
        return true;
    }

    public static LineAnno loadLine(StatGraph graph, Element elem, LineAnno anno, AnnotationContainer container) {
        double value;
        double value2;
        String str;
        int drawSpace;
        int[] types1;
        if (anno == null) {
            anno = new LineAnno();
        }
        if ((types1 = AnnotateParser.getSpaceTypes(graph, elem, "x1Space", drawSpace = graph.getDrawSpace(), "y1Space", drawSpace, container)) == null) {
            return null;
        }
        int[] types2 = AnnotateParser.getSpaceTypes(graph, elem, "x2Space", drawSpace, "y2Space", drawSpace, container);
        if (types2 == null) {
            return null;
        }
        anno.setContainer(container);
        anno.setX1Space(types1[0]);
        anno.setY1Space(types1[1]);
        anno.setX2Space(types2[0]);
        anno.setY2Space(types2[1]);
        if (elem.hasAttribute("x1")) {
            str = elem.getAttribute("x1");
            if (types1[0] == 8) {
                if ("numeric".equalsIgnoreCase(elem.getAttribute("x1_type"))) {
                    anno.setX1((Object)new Double(str));
                } else {
                    anno.setX1((Object)str);
                }
            } else if (StatGraph.isNumber(str)) {
                anno.setX1((Object)new Double(str));
            } else {
                anno.setX1((Object)str);
            }
        } else {
            StatGraph.printOptionError("X1", "");
            return null;
        }
        if (elem.hasAttribute("x1Offset") && StatGraph.isNumber(str = elem.getAttribute("x1Offset"))) {
            value2 = Double.parseDouble(str);
            anno.setX1DiscreteOffset(value2);
        }
        if (elem.hasAttribute("y1")) {
            str = elem.getAttribute("y1");
            if (types1[1] == 8) {
                if ("numeric".equalsIgnoreCase(elem.getAttribute("y1_type"))) {
                    anno.setY1((Object)new Double(str));
                } else {
                    anno.setY1((Object)str);
                }
            } else if (StatGraph.isNumber(str)) {
                anno.setY1((Object)new Double(str));
            } else {
                anno.setY1((Object)str);
            }
        } else {
            StatGraph.printOptionError("Y1", "");
            return null;
        }
        if (elem.hasAttribute("y1Offset") && StatGraph.isNumber(str = elem.getAttribute("y1Offset"))) {
            value2 = Double.parseDouble(str);
            anno.setY1DiscreteOffset(value2);
        }
        boolean primary = true;
        if (elem.hasAttribute("xAxis")) {
            str = elem.getAttribute("xAxis");
            primary = str.equalsIgnoreCase("x");
        }
        anno.setX1Primary(primary);
        primary = true;
        if (elem.hasAttribute("yAxis")) {
            str = elem.getAttribute("yAxis");
            primary = str.equalsIgnoreCase("y");
        }
        anno.setY1Primary(primary);
        if (elem.hasAttribute("x2")) {
            str = elem.getAttribute("x2");
            if (types2[0] == 8) {
                if ("numeric".equalsIgnoreCase(elem.getAttribute("x2_type"))) {
                    anno.setX2((Object)new Double(str));
                } else {
                    anno.setX2((Object)str);
                }
            } else if (StatGraph.isNumber(str)) {
                anno.setX2((Object)new Double(str));
            } else {
                anno.setX2((Object)str);
            }
        } else {
            StatGraph.printOptionError("X2", "");
            return null;
        }
        if (elem.hasAttribute("x2Offset") && StatGraph.isNumber(str = elem.getAttribute("x2Offset"))) {
            value = Double.parseDouble(str);
            anno.setX2DiscreteOffset(value);
        }
        if (elem.hasAttribute("y2")) {
            str = elem.getAttribute("y2");
            if (types2[1] == 8) {
                if ("numeric".equalsIgnoreCase(elem.getAttribute("y2_type"))) {
                    anno.setY2((Object)new Double(str));
                } else {
                    anno.setY2((Object)str);
                }
            } else if (StatGraph.isNumber(str)) {
                anno.setY2((Object)new Double(str));
            } else {
                anno.setY2((Object)str);
            }
        } else {
            StatGraph.printOptionError("Y2", "");
            return null;
        }
        if (elem.hasAttribute("y2Offset") && StatGraph.isNumber(str = elem.getAttribute("y2Offset"))) {
            value = Double.parseDouble(str);
            anno.setY2DiscreteOffset(value);
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        primary = true;
        if (elem.hasAttribute("xAxis")) {
            str = elem.getAttribute("xAxis");
            primary = str.equalsIgnoreCase("x");
        }
        anno.setX2Primary(primary);
        primary = true;
        if (elem.hasAttribute("yAxis")) {
            str = elem.getAttribute("yAxis");
            primary = str.equalsIgnoreCase("y");
        }
        anno.setY2Primary(primary);
        LineAttrs lineAttrs = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("lineAttrs"), lineAttrs, "AnnoLine");
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("LineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, lineAttrs);
        }
        anno.setLineColor(lineAttrs.getColor());
        anno.setLineStroke(StatGraph.getStroke(lineAttrs.getLinePattern(), lineAttrs.getWidth()));
        return anno;
    }

    public static LineAnno loadArrow(StatGraph graph, Element elem, LineAnno anno, AnnotationContainer container) {
        if ((anno = AnnotateParser.loadLine(graph, elem, anno, container)) == null) {
            return null;
        }
        boolean flag = true;
        if (elem.hasAttribute("arrowHeads")) {
            flag = elem.getAttribute("arrowHeads").equalsIgnoreCase("true");
        }
        anno.setArrowHeads(flag);
        if (flag) {
            int i;
            String str;
            int dir = 0;
            if (elem.hasAttribute("arrowHeadDirection")) {
                str = elem.getAttribute("arrowHeadDirection");
                for (i = 0; i < Constants.ARROWHEADDIRECTION.length; ++i) {
                    if (!Constants.ARROWHEADDIRECTION[i].equalsIgnoreCase(str)) continue;
                    dir = i;
                    break;
                }
            }
            anno.setArrowDirection(dir);
            if (elem.hasAttribute("arrowHeadShape")) {
                str = elem.getAttribute("arrowHeadShape");
                for (i = 0; i < Constants.ARROWHEADSHAPE.length; ++i) {
                    if (!Constants.ARROWHEADSHAPE[i].equalsIgnoreCase(str)) continue;
                    anno.setArrowShape(i);
                    break;
                }
            }
            if (elem.hasAttribute("arrowHeadScale") && StatGraph.isNumber(str = elem.getAttribute("arrowHeadScale"))) {
                anno.setArrowScale(Double.parseDouble(str));
            }
        }
        return anno;
    }

    public static ArrayList<PointAndSpace> getAllPoints(StatGraph graph, Element elem, AnnotationContainer container, boolean isPolygon) {
        double value;
        int drawSpace = graph.getDrawSpace();
        int[] types = AnnotateParser.getSpaceTypes(graph, elem, "xSpace", drawSpace, "ySpace", drawSpace, container);
        if (types == null) {
            return null;
        }
        if (!elem.hasAttribute("x")) {
            StatGraph.printOptionError("X", elem.getAttribute("x"));
            return null;
        }
        if (!elem.hasAttribute("y")) {
            StatGraph.printOptionError("Y", elem.getAttribute("y"));
            return null;
        }
        String str = elem.getAttribute("x");
        Object x = types[0] == 8 ? str : (StatGraph.isNumber(str) ? new Double(str) : str);
        str = elem.getAttribute("y");
        Object y = types[1] == 8 ? str : (StatGraph.isNumber(str) ? new Double(str) : str);
        boolean xPrimary = true;
        if (elem.hasAttribute("xAxis")) {
            str = elem.getAttribute("xAxis");
            xPrimary = str.equalsIgnoreCase("x");
        }
        boolean yPrimary = true;
        if (elem.hasAttribute("yAxis")) {
            str = elem.getAttribute("yAxis");
            yPrimary = str.equalsIgnoreCase("y");
        }
        double offset = 0.0;
        if (elem.hasAttribute("discreteOffset") && StatGraph.isNumber(str = elem.getAttribute("discreteOffset"))) {
            offset = Double.parseDouble(str);
        }
        ArrayList<PointAndSpace> points = new ArrayList<PointAndSpace>();
        PointAndSpace pp = new PointAndSpace(x, y, types[0], types[1], xPrimary, yPrimary);
        if (elem.hasAttribute("xOffset")) {
            str = elem.getAttribute("xOffset");
            if (StatGraph.isNumber(str)) {
                pp.xOffset = value = Double.parseDouble(str);
            }
        } else {
            pp.xOffset = offset;
        }
        if (elem.hasAttribute("yOffset")) {
            str = elem.getAttribute("yOffset");
            if (StatGraph.isNumber(str)) {
                pp.yOffset = value = Double.parseDouble(str);
            }
        } else {
            pp.yOffset = offset;
        }
        points.add(pp);
        NodeList list = elem.getElementsByTagName("Draw");
        if (!isPolygon && list.getLength() < 1) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "notEnoughPPL.txt"));
            return null;
        }
        if (isPolygon && list.getLength() < 2) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "notEnoughPPG.txt"));
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Element e = (Element)list.item(i);
            if (!e.hasAttribute("x")) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "xMissing.txt"));
                continue;
            }
            if (!e.hasAttribute("y")) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "yMissing.txt"));
                continue;
            }
            types = AnnotateParser.getSpaceTypes(graph, e, "xSpace", types[0], "ySpace", types[1], container);
            str = e.getAttribute("x");
            x = types[0] == 8 ? str : (StatGraph.isNumber(str) ? new Double(str) : str);
            str = e.getAttribute("y");
            y = types[1] == 8 ? str : (StatGraph.isNumber(str) ? new Double(str) : str);
            if (e.hasAttribute("xAxis")) {
                str = e.getAttribute("xAxis");
                xPrimary = str.equalsIgnoreCase("x");
            }
            if (e.hasAttribute("yAxis")) {
                str = e.getAttribute("yAxis");
                yPrimary = str.equalsIgnoreCase("y");
            }
            PointAndSpace p = new PointAndSpace(x, y, types[0], types[1], xPrimary, yPrimary);
            p.xOffset = offset;
            p.yOffset = offset;
            if (e.hasAttribute("discreteOffset") && StatGraph.isNumber(str = elem.getAttribute("discreteOffset"))) {
                p.xOffset = Double.parseDouble(str);
                p.yOffset = Double.parseDouble(str);
            }
            if (e.hasAttribute("xOffset") && StatGraph.isNumber(str = e.getAttribute("xOffset"))) {
                p.xOffset = Double.parseDouble(str);
            }
            if (e.hasAttribute("yOffset") && StatGraph.isNumber(str = e.getAttribute("yOffset"))) {
                p.yOffset = Double.parseDouble(str);
            }
            points.add(p);
        }
        if (!isPolygon && points.size() < 2) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "notEnoughPPL.txt"));
            return null;
        }
        if (isPolygon && points.size() < 3) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "notEnoughPPG.txt"));
            return null;
        }
        return points;
    }

    public static PolylineAnno loadPolyline(StatGraph graph, Element elem, PolylineAnno anno, AnnotationContainer container) {
        if (anno == null) {
            anno = new PolylineAnno();
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        ArrayList<PointAndSpace> points = AnnotateParser.getAllPoints(graph, elem, container, false);
        if (points == null) {
            return null;
        }
        anno.setPointSet(points);
        anno.setContainer(container);
        LineAttrs lineAttrs = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("lineAttrs"), lineAttrs, "AnnoLine");
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("LineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, lineAttrs);
        }
        anno.setLineColor(lineAttrs.getColor());
        anno.setLineStroke(StatGraph.getStroke(lineAttrs.getLinePattern(), lineAttrs.getWidth()));
        return anno;
    }

    public static int[] getSpaceTypes(StatGraph graph, Element elem, String xSpace, int xUnit, String ySpace, int yUnit, AnnotationContainer container) {
        int i;
        String str;
        if (elem.hasAttribute("drawSpace")) {
            str = elem.getAttribute("drawSpace");
            for (i = 0; i < Constants.SPACE_UNIT.length; ++i) {
                if (!Constants.SPACE_UNIT[i].equalsIgnoreCase(str)) continue;
                xUnit = i;
                yUnit = i;
                break;
            }
        }
        if (elem.hasAttribute(xSpace)) {
            str = elem.getAttribute(xSpace);
            for (i = 0; i < Constants.SPACE_UNIT.length; ++i) {
                if (!Constants.SPACE_UNIT[i].equalsIgnoreCase(str)) continue;
                xUnit = i;
                break;
            }
        }
        if (elem.hasAttribute(ySpace)) {
            str = elem.getAttribute(ySpace);
            for (i = 0; i < Constants.SPACE_UNIT.length; ++i) {
                if (!Constants.SPACE_UNIT[i].equalsIgnoreCase(str)) continue;
                yUnit = i;
                break;
            }
        }
        if (xUnit == 8 || xUnit == 6 || xUnit == 7) {
            if (!container.isDataValueSupported()) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)xSpace.toUpperCase(), (Object)elem.getAttribute(xSpace)));
                return null;
            }
            if (xUnit == -1 || xUnit >= 9) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)xSpace.toUpperCase(), (Object)elem.getAttribute(xSpace)));
                return null;
            }
        } else if (!(xUnit != 5 && xUnit != 4 || container.isWallSpaceSupported())) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)xSpace.toUpperCase(), (Object)elem.getAttribute(xSpace)));
            return null;
        }
        if (yUnit == 8 || yUnit == 7 || yUnit == 6) {
            if (!container.isDataValueSupported()) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)ySpace.toUpperCase(), (Object)elem.getAttribute(ySpace)));
                return null;
            }
            if (yUnit == -1 || yUnit >= 9) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)ySpace.toUpperCase(), (Object)elem.getAttribute(ySpace)));
                return null;
            }
        } else if (!(yUnit != 5 && yUnit != 4 || container.isWallSpaceSupported())) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "option.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)ySpace.toUpperCase(), (Object)elem.getAttribute(ySpace)));
            return null;
        }
        return new int[]{xUnit, yUnit};
    }

    public static PolygonAnno loadPolygon(StatGraph graph, Element elem, PolygonAnno anno, AnnotationContainer container) {
        if (anno == null) {
            anno = new PolygonAnno();
        }
        if (!AnnotateParser.loadGeneralAttributes(graph, elem, (AbstractAnno)anno)) {
            return null;
        }
        ArrayList<PointAndSpace> points = AnnotateParser.getAllPoints(graph, elem, container, false);
        if (points == null) {
            return null;
        }
        anno.setPointSet(points);
        anno.setContainer(container);
        if (!AnnotateParser.loadDisplayAttributes(graph, elem, (DisplayAnno)anno)) {
            return null;
        }
        return anno;
    }

    static String getStatement(AbstractAnno anno) {
        if (anno instanceof ImageAnno) {
            return "DrawImage";
        }
        if (anno instanceof TextAnno) {
            return "DrawText";
        }
        if (anno instanceof RectangleAnno) {
            return "DrawRectangle";
        }
        if (anno instanceof OvalAnno) {
            return "DrawOval";
        }
        if (anno instanceof PolygonAnno) {
            return "DrawPolygon";
        }
        if (anno instanceof PolylineAnno) {
            return "DrawPolyline";
        }
        if (anno instanceof LineAnno) {
            if (((LineAnno)anno).isArrowHeads()) {
                return "DrawArrow";
            }
            return "DrawLine";
        }
        return "";
    }

    static class myIO
    implements ImageObserver {
        Container panel;

        public myIO(Container panel) {
            this.panel = panel;
        }

        @Override
        public boolean imageUpdate(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
            if (arg1 == 32) {
                this.panel.repaint();
                return false;
            }
            return true;
        }
    }
}

