/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.SILK3DComponent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.silk3d.SILK3DChart;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.util.ColorParse;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class Overlay3DParser
extends ChartParser {
    private SILK3DComponent overlay = null;

    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    protected Element getStatgraphXML(Hashtable context, Object object) {
        return null;
    }

    protected void loadFromODS(Hashtable context, Element element) {
    }

    protected void loadFromStatgraph(Hashtable context, Element element) {
        int i;
        Vector previous;
        Object statgraphRoot;
        if (this.overlay == null) {
            this.overlay = new SILK3DComponent();
        }
        if ((statgraphRoot = context.get("STATGRAPH_ROOT_CHART")) == null) {
            if (SILKGlobal.isFlagSet((int)4)) {
                this.overlay.setPropertyValue(63, Boolean.TRUE);
            }
            this.overlay.setPropertyValue(66, Boolean.TRUE);
            this.overlay.applyPropertyChanges();
            context.put("STATGRAPH_ROOT_CHART", this.overlay);
        }
        if ((previous = (Vector)context.get("CHART_LIST")) == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i2 = 0; i2 < prev.length; ++i2) {
            SILKParser.removeChart((Hashtable)context, (String)prev[i2]);
        }
        context.put("OVERLAY_ACTIVE", Boolean.TRUE);
        context.put("CURRENT_OVERLAY", this.overlay);
        SILKParser.load((Hashtable)context, (Element)element);
        context.remove("CURRENT_OVERLAY");
        context.put("OVERLAY_ACTIVE", Boolean.FALSE);
        Object[] charts = SILKParser.getCharts((Hashtable)context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec == null) {
            return;
        }
        Object[] chartNames = new String[vec.size()];
        vec.copyInto(chartNames);
        for (i = 0; i < charts.length; ++i) {
            Object obj = charts[i];
            if (!(obj instanceof SILK3DChart)) continue;
            this.overlay.setChart((SILK3DChart)obj);
            SILKParser.removeChart((Hashtable)context, (String)chartNames[i]);
        }
        for (i = 0; i < prev.length; ++i) {
            SILKParser.addChart((Hashtable)context, (String)prev[i]);
        }
        Element axisOpts = ParserUtils.getChildWithTagName((String)"XAxisOpts", (Element)element);
        AxisInterface axis = null;
        if (axisOpts != null && (axis = this.overlay.getAxis("X")) != null) {
            ParserUtils.parseAxisOpts((AxisInterface)axis, (Element)axisOpts);
        }
        if ((axisOpts = ParserUtils.getChildWithTagName((String)"YAxisOpts", (Element)element)) != null && (axis = this.overlay.getAxis("Y")) != null) {
            ParserUtils.parseAxisOpts((AxisInterface)axis, (Element)axisOpts);
        }
        if ((axisOpts = ParserUtils.getChildWithTagName((String)"X2AxisOpts", (Element)element)) != null && (axis = this.overlay.getAxis("X2")) != null) {
            ParserUtils.parseAxisOpts((AxisInterface)axis, (Element)axisOpts);
        }
        if ((axisOpts = ParserUtils.getChildWithTagName((String)"Y2AxisOpts", (Element)element)) != null && (axis = this.overlay.getAxis("Y2")) != null) {
            ParserUtils.parseAxisOpts((AxisInterface)axis, (Element)axisOpts);
        }
        Element referenceLine = null;
        int index = 1;
        while ((referenceLine = ParserUtils.getChildWithTagName((String)"ReferenceLine", (Element)element, (int)index++)) != null) {
            Element curveLabelAttrs;
            Element lineAttrs;
            int which = 0;
            if (referenceLine.hasAttribute("x")) {
                if (referenceLine.hasAttribute("xAxis") && "x2".equalsIgnoreCase(referenceLine.getAttribute("xAxis"))) {
                    which = 3;
                }
            } else if (referenceLine.hasAttribute("y")) {
                which = referenceLine.hasAttribute("yAxis") ? ("y2".equalsIgnoreCase(referenceLine.getAttribute("yAxis")) ? 4 : 1) : 1;
            }
            AxisInterface ai = this.overlay.getAxis(new Integer(which));
            ReferenceLineInterface rli = null;
            if (referenceLine.hasAttribute("x")) {
                rli = ai.addReferenceLine((Object)new Double(ParserUtils.getDoubleValue((String)referenceLine.getAttribute("x"))), referenceLine.getAttribute("curveLabel"));
            } else if (referenceLine.hasAttribute("y")) {
                rli = ai.addReferenceLine((Object)new Double(ParserUtils.getDoubleValue((String)referenceLine.getAttribute("y"))), referenceLine.getAttribute("curveLabel"));
            }
            if (referenceLine.hasAttribute("curveLabelLocation") && "inside".equalsIgnoreCase(referenceLine.getAttribute("curveLabelLocation"))) {
                rli.setOutsideLabel(false);
            }
            if (referenceLine.hasAttribute("curveLabelPosition") && "min".equalsIgnoreCase(referenceLine.getAttribute("curveLabelPosition"))) {
                rli.setSameLabelSide(true);
            }
            if (referenceLine.hasAttribute("dataTransparency")) {
                rli.getLine().setTransparency(1.0 - ParserUtils.getDoubleValue((String)referenceLine.getAttribute("dataTransparency")));
            }
            if ((lineAttrs = ParserUtils.getChildWithTagName((String)"LineAttrs", (Element)referenceLine)) != null) {
                if (lineAttrs.hasAttribute("thickness")) {
                    rli.getLine().setWidth(ParserUtils.getIntValue((String)lineAttrs.getAttribute("thickness")));
                }
                if (lineAttrs.hasAttribute("color")) {
                    rli.getLine().setColor((Object)ColorParse.getColorFromString((String)lineAttrs.getAttribute("color")));
                }
                if (lineAttrs.hasAttribute("pattern")) {
                    rli.getLine().setPattern(ParserUtils.getIntValue((String)lineAttrs.getAttribute("pattern")));
                }
            }
            if ((curveLabelAttrs = ParserUtils.getChildWithTagName((String)"CurveLabelAttrs", (Element)referenceLine)) == null) continue;
            TextParser.parseTextElement((Element)curveLabelAttrs, (TextStyleInterface)rli.getLabel());
        }
        String n = element.getAttribute("name");
        this.name = n == null || n.length() == 0 ? ParserUtils.getUniqueChartName((Hashtable)context) : n;
        context.put(this.name, this.overlay);
    }

    public Object getObject() {
        if (this.overlay == null) {
            this.overlay = new SILK3DComponent();
        }
        return this.overlay;
    }

    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof SILK3DComponent)) {
            return false;
        }
        this.overlay = (SILK3DComponent)instance;
        return true;
    }
}

