/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.ViewPanel;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SurfacePanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = -7171273682970940238L;
    protected Vector listeners = new Vector();
    protected Roles roles = Roles.getInstance(null);
    protected JSlider opacitySlider;
    protected JCheckBox colorByCheck;
    protected JComboBox colorByCombo;
    protected JLabel opacityLabel;
    protected String opacitySliderPattern;
    protected ColorMapperChooserPanel colorMapperChooserPanel = null;
    protected ViewPanel viewPanel;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public SurfacePanel(PropertyInterface surface) {
        this.opacitySliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"SurfacePanel.OpacitySliderText.fmt", (String)"Opacity: {0,number,integer}");
        this.addPropertyListener(surface);
        this.initGUI();
        this.addListeners();
    }

    private void addListeners() {
        this.opacitySlider.addChangeListener(this);
        this.colorByCheck.addActionListener(this);
        this.colorByCombo.addActionListener(this);
    }

    private void removeListeners() {
        this.opacitySlider.removeChangeListener(this);
        this.colorByCheck.removeActionListener(this);
        this.colorByCombo.removeActionListener(this);
    }

    public boolean applyChanges() {
        boolean status = PropertyUtils.applyChanges((Vector)this.listeners);
        this.initFromSource();
        return status;
    }

    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.listeners);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.colorByCheck) {
            boolean colorBy = this.colorByCheck.isSelected();
            Object selectedRole = this.colorByCombo.getSelectedItem();
            if (colorBy) {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, (Object)selectedRole);
            } else {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, null);
            }
            this.colorByCombo.setEnabled(colorBy);
            this.colorMapperChooserPanel.initFromSource();
        } else if (source == this.colorByCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, (Object)this.colorByCombo.getSelectedItem());
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.opacityLabel = new JLabel(MessageFormat.format(this.opacitySliderPattern, new Integer(100)));
        this.opacityLabel.setFont(TabbedPropertiesDialog.dialogFont);
        Dimension labelSize = this.opacityLabel.getPreferredSize();
        this.opacityLabel.setPreferredSize(labelSize);
        this.opacityLabel.setMinimumSize(labelSize);
        this.opacitySlider = new JSlider();
        this.opacitySlider.setMinimum(0);
        this.opacitySlider.setMaximum(100);
        JPanel opacityPanel = new JPanel();
        opacityPanel.setLayout(new BorderLayout(15, 15));
        opacityPanel.setBorder(new EmptyBorder(0, 3, 0, 10));
        opacityPanel.add((Component)this.opacityLabel, "West");
        opacityPanel.add((Component)this.opacitySlider, "Center");
        this.colorByCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"SurfacePanel.ColorBy.txt", (String)"Color by:"));
        this.colorByCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByCombo = new JComboBox();
        this.colorByCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByCombo.setBackground(Color.white);
        this.colorByCombo.addItem(this.roles.getRoleObject("ROLE_X"));
        this.colorByCombo.addItem(this.roles.getRoleObject("ROLE_Y"));
        this.colorByCombo.addItem(this.roles.getRoleObject("ROLE_Z"));
        JPanel colorByPanel = new JPanel();
        colorByPanel.setLayout(new BorderLayout(15, 15));
        colorByPanel.add((Component)this.colorByCheck, "West");
        colorByPanel.add((Component)this.colorByCombo, "Center");
        this.viewPanel = new ViewPanel(true, true);
        this.viewPanel.setListeners(this.listeners);
        JPanel chartPanel = new JPanel();
        chartPanel.setLayout(new GridLayout(0, 1, 5, 5));
        chartPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        chartPanel.add(colorByPanel);
        chartPanel.add(opacityPanel);
        this.colorMapperChooserPanel = new ColorMapperChooserPanel(this.listeners);
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        panel0.setLayout(new BorderLayout(5, 5));
        panel0.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel0.add((Component)panel1, "Center");
        panel1.setLayout(new BorderLayout(5, 5));
        panel1.add((Component)chartPanel, "North");
        panel1.add((Component)this.viewPanel, "Center");
        panel1.add((Component)this.colorMapperChooserPanel, "South");
        this.add((Component)panel0, "North");
    }

    private void initFromSource() {
        this.colorMapperChooserPanel.initFromSource();
        this.viewPanel.initFromSource();
        this.removeListeners();
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10302);
        if (o != null && o instanceof Number) {
            int min = this.opacitySlider.getMinimum();
            int max = this.opacitySlider.getMaximum();
            double opacity = ((Number)o).doubleValue();
            int value = min + (int)(opacity * (double)(max - min));
            this.opacitySlider.setValue(value);
            this.opacityLabel.setText(MessageFormat.format(this.opacitySliderPattern, new Integer(value)));
        }
        Object colorBy = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10101);
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10102);
        if (o != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.colorByCheck.setSelected(false);
            this.colorByCheck.setEnabled(false);
            this.colorByCombo.setEnabled(false);
        } else {
            this.colorByCheck.setEnabled(true);
            if (colorBy == null) {
                this.colorByCheck.setSelected(false);
                this.colorByCombo.setEnabled(false);
            } else {
                this.colorByCheck.setSelected(true);
                this.colorByCombo.setEnabled(true);
                this.colorByCombo.setSelectedItem(colorBy);
            }
        }
        this.addListeners();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.opacitySlider) {
            int min = this.opacitySlider.getMinimum();
            int max = this.opacitySlider.getMaximum();
            int v = this.opacitySlider.getValue();
            double opacity = (double)(v - min) / (double)(max - min);
            opacity = Math.max(opacity, 0.0);
            opacity = Math.min(opacity, 1.0);
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10302, (Object)new Double(opacity));
            this.opacityLabel.setText(MessageFormat.format(this.opacitySliderPattern, new Integer(v)));
        }
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }
}

