/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.ViewPanel;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class Bar3DPanel
extends JPanel
implements TabPanelInterface,
ActionListener {
    private static final long serialVersionUID = -4382588519938340687L;
    protected Vector listeners = new Vector();
    protected Roles roles = Roles.getInstance(null);
    protected JCheckBox connectByCheck;
    protected JCheckBox fillConnectCheck;
    protected JComboBox connectByCombo;
    protected JCheckBox colorByCheck;
    protected JComboBox colorByCombo;
    protected JCheckBox gradientCheck;
    protected ViewPanel viewPanel;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public Bar3DPanel(PropertyInterface bar) {
        this.addPropertyListener(bar);
        this.initGUI();
        this.addListeners();
    }

    private void addListeners() {
        this.connectByCheck.addActionListener(this);
        this.fillConnectCheck.addActionListener(this);
        this.connectByCombo.addActionListener(this);
        this.colorByCheck.addActionListener(this);
        this.colorByCombo.addActionListener(this);
        this.gradientCheck.addActionListener(this);
    }

    private void removeListeners() {
        this.connectByCheck.removeActionListener(this);
        this.fillConnectCheck.removeActionListener(this);
        this.connectByCombo.removeActionListener(this);
        this.colorByCheck.removeActionListener(this);
        this.colorByCombo.removeActionListener(this);
        this.gradientCheck.removeActionListener(this);
    }

    public boolean applyChanges() {
        boolean status = PropertyUtils.applyChanges((Vector)this.listeners);
        this.initFromSource();
        return status;
    }

    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.listeners);
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.connectByCheck) {
            boolean connected = this.connectByCheck.isSelected();
            Object selectedRole = this.connectByCombo.getSelectedItem();
            if (connected) {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10004, (Object)selectedRole);
            } else {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10004, null);
            }
            this.fillConnectCheck.setEnabled(connected);
            this.connectByCombo.setEnabled(connected);
            this.gradientCheck.setEnabled(!connected);
        } else if (source == this.fillConnectCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10005, (Object)new Boolean(this.fillConnectCheck.isSelected()));
        } else if (source == this.connectByCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10004, (Object)this.connectByCombo.getSelectedItem());
        } else if (source == this.colorByCheck) {
            boolean colorBy = this.colorByCheck.isSelected();
            Object selectedRole = this.colorByCombo.getSelectedItem();
            if (colorBy) {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, (Object)selectedRole);
            } else {
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, null);
            }
            this.colorByCombo.setEnabled(colorBy);
        } else if (source == this.colorByCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10101, (Object)this.colorByCombo.getSelectedItem());
        } else if (source == this.gradientCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10006, (Object)new Boolean(this.gradientCheck.isSelected()));
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.fillConnectCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DPanel.FillConnect.txt", (String)"Fill connect"));
        this.fillConnectCheck.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel fillConnectCheckPanel = new JPanel();
        fillConnectCheckPanel.setLayout(new BorderLayout(5, 5));
        fillConnectCheckPanel.add((Component)this.fillConnectCheck, "West");
        fillConnectCheckPanel.add((Component)new JPanel(), "East");
        this.connectByCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DPanel.ConnectBy.txt", (String)"Connect by:"));
        this.connectByCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.connectByCombo = new JComboBox();
        this.connectByCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.connectByCombo.setBackground(Color.white);
        this.connectByCombo.addItem(this.roles.getRoleObject("ROLE_CATEGORY"));
        this.connectByCombo.addItem(this.roles.getRoleObject("ROLE_SERIES"));
        this.connectByCombo.setSelectedIndex(1);
        JPanel connectByPanel = new JPanel();
        connectByPanel.setLayout(new BorderLayout(15, 15));
        connectByPanel.add((Component)this.connectByCheck, "West");
        connectByPanel.add((Component)this.connectByCombo, "Center");
        JPanel barConnectPanel = new JPanel();
        barConnectPanel.setLayout(new GridLayout(0, 1, 5, 5));
        TitledBorder border = new TitledBorder(new EtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DPanel.Connect.txt", (String)"Connect"));
        border.setTitleFont(TabbedPropertiesDialog.dialogFont);
        barConnectPanel.setBorder(new CompoundBorder(border, new EmptyBorder(5, 5, 5, 5)));
        barConnectPanel.add(connectByPanel);
        barConnectPanel.add(fillConnectCheckPanel);
        this.colorByCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DPanel.ColorBy.txt", (String)"Color by:"));
        this.colorByCheck.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByCombo = new JComboBox();
        this.colorByCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorByCombo.setBackground(Color.white);
        this.colorByCombo.addItem(this.roles.getRoleObject("ROLE_CATEGORY"));
        this.colorByCombo.addItem(this.roles.getRoleObject("ROLE_SERIES"));
        JPanel colorByPanel = new JPanel();
        colorByPanel.setLayout(new BorderLayout(15, 15));
        colorByPanel.add((Component)this.colorByCheck, "West");
        colorByPanel.add((Component)this.colorByCombo, "Center");
        this.gradientCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar3DPanel.ShowGradient.txt", (String)"Show gradient"));
        this.gradientCheck.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel gradientCheckPanel = new JPanel();
        gradientCheckPanel.setLayout(new BorderLayout(5, 5));
        gradientCheckPanel.add((Component)this.gradientCheck, "West");
        gradientCheckPanel.add((Component)new JPanel(), "East");
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new GridLayout(0, 1, 5, 5));
        colorPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        colorPanel.add(colorByPanel);
        colorPanel.add(gradientCheckPanel);
        this.viewPanel = new ViewPanel(false, false);
        this.viewPanel.setListeners(this.listeners);
        JPanel chartPanel = new JPanel();
        chartPanel.setLayout(new BorderLayout(5, 5));
        chartPanel.add((Component)colorPanel, "North");
        chartPanel.add((Component)this.viewPanel, "South");
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        panel0.setLayout(new BorderLayout(5, 5));
        panel0.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel0.add((Component)panel1, "Center");
        panel1.setLayout(new BorderLayout(5, 5));
        panel1.add((Component)chartPanel, "North");
        panel1.add((Component)barConnectPanel, "Center");
        this.add((Component)panel0, "North");
    }

    private void initFromSource() {
        this.viewPanel.initFromSource();
        this.removeListeners();
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10005);
        if (o != null && o instanceof Boolean) {
            this.fillConnectCheck.setSelected((Boolean)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10006)) != null && o instanceof Boolean) {
            this.gradientCheck.setSelected((Boolean)o);
        }
        boolean connected = false;
        Object connectBy = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10004);
        if (connectBy == null) {
            connected = false;
        } else {
            connected = true;
            this.connectByCombo.setSelectedItem(connectBy);
        }
        this.connectByCheck.setSelected(connected);
        this.fillConnectCheck.setEnabled(connected);
        this.connectByCombo.setEnabled(connected);
        this.gradientCheck.setEnabled(!connected);
        Object colorBy = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10101);
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10102);
        if (o != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.colorByCheck.setSelected(false);
            this.colorByCheck.setEnabled(false);
            this.colorByCombo.setEnabled(false);
        } else {
            this.colorByCheck.setEnabled(true);
            if (colorBy == null) {
                this.colorByCheck.setSelected(false);
                this.colorByCombo.setEnabled(false);
            } else {
                this.colorByCheck.setSelected(true);
                this.colorByCombo.setEnabled(true);
                this.colorByCombo.setSelectedItem(colorBy);
            }
        }
        this.addListeners();
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }
}

