/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyUtils;
import com.sas.graphics.util.Vec3d;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class AxisOriginDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4703587869156887459L;
    protected Vector listeners = null;
    protected JPanel jContentPane = null;
    protected JPanel buttonPanel = null;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JTextField xField = null;
    protected JTextField yField = null;
    protected JTextField zField = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public AxisOriginDialog(Frame parent) {
        super(parent);
        this.setModal(true);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOriginDialog.AxisOrigin.txt", (String)"Axis Origin"));
        this.initialize();
    }

    public void setListeners(Vector listeners) {
        this.listeners = listeners;
    }

    private void addListeners() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 200, 200));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.addListeners();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new BorderLayout(5, 5));
            this.jContentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.jContentPane.add((Component)this.getInputPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        JPanel inputPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        inputPanel.add(this.getXPanel());
        inputPanel.add(this.getYPanel());
        inputPanel.add(this.getZPanel());
        return inputPanel;
    }

    private JPanel getXPanel() {
        JPanel xPanel = new JPanel(new BorderLayout(10, 10));
        JLabel xLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOriginDialog.X.txt", (String)"X:"));
        xLabel.setFont(TabbedPropertiesDialog.dialogFont);
        xPanel.add((Component)xLabel, "West");
        xPanel.add((Component)this.getXField(), "Center");
        return xPanel;
    }

    private JPanel getYPanel() {
        JPanel yPanel = new JPanel(new BorderLayout(10, 10));
        JLabel yLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOriginDialog.Y.txt", (String)"Y:"));
        yLabel.setFont(TabbedPropertiesDialog.dialogFont);
        yPanel.add((Component)yLabel, "West");
        yPanel.add((Component)this.getYField(), "Center");
        return yPanel;
    }

    private JPanel getZPanel() {
        JPanel zPanel = new JPanel(new BorderLayout(10, 10));
        JLabel zLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOriginDialog.Z.txt", (String)"Z:"));
        zLabel.setFont(TabbedPropertiesDialog.dialogFont);
        zPanel.add((Component)zLabel, "West");
        zPanel.add((Component)this.getZField(), "Center");
        return zPanel;
    }

    private JTextField getXField() {
        if (this.xField == null) {
            this.xField = new JTextField();
            this.xField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.xField;
    }

    private JTextField getYField() {
        if (this.yField == null) {
            this.yField = new JTextField();
            this.yField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.yField;
    }

    private JTextField getZField() {
        if (this.zField == null) {
            this.zField = new JTextField();
            this.zField.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.zField;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout(5, 5));
            JPanel gridPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            gridPanel.add(this.getOkButton());
            gridPanel.add(this.getCancelButton());
            this.buttonPanel.add((Component)gridPanel, "East");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.okButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOriginDialog.OK.txt", (String)"OK"));
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.cancelButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOriginDialog.Cancel.txt", (String)"Cancel"));
        }
        return this.cancelButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.setOriginProperty();
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    private void setOriginProperty() {
        Vec3d value;
        try {
            NumberFormat format = NumberFormat.getNumberInstance();
            Number x = format.parse(this.xField.getText());
            Number y = format.parse(this.yField.getText());
            Number z = format.parse(this.zField.getText());
            value = new Vec3d(x.doubleValue(), y.doubleValue(), z.doubleValue());
        }
        catch (ParseException e) {
            return;
        }
        PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10207, (Object)value);
    }

    private void initFromSource() {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10207);
        if (o instanceof Vec3d) {
            NumberFormat format = NumberFormat.getNumberInstance();
            String xText = format.format(((Vec3d)o).x);
            String yText = format.format(((Vec3d)o).y);
            String zText = format.format(((Vec3d)o).z);
            this.xField.setText(xText);
            this.yField.setText(yText);
            this.zField.setText(zText);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initFromSource();
        }
        super.setVisible(b);
    }
}

