/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d.util;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.silk3d.SILK3DObject;
import com.sas.graphics.silk.silk3d.util.ReferencePlane;
import com.sas.graphics.silk.silk3d.util.SILK3DAxis;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ANetworkRoot;
import com.sas.graphics.util.gtk.AxisDetail;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericToNumericMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.gl.AxisSet;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.SelectResult;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SILK3DAxisSet
extends SILK3DObject
implements PropertyChangeListener {
    private AxisSet axes = null;
    private SILK3DAxis xAxis = null;
    private SILK3DAxis yAxis = null;
    private SILK3DAxis zAxis = null;
    private Color gridColor = null;
    private boolean showGrids = true;
    private boolean showWalls = true;
    private Grid sideGrid = null;
    private Grid floorGrid = null;
    private Grid backGrid = null;
    private GridStyle sideGridStyle = null;
    private GridStyle floorGridStyle = null;
    private GridStyle backGridStyle = null;
    private double[] axisSize = new double[]{1.0, 1.0, 1.0};
    private Channel channel = null;
    private boolean perspective = false;
    private boolean cartesian = false;
    private Vec3d cartesianOrigin;
    private Dimension chartDimension = null;
    private boolean normalized = true;
    protected Hashtable referencePlanes = null;
    protected Style style = null;

    public SILK3DAxisSet(Channel channel) {
        super(channel);
        Color g = Color.LIGHT_GRAY.darker();
        this.gridColor = new Color(g.getRed(), g.getGreen(), g.getBlue(), 100);
        this.sideGridStyle = new GridStyle();
        this.sideGridStyle.setBackgroundColor(this.gridColor);
        this.sideGridStyle.setMajorLineColor(Color.BLACK);
        this.sideGridStyle.setBackgroundOn(this.showWalls);
        this.sideGridStyle.setBorderOn(this.showWalls);
        this.floorGridStyle = new GridStyle();
        this.floorGridStyle.setBackgroundColor(this.gridColor);
        this.floorGridStyle.setMajorLineColor(Color.BLACK);
        this.floorGridStyle.setBackgroundOn(this.showWalls);
        this.floorGridStyle.setBorderOn(this.showWalls);
        this.backGridStyle = new GridStyle();
        this.backGridStyle.setBackgroundColor(this.gridColor);
        this.backGridStyle.setMajorLineColor(Color.BLACK);
        this.backGridStyle.setBackgroundOn(this.showWalls);
        this.backGridStyle.setBorderOn(this.showWalls);
        this.axes = new AxisSet((ANetworkRoot)this.root);
        this.xAxis = new SILK3DAxis(this);
        this.yAxis = new SILK3DAxis(this);
        this.zAxis = new SILK3DAxis(this);
        Boolean minorticks = new Boolean(false);
        this.xAxis.setMinorTicks(minorticks);
        this.yAxis.setMinorTicks(minorticks);
        this.zAxis.setMinorTicks(minorticks);
        this.channel = channel;
        this.enableDepthTest = false;
        this.axes.setPerspective(this.perspective);
        this.axes.setFitScreen(true);
        this.referencePlanes = new Hashtable();
        this.cartesianOrigin = new Vec3d(0.0, 0.0, 0.0);
    }

    public SILK3DAxisSet() {
        this(null);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.axes = null;
        if (this.xAxis != null) {
            this.xAxis.dispose();
            this.xAxis = null;
        }
        if (this.yAxis != null) {
            this.yAxis.dispose();
            this.yAxis = null;
        }
        if (this.zAxis != null) {
            this.zAxis.dispose();
            this.zAxis = null;
        }
        if (this.referencePlanes != null) {
            Enumeration e = this.referencePlanes.elements();
            while (e.hasMoreElements()) {
                ReferencePlane rp = (ReferencePlane)e.nextElement();
                rp.dispose();
            }
            this.referencePlanes.clear();
            this.referencePlanes = null;
        }
        this.gridColor = null;
        this.sideGrid = null;
        this.floorGrid = null;
        this.backGrid = null;
        this.sideGridStyle = null;
        this.floorGridStyle = null;
        this.backGridStyle = null;
        this.axisSize = null;
        this.channel = null;
        this.chartDimension = null;
    }

    public void createGrids() {
        if (this.sideGrid == null && this.zMapper != null && this.xMapper != null) {
            this.sideGrid = this.axes.newSideGrid(this.zMapper, this.xMapper);
        }
        if (this.floorGrid == null && this.yMapper != null && this.xMapper != null) {
            this.floorGrid = this.axes.newFloorGrid(this.yMapper, this.xMapper);
        }
        if (this.backGrid == null && this.yMapper != null && this.zMapper != null) {
            this.backGrid = this.axes.newBackGrid(this.yMapper, this.zMapper);
        }
        if (this.sideGrid != null) {
            this.sideGrid.setStyle(this.sideGridStyle);
        }
        if (this.floorGrid != null) {
            this.floorGrid.setStyle(this.floorGridStyle);
        }
        if (this.backGrid != null) {
            this.backGrid.setStyle(this.backGridStyle);
        }
    }

    public AxisInterface getAxis(Object which) {
        if (which == null) {
            return null;
        }
        if (which instanceof String) {
            String s = (String)which;
            if (s.equalsIgnoreCase("X")) {
                return this.xAxis;
            }
            if (s.equalsIgnoreCase("Y")) {
                return this.yAxis;
            }
            if (s.equalsIgnoreCase("Z")) {
                return this.zAxis;
            }
        } else if (which instanceof Number) {
            int i = ((Number)which).intValue();
            if (i == 0) {
                return this.xAxis;
            }
            if (i == 1) {
                return this.yAxis;
            }
            if (i == 2) {
                return this.zAxis;
            }
        }
        return null;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox bounds = new BoundingBox();
        bounds.setSize(this.axisSize[0], this.axisSize[1], this.axisSize[2]);
        bounds.setCenter(this.axisSize[0] / 2.0, this.axisSize[1] / 2.0, this.axisSize[2] / 2.0);
        return bounds;
    }

    public boolean updateView(double az, double incl, double dist, Vec3d focal) {
        if (!this.perspective) {
            return false;
        }
        if (this.axes.getBoundingBox() == null) {
            this.axes.getView();
        }
        this.axes.setView(az, incl, dist, focal);
        return true;
    }

    public boolean updateView(double obliqueAngle, Vec3d focal) {
        if (this.perspective) {
            return false;
        }
        if (this.axes.getBoundingBox() == null) {
            this.axes.getView();
        }
        this.axes.setFocalPoint(focal);
        this.axes.setObliqueAngle(obliqueAngle);
        return true;
    }

    public double[] getView(double az, double incl) {
        double[] view = this.axes.getView(az, incl);
        return view;
    }

    @Override
    public boolean build(Object buildData) {
        Enumeration e = this.referencePlanes.elements();
        while (e.hasMoreElements()) {
            ((ReferencePlane)e.nextElement()).build(buildData);
        }
        boolean success = this.xAxis.build(buildData);
        success = success && this.yAxis.build(buildData);
        boolean bl = success = success && this.zAxis.build(buildData);
        if (!success) {
            return false;
        }
        if (!this.isRebuildRequired(buildData)) {
            return true;
        }
        this.networkBuilt = false;
        if (this.xMapper == null || this.yMapper == null || this.zMapper == null) {
            return false;
        }
        this.root.removeAllElements();
        Composite composite = new Composite();
        if (this.showGrids) {
            this.createGrids();
            if (this.sideGrid != null) {
                composite.addElement((Element)this.sideGrid);
            }
            if (this.floorGrid != null) {
                composite.addElement((Element)this.floorGrid);
            }
            if (this.backGrid != null) {
                composite.addElement((Element)this.backGrid);
            }
        }
        if (this.xAxis.getAxis() != null) {
            composite.addElement((Element)this.xAxis.getAxis());
        }
        if (this.yAxis.getAxis() != null) {
            composite.addElement((Element)this.yAxis.getAxis());
        }
        if (this.zAxis.getAxis() != null) {
            composite.addElement((Element)this.zAxis.getAxis());
        }
        this.root.addElement((Element)composite);
        this.rebuildRequired = false;
        this.networkBuilt = true;
        return true;
    }

    @Override
    public boolean applyStyle(Style style) {
        if (style == null) {
            return false;
        }
        this.style = style;
        Enumeration e = this.referencePlanes.elements();
        while (e.hasMoreElements()) {
            ((ReferencePlane)e.nextElement()).applyStyle(style);
        }
        Color wallColor = style.getFillStyleElement("WallFill").getFillColor();
        this.xAxis.setFireEvents(false);
        this.yAxis.setFireEvents(false);
        this.zAxis.setFireEvents(false);
        this.xAxis.applyStyle(style);
        this.yAxis.applyStyle(style);
        this.zAxis.applyStyle(style);
        this.xAxis.setFireEvents(true);
        this.yAxis.setFireEvents(true);
        this.zAxis.setFireEvents(true);
        this.floorGridStyle.setBackgroundColor(wallColor);
        this.backGridStyle.setBackgroundColor(wallColor);
        this.sideGridStyle.setBackgroundColor(wallColor);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
        return true;
    }

    @Override
    public boolean addRedrawListener(RedrawListener listener) {
        boolean rc = super.addRedrawListener(listener);
        this.xAxis.addRedrawListener(listener);
        this.yAxis.addRedrawListener(listener);
        this.zAxis.addRedrawListener(listener);
        return rc;
    }

    @Override
    public boolean removeRedrawListener(RedrawListener listener) {
        boolean rc = super.removeRedrawListener(listener);
        this.xAxis.removeRedrawListener(listener);
        this.yAxis.removeRedrawListener(listener);
        this.zAxis.removeRedrawListener(listener);
        return rc;
    }

    @Override
    public void removeAllRedrawListeners() {
        this.redrawListeners.removeAllElements();
        this.xAxis.removeAllRedrawListeners();
        this.yAxis.removeAllRedrawListeners();
        this.zAxis.removeAllRedrawListeners();
    }

    protected NumericMapper updateMapper(NumericMapper mapper, DataRange range) {
        if (mapper == null) {
            if (range instanceof ContinuousRange) {
                mapper = new ContinuousRangeToNumericMapper();
            } else if (range instanceof DiscreteRange) {
                Vector values = ((DiscreteRange)range).getValues();
                if (values == null || values.isEmpty()) {
                    mapper = new StringToNumericMapper();
                } else if (values.elementAt(0) instanceof String) {
                    mapper = new StringToNumericMapper();
                } else if (values.elementAt(0) instanceof Number) {
                    mapper = new NumericToNumericMapper();
                }
            }
            mapper.setLabelMissingValues(true);
        }
        return mapper;
    }

    public int[] getSelectedAxisTickIndex(int winX, int winY) {
        int type;
        AxisDetail details;
        Element element;
        Rectangle selectionArea = new Rectangle(winX - 5, winY - 5, 10, 10);
        SelectResult sr = this.root.selectClosest(selectionArea.x, selectionArea.y, selectionArea.width, selectionArea.height);
        int[] axisTick = null;
        if (sr != null && (element = sr.getElement()) != null && element instanceof RectangularAxis && (details = (AxisDetail)sr.getDetail()) != null && ((type = details.getType()) == 0 || type == 1)) {
            int labelIndex = details.getLabelIndex();
            int whichAxis = -1;
            if (this.xAxis != null && this.xAxis.getAxis() == element) {
                whichAxis = 0;
            } else if (this.yAxis != null && this.yAxis.getAxis() == element) {
                whichAxis = 1;
            } else if (this.zAxis != null && this.zAxis.getAxis() == element) {
                whichAxis = 2;
            }
            axisTick = new int[]{whichAxis, labelIndex};
        }
        return axisTick;
    }

    public void setAxisSize(double[] size) {
        if (size[0] != this.axisSize[0] || size[1] != this.axisSize[1] || size[2] != this.axisSize[2]) {
            this.axisSize[0] = size[0];
            this.axisSize[1] = size[1];
            this.axisSize[2] = size[2];
            this.xAxis.setSize(size[0]);
            this.yAxis.setSize(size[1]);
            this.zAxis.setSize(size[2]);
            this.setGridSize(size);
            this.axes.setSize(size[1], size[2], size[0]);
            this.axes.setBoundingBox(null);
        }
    }

    public void setAxisPadding(double[] padding) {
        this.xAxis.setPadding(padding[0]);
        this.yAxis.setPadding(padding[1]);
        this.zAxis.setPadding(padding[2]);
        this.fireRedrawEvent(1);
    }

    private void setGridSize(double[] size) {
        if (this.floorGrid != null) {
            this.floorGrid.setWidth(size[1]);
            this.floorGrid.setHeight(size[0]);
        }
        if (this.sideGrid != null) {
            this.sideGrid.setWidth(size[0]);
            this.sideGrid.setHeight(size[2]);
        }
        if (this.backGrid != null) {
            this.backGrid.setWidth(size[1]);
            this.backGrid.setHeight(size[2]);
        }
    }

    public void resetAxisSet() {
        this.xMapper = null;
        this.yMapper = null;
        this.zMapper = null;
        this.sideGrid = null;
        this.backGrid = null;
        this.floorGrid = null;
        this.xAxis.resetAxis();
        this.yAxis.resetAxis();
        this.zAxis.resetAxis();
        this.axes = new AxisSet((ANetworkRoot)this.root);
        this.axes.setCartesian(this.cartesian);
        this.axes.setCartesianOrigin(this.cartesianOrigin.x, this.cartesianOrigin.y, this.cartesianOrigin.z);
        this.axes.setPerspective(this.perspective);
        this.axes.setFitScreen(true);
        this.axisSize[0] = 1.0;
        this.axisSize[1] = 1.0;
        this.axisSize[2] = 1.0;
        this.networkBuilt = false;
        this.rebuildRequired = true;
    }

    public boolean areWallsVisible() {
        return this.showWalls;
    }

    public void setWallsVisible(boolean visible) {
        if (this.showWalls == visible) {
            return;
        }
        this.showWalls = visible;
        this.sideGridStyle.setBackgroundOn(this.showWalls);
        this.sideGridStyle.setBorderOn(this.showWalls);
        this.backGridStyle.setBackgroundOn(this.showWalls);
        this.backGridStyle.setBorderOn(this.showWalls);
        this.floorGridStyle.setBackgroundOn(this.showWalls);
        this.floorGridStyle.setBorderOn(this.showWalls);
        if (this.networkBuilt) {
            this.fireRedrawEvent(1);
        }
    }

    protected boolean setGridLines(SILK3DAxis axis, LineStyleInterface lines) {
        if (axis == null || lines == null) {
            return false;
        }
        Color lineColor = lines.getColor();
        int lineWidth = lines.getWidth();
        boolean visible = lines.isVisible();
        if (lineColor != null) {
            this.sideGridStyle.setMajorLineColor(lineColor);
            this.sideGridStyle.setMinorLineColor(lineColor);
            this.backGridStyle.setMajorLineColor(lineColor);
            this.backGridStyle.setMinorLineColor(lineColor);
            this.floorGridStyle.setMajorLineColor(lineColor);
            this.floorGridStyle.setMinorLineColor(lineColor);
        }
        this.sideGridStyle.setLineWidth(lineWidth);
        this.sideGridStyle.setMinorLineWidth(lineWidth);
        this.backGridStyle.setLineWidth(lineWidth);
        this.backGridStyle.setMinorLineWidth(lineWidth);
        this.floorGridStyle.setLineWidth(lineWidth);
        this.floorGridStyle.setMinorLineWidth(lineWidth);
        if (this.sideGrid == null || this.backGrid == null || this.floorGrid == null) {
            return false;
        }
        this.setGridlinesVisible(axis, visible);
        return true;
    }

    protected void setGridlinesVisible(SILK3DAxis axis, boolean visible) {
        if (axis == this.xAxis) {
            this.sideGridStyle.getVerticalMajorLineStyle().setVisible(visible);
            this.floorGridStyle.getHorizontalMajorLineStyle().setVisible(visible);
        } else if (axis == this.yAxis) {
            this.floorGridStyle.getVerticalMajorLineStyle().setVisible(visible);
            this.backGridStyle.getVerticalMajorLineStyle().setVisible(visible);
        } else if (axis == this.zAxis) {
            this.backGridStyle.getHorizontalMajorLineStyle().setVisible(visible);
            this.sideGridStyle.getHorizontalMajorLineStyle().setVisible(visible);
        }
    }

    @Override
    public boolean isWireframeSupported() {
        return false;
    }

    public void setPerspective(boolean b) {
        if (this.perspective == b) {
            return;
        }
        this.perspective = b;
        this.axes.setPerspective(this.perspective);
        this.fireRedrawEvent(1);
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public AxisSet getAxisSet() {
        return this.axes;
    }

    public void setChartAreaDimension(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        if (this.chartDimension == null || this.chartDimension.height != dimension.height) {
            this.xAxis.setDefaultFontSize(dimension.height);
            this.yAxis.setDefaultFontSize(dimension.height);
            this.zAxis.setDefaultFontSize(dimension.height);
        }
        this.chartDimension = dimension;
    }

    @Override
    public Object getPropertyValue(int id) {
        return null;
    }

    @Override
    public boolean isPropertySupported(int idx) {
        return false;
    }

    @Override
    protected void applyChange(int key, Object value) {
    }

    public void setRange(byte dim, int index, DataRange range) {
        if (range == null) {
            return;
        }
        switch (dim) {
            case 1: {
                this.xRange = this.mergeCartesianRange(range, dim);
                if (this.xAxis.getAxis() == null) {
                    this.xMapper = this.updateMapper(this.xMapper, this.xRange);
                    if (this.xMapper == null) {
                        return;
                    }
                    this.xAxis.setRectangularAxis(this.axes.newZAxis(this.xMapper), this.xMapper);
                }
                this.xAxis.setRange(this.xRange);
                this.xRange = this.xAxis.getOutputRange();
                break;
            }
            case 2: {
                this.yRange = this.mergeCartesianRange(range, dim);
                if (this.yAxis.getAxis() == null) {
                    this.yMapper = this.updateMapper(this.yMapper, this.yRange);
                    if (this.yMapper == null) {
                        return;
                    }
                    this.yAxis.setRectangularAxis(this.axes.newXAxis(this.yMapper), this.yMapper);
                }
                this.yAxis.setRange(this.yRange);
                this.yRange = this.yAxis.getOutputRange();
                break;
            }
            case 3: {
                this.zRange = this.mergeCartesianRange(range, dim);
                if (this.zAxis.getAxis() == null) {
                    this.zMapper = this.updateMapper(this.zMapper, this.zRange);
                    if (this.zMapper == null) {
                        return;
                    }
                    this.zAxis.setRectangularAxis(this.axes.newYAxis(this.zMapper), this.zMapper);
                }
                this.zAxis.setRange(this.zRange);
                this.zRange = this.zAxis.getOutputRange();
                break;
            }
        }
        this.updateAxisSize();
        this.setCartesianOrigin();
        this.updateReferencePlanes(dim);
    }

    private void updateAxisSize() {
        if (this.xRange == null || this.yRange == null || this.zRange == null) {
            return;
        }
        double[] axisSize = new double[]{1.0, 1.0, 1.0};
        if (!this.normalized) {
            int numX = 0;
            int numY = 0;
            if (this.xRange instanceof DiscreteRange) {
                numX = ((DiscreteRange)this.xRange).getValuesSize();
            }
            if (numX == 0) {
                numX = 1;
            }
            if (this.yRange instanceof DiscreteRange) {
                numY = ((DiscreteRange)this.yRange).getValuesSize();
            }
            if (numY == 0) {
                numY = 0;
            }
            if (numX >= numY) {
                double cellWidth = (1.0 - 2.0 * this.xAxis.getPadding()) / (double)numX;
                axisSize[0] = 1.0;
                axisSize[1] = 2.0 * this.yAxis.getPadding() + (double)numY * cellWidth;
                axisSize[2] = Math.max(axisSize[1], 0.4);
            } else {
                double cellWidth = (1.0 - 2.0 * this.yAxis.getPadding()) / (double)numY;
                axisSize[0] = 2.0 * this.xAxis.getPadding() + (double)numX * cellWidth;
                axisSize[1] = 1.0;
                axisSize[2] = Math.max(axisSize[0], 0.4);
            }
            this.setAxisSize(axisSize);
        }
    }

    public void setNormalized(boolean normalize) {
        this.normalized = normalize;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object o;
        RangeModel rm = (RangeModel)evt.getSource();
        String propName = evt.getPropertyName();
        if (propName.equalsIgnoreCase("addRange")) {
            Object o2 = evt.getNewValue();
            if (o2 instanceof Object[] && ((Object[])o2).length > 0) {
                ReferenceRange rr = (ReferenceRange)((Object[])o2)[0];
                ReferencePlane rp = this.createReferencePlane(this.getWhichAxis(rm), rr);
                if (rp == null) {
                    return;
                }
                this.referencePlanes.put(rr, rp);
            }
        } else if (propName.equalsIgnoreCase("removeRange")) {
            ReferenceRange rr;
            ReferencePlane rp;
            Object o3 = evt.getOldValue();
            if (o3 instanceof Object[] && ((Object[])o3).length > 0 && (rp = (ReferencePlane)this.referencePlanes.remove(rr = (ReferenceRange)((Object[])o3)[0])) != null) {
                rp.dispose();
            }
        } else if (propName.equalsIgnoreCase("lowValue") && (o = evt.getNewValue()) instanceof Object[] && ((Object[])o).length == 2) {
            ReferenceRange rr = (ReferenceRange)((Object[])o)[0];
            Object newVal = ((Object[])o)[1];
            ReferencePlane rp = (ReferencePlane)this.referencePlanes.get(rr);
            if (rp == null || newVal == null) {
                return;
            }
            switch (this.getWhichAxis(rm)) {
                case 1: {
                    rp.setXIntercept(newVal);
                    break;
                }
                case 2: {
                    rp.setYIntercept(newVal);
                    break;
                }
                case 3: {
                    rp.setZIntercept(newVal);
                }
            }
        }
        this.fireRedrawEvent(1);
    }

    private byte getWhichAxis(RangeModel rm) {
        if (rm == this.xAxis.getRangeModel(false)) {
            return 1;
        }
        if (rm == this.yAxis.getRangeModel(false)) {
            return 2;
        }
        if (rm == this.zAxis.getRangeModel(false)) {
            return 3;
        }
        return -1;
    }

    private ReferencePlane createReferencePlane(byte dim, ReferenceRange rr) {
        Object intercept;
        if (rr == null) {
            return null;
        }
        Object value = rr.getLowValue();
        if (!(value instanceof Number)) {
            return null;
        }
        DataRange axisRange = this.getDataRange(dim);
        if (axisRange instanceof ContinuousRange) {
            intercept = new Double(((Number)value).doubleValue());
        } else {
            int index = ((Number)value).intValue();
            Vector v = ((DiscreteRange)axisRange).getValues();
            if (index < 0 || index >= v.size()) {
                return null;
            }
            intercept = v.elementAt(index).toString();
        }
        ReferencePlane rp = new ReferencePlane();
        rp.setChannel(this.channel);
        rp.applyStyle(this.style);
        Enumeration e = this.redrawListeners.elements();
        while (e.hasMoreElements()) {
            rp.addRedrawListener((RedrawListener)e.nextElement());
        }
        rp.setBoundingBox(this.getBoundingBox());
        rp.setRange((byte)1, this.xAxis.getOutputRange());
        rp.setRange((byte)2, this.yAxis.getOutputRange());
        rp.setRange((byte)3, this.zAxis.getOutputRange());
        rp.setMap(this.getMap((byte)1), (byte)1);
        rp.setMap(this.getMap((byte)2), (byte)2);
        rp.setMap(this.getMap((byte)3), (byte)3);
        switch (dim) {
            case 1: {
                rp.setXIntercept(intercept);
                break;
            }
            case 2: {
                rp.setYIntercept(intercept);
                break;
            }
            case 3: {
                rp.setZIntercept(intercept);
                break;
            }
            default: {
                return null;
            }
        }
        return rp;
    }

    public Enumeration getReferencePlanes() {
        return this.referencePlanes.elements();
    }

    private void updateReferencePlanes(byte dim) {
        BoundingBox bbox = this.getBoundingBox();
        Enumeration planes = this.referencePlanes.elements();
        while (planes.hasMoreElements()) {
            ReferencePlane rp = (ReferencePlane)planes.nextElement();
            rp.setRange(dim, this.getDataRange(dim));
            rp.setBoundingBox(bbox);
            rp.setMap(this.getMap(dim), dim);
        }
    }

    public boolean setCartesian(boolean b) {
        if (this.cartesian == b) {
            return false;
        }
        this.cartesian = b;
        this.axes.setCartesian(this.cartesian);
        this.setCartesianOrigin();
        this.showGrids = !this.cartesian;
        this.rebuildRequired = true;
        return true;
    }

    public boolean getCartesian() {
        return this.cartesian;
    }

    public boolean setCartesianOrigin(Vec3d origin) {
        if (origin == null || this.cartesianOrigin.equals((Object)origin)) {
            return false;
        }
        this.cartesianOrigin.set(origin);
        this.setCartesianOrigin();
        return true;
    }

    private void setCartesianOrigin() {
        if (this.cartesian) {
            if (!(this.xMapper instanceof ContinuousRangeToNumericMapper)) {
                return;
            }
            double xVal = ((ContinuousRangeToNumericMapper)this.xMapper).getValue(this.cartesianOrigin.x);
            if (!(this.yMapper instanceof ContinuousRangeToNumericMapper)) {
                return;
            }
            double yVal = ((ContinuousRangeToNumericMapper)this.yMapper).getValue(this.cartesianOrigin.y);
            if (!(this.zMapper instanceof ContinuousRangeToNumericMapper)) {
                return;
            }
            double zVal = ((ContinuousRangeToNumericMapper)this.zMapper).getValue(this.cartesianOrigin.z);
            this.axes.setCartesianOrigin(yVal, zVal, xVal);
        }
    }

    public Vec3d getCartesianOrigin() {
        if (this.cartesianOrigin != null) {
            return new Vec3d(this.cartesianOrigin);
        }
        return null;
    }

    private DataRange mergeCartesianRange(DataRange range, byte dim) {
        if (this.cartesian && this.cartesianOrigin != null && range instanceof ContinuousRange) {
            switch (dim) {
                case 1: {
                    return this.insertValueIntoRange((ContinuousRange)range, this.cartesianOrigin.x);
                }
                case 2: {
                    return this.insertValueIntoRange((ContinuousRange)range, this.cartesianOrigin.y);
                }
                case 3: {
                    return this.insertValueIntoRange((ContinuousRange)range, this.cartesianOrigin.z);
                }
            }
        }
        return range;
    }

    private ContinuousRange insertValueIntoRange(ContinuousRange range, double value) {
        if (range != null) {
            if (value < range.getMin()) {
                range.setMin(value);
            }
            if (value > range.getMax()) {
                range.setMax(value);
            }
        }
        return range;
    }

    @Override
    public void draw() {
        Channel ch = this.root.getChannel();
        if (ch == null || !this.networkBuilt) {
            return;
        }
        ch.glPushAttrib(0);
        if (this.cartesian) {
            ch.glEnable(4);
        } else {
            ch.glDisable(4);
        }
        ch.glDisable(1);
        ch.glDisable(12);
        this.root.draw();
        ch.glPopAttrib();
    }
}

