/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d.scatter3d;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.GTKDataFilterSelectionVariable;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.Scatter3DInterface;
import com.sas.graphics.silk.silk3d.ColorModifier;
import com.sas.graphics.silk.silk3d.SILK3DChart;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.Scatter3DPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.ContextNames;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorCache;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLayeredPane;

public class Scatter3DObject
extends SILK3DChart
implements Scatter3DInterface,
IOBSInterface {
    private SILKNumber xRole = null;
    private SILKNumber yRole = null;
    private SILKNumber zRole = null;
    private SILKNumber colorRole = null;
    private SILKNumber colorByRole = null;
    private Variable xVar = null;
    private Variable yVar = null;
    private Variable zVar = null;
    private GTKNumericDataFilterVariable colorVar = null;
    private ContinuousRangeToColorMapper colorMapper = null;
    private int xSort = 0;
    private int ySort = 0;
    private int zSort = 0;
    private GTKDataFilterSelectionVariable selectionVar;
    private Calculator edgeWidthCalculator;
    protected static final int defaultMarkerSize = 10;
    protected static final int minMarkerSize = 2;
    protected static final int maxMarkerSize = 25;
    protected boolean markerFilled = true;
    protected boolean markerOutlinesOn = true;
    protected Color markerColor = Color.BLUE;
    protected int markerSize = 10;
    protected int markerShape = 19;
    protected Color markerOutlineColor = Color.BLUE;
    private ResourceBundle rb = null;
    private String probeFormat = null;
    public static final int[] supportedScatterProperties = new int[]{2018, 2006, 2009, 2008, 19001, 19003, 19002, 10116, 10101, 10102, 24, 25, 23, 433, 426, 434, 441};
    public static final int[] unsupportedProperties = new int[]{10300, 10301};

    public Scatter3DObject() {
        Roles role = Roles.getInstance(null);
        this.xRole = role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, (Object)"X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.yRole = role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, (Object)"Y", 1);
        this.roles.setRoleType((Object)this.yRole, 0);
        this.zRole = role.getRoleObject("ROLE_Z");
        this.roles.newRole((Object)this.zRole, (Object)"Z", 1);
        this.roles.setRoleType((Object)this.zRole, 0);
        this.colorRole = role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, (Object)"Color", 1);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.colorVar = new GTKNumericDataFilterVariable();
        this.colorMapper = new ContinuousRangeToColorMapper();
        this.selectionVar = new GTKDataFilterSelectionVariable();
        this.edgeWidthCalculator = new Calculator("inA==1?3:1");
        this.normalized = true;
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk3d.scatter3d.silk_scatter3d_NLS");
        this.probeFormat = ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DObject.Probe.fmt.txt", (String)"{0} \t= \t{1}");
        this.setSupportedProperties(supportedScatterProperties);
        this.removePropertySupport(unsupportedProperties);
        this.userSetProperties.appendProperties(supportedScatterProperties);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.xRole = null;
        this.yRole = null;
        this.zRole = null;
        this.colorRole = null;
        this.colorByRole = null;
        this.xVar = null;
        this.yVar = null;
        this.zVar = null;
        this.colorVar = null;
        this.colorMapper = null;
        this.selectionVar = null;
        this.markerColor = null;
        this.markerOutlineColor = null;
        this.rb = null;
        if (this.silkColorMapper != null) {
            this.silkColorMapper.unRegister((CellItemInterface)this);
        }
        this.silkColorMapper = null;
    }

    protected void setRole(RoleEvent e) {
        if (this.dataFilter == null) {
            return;
        }
        switch (e.role) {
            case 24: {
                this.disconnectMapper(this.xMapper);
                if (this.xVar != null) {
                    this.xVar.disconnect();
                }
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                    this.xMapper = new ContinuousRangeToNumericMapper();
                    this.xVar = new GTKNumericDataFilterVariable();
                } else {
                    if (this.colorByRole == this.xRole) {
                        this.colorByRole = null;
                    }
                    this.xMapper = new StringToNumericMapper();
                    this.xVar = new GTKStringDataFilterVariable();
                }
                this.connectVariableToData(this.xVar, this.roles.getVariable((Object)this.xRole, 0));
                this.connectMapperToVariable(this.xMapper, this.xVar);
                this.xVar.setUniqueValueSort(this.xSort);
                break;
            }
            case 25: {
                this.disconnectMapper(this.yMapper);
                if (this.yVar != null) {
                    this.yVar.disconnect();
                }
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                    this.yMapper = new ContinuousRangeToNumericMapper();
                    this.yVar = new GTKNumericDataFilterVariable();
                } else {
                    if (this.colorByRole == this.yRole) {
                        this.colorByRole = null;
                    }
                    this.yMapper = new StringToNumericMapper();
                    this.yVar = new GTKStringDataFilterVariable();
                }
                this.connectVariableToData(this.yVar, this.roles.getVariable((Object)this.yRole, 0));
                this.connectMapperToVariable(this.yMapper, this.yVar);
                this.yVar.setUniqueValueSort(this.ySort);
                break;
            }
            case 51: {
                this.disconnectMapper(this.zMapper);
                if (this.zVar != null) {
                    this.zVar.disconnect();
                }
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.zRole, 0))) {
                    this.zMapper = new ContinuousRangeToNumericMapper();
                    this.zVar = new GTKNumericDataFilterVariable();
                } else {
                    if (this.colorByRole == this.zRole) {
                        this.colorByRole = null;
                    }
                    this.zMapper = new StringToNumericMapper();
                    this.zVar = new GTKStringDataFilterVariable();
                }
                this.connectVariableToData(this.zVar, this.roles.getVariable((Object)this.zRole, 0));
                this.connectMapperToVariable(this.zMapper, this.zVar);
                this.zVar.setUniqueValueSort(this.zSort);
            }
        }
        if (e.role == 2 || this.colorByRole != null && e.role == this.colorByRole.intValue()) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireLayerListenerChanged(6, this.colorRole);
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.disconnectMapper(this.xMapper);
                this.xMapper = null;
                if (this.xVar != null) {
                    this.xVar.disconnect();
                }
                this.xVar = null;
                break;
            }
            case 25: {
                this.disconnectMapper(this.yMapper);
                this.yMapper = null;
                if (this.yVar != null) {
                    this.yVar.disconnect();
                }
                this.yVar = null;
                break;
            }
            case 51: {
                this.disconnectMapper(this.zMapper);
                this.zMapper = null;
                if (this.zVar != null) {
                    this.zVar.disconnect();
                }
                this.zVar = null;
            }
        }
        if (e.role == 2 && this.colorByRole != null) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireLayerListenerChanged(6, this.colorRole);
        }
    }

    @Override
    protected void updateVariables() {
        if (this.xVar != null) {
            this.xVar.setModified(true);
        }
        if (this.yVar != null) {
            this.yVar.setModified(true);
        }
        if (this.zVar != null) {
            this.zVar.setModified(true);
        }
        if (this.selectionVar != null) {
            this.selectionVar.setModified(true);
        }
        if (this.colorVar != null) {
            this.colorVar.setModified(true);
        }
    }

    @Override
    protected void validateData() {
    }

    private void resetX() {
        if (this.xVar != null) {
            this.xVar.disconnect();
            this.xVar = null;
        }
        this.disconnectMapper(this.xMapper);
        this.xMapper = null;
    }

    private void resetY() {
        if (this.yVar != null) {
            this.yVar.disconnect();
            this.yVar = null;
        }
        this.disconnectMapper(this.yMapper);
        this.yMapper = null;
    }

    private void resetZ() {
        if (this.zVar != null) {
            this.zVar.disconnect();
            this.zVar = null;
        }
        this.disconnectMapper(this.zMapper);
        this.zMapper = null;
    }

    @Override
    protected void applyStyleElement() {
        int markerSymbol;
        this.markerColor = this.style.getFillStyleElement(this.styleElement).getFillColor();
        this.markerOutlineColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        this.markerShape = markerSymbol = this.style.getDataStyleElement(this.styleElement).getMarkerSymbol();
        this.markerFilled = Markers.isFilled((int)markerSymbol);
    }

    @Override
    public boolean build(Object buildData) {
        if (!this.isRebuildRequired(buildData)) {
            return true;
        }
        this.rebuildRequired = false;
        Object xvar = null;
        Object yvar = null;
        Object zvar = null;
        Object cvar = null;
        Object colorbyvar = null;
        xvar = this.getObject(this.roles.getVariable((Object)this.xRole));
        yvar = this.getObject(this.roles.getVariable((Object)this.yRole));
        zvar = this.getObject(this.roles.getVariable((Object)this.zRole));
        cvar = this.getObject(this.roles.getVariable((Object)this.colorRole));
        if (this.colorByRole != null) {
            colorbyvar = this.getObject(this.roles.getVariable((Object)this.colorByRole));
        }
        if (!this.dataFilter.isNumericVariable(cvar)) {
            cvar = null;
        }
        if (!this.dataFilter.isNumericVariable(colorbyvar)) {
            colorbyvar = null;
        }
        if (this.dataFilter.getNumberObservations(-1) == 0) {
            this.networkBuilt = false;
            this.errorCode = 2;
        } else if (xvar == null || yvar == null || zvar == null) {
            this.networkBuilt = false;
            this.errorCode = 4;
        } else {
            if (cvar != null) {
                this.connectVariableToData((Variable)this.colorVar, cvar.toString());
            } else if (colorbyvar != null) {
                this.connectVariableToData((Variable)this.colorVar, colorbyvar.toString());
            } else {
                this.colorVar.disconnect();
            }
            this.initializeColorMapper();
            this.networkBuilt = this.buildNetwork();
            this.errorCode = 0;
        }
        this.rebuildRequired = !this.networkBuilt;
        return this.networkBuilt;
    }

    private void initializeColorMapper() {
        if (this.colorMapper != null && this.colorVar != null && this.colorVar.isConnected()) {
            this.initColorRamp();
            double[] breakValues = new double[Double.isNaN(this.silkColorMapper.getNeutralValue()) ? 2 : 3];
            int count = 0;
            breakValues[count++] = this.silkColorMapper.getMinValue();
            if (!Double.isNaN(this.silkColorMapper.getNeutralValue())) {
                breakValues[count++] = this.silkColorMapper.getNeutralValue();
            }
            breakValues[count++] = this.silkColorMapper.getMaxValue();
            Color[] rampClrs = new Color[this.silkColorMapper.getNeutralColor() == null ? 2 : 3];
            count = 0;
            rampClrs[count++] = this.silkColorMapper.getMinColor();
            if (this.silkColorMapper.getNeutralColor() != null) {
                rampClrs[count++] = this.silkColorMapper.getNeutralColor();
            }
            rampClrs[count++] = this.silkColorMapper.getMaxColor();
            int alpha = (int)(this.opacity * 255.0);
            for (int i = 0; i < rampClrs.length; ++i) {
                rampClrs[i] = new Color(rampClrs[i].getRed(), rampClrs[i].getGreen(), rampClrs[i].getBlue(), alpha);
            }
            this.colorMapper.input.connectFrom(this.colorVar.value);
            this.colorMapper.setColorSpectrumValues(breakValues);
            this.colorMapper.setColorSpectrumColors(rampClrs);
            this.colorMapper.setMissingReplacement(this.style.getFillStyleElement("Missing").getFillColor());
            this.colorMapper.setReplaceMissingValues(true);
        } else {
            this.colorMapper.input.disconnect();
        }
    }

    public boolean buildNetwork() {
        if (this.xMapper == null || this.yMapper == null || this.zMapper == null) {
            return false;
        }
        this.root.removeAllElements();
        Marker markers = new Marker();
        markers.coordX.connectFrom((NumericPipe)this.yMapper);
        markers.coordY.connectFrom((NumericPipe)this.zMapper);
        markers.coordZ.connectFrom((NumericPipe)this.xMapper);
        markers.type.setValue(this.markerShape);
        markers.size.setValue(this.markerSize);
        markers.edgeWidth.connectFrom(this.edgeWidthCalculator.value);
        String zId = this.roles.getVariable((Object)this.zRole, 0).toString();
        StyleElement se = SILKUtilities.getStyleElement((String)zId, (int)-1, (int)1, (Style)this.style, (String)this.styleElement, null);
        DataStyleElement dse = se.getAsDataStyle();
        Color opaqueFillColor = dse.getFillColor();
        Color opaqueOutlineColor = dse.getLineColor();
        int alpha = (int)(this.opacity * 255.0);
        Color fillColor = new Color(opaqueFillColor.getRed(), opaqueFillColor.getGreen(), opaqueFillColor.getBlue(), alpha);
        Color outlineColor = new Color(opaqueOutlineColor.getRed(), opaqueOutlineColor.getGreen(), opaqueOutlineColor.getBlue(), alpha);
        if (this.colorMapper != null && this.colorMapper.input.isConnected()) {
            ColorCache colorCache = new ColorCache();
            colorCache.input.connectFrom(this.colorMapper.value);
            markers.color.connectFrom(colorCache.value);
            markers.highlightFillColor.connectFrom(colorCache.value);
            ColorCache outlineCache = new ColorCache();
            outlineCache.input.connectFrom((ColorPipe)new ColorModifier(colorCache.value, ColorModifier.COLOR_DARKER, 0.2));
            markers.highlightEdgeColor.connectFrom(outlineCache.value);
            if (this.markerOutlinesOn) {
                markers.edgeColor.connectFrom(outlineCache.value);
            } else {
                markers.edgeColor.connectFrom(colorCache.value);
            }
        } else {
            markers.color.setValue(fillColor);
            markers.highlightFillColor.setValue(fillColor);
            markers.highlightEdgeColor.setValue(outlineColor);
            if (this.markerOutlinesOn) {
                markers.edgeColor.setValue(outlineColor);
            } else {
                markers.edgeColor.setValue(fillColor);
            }
        }
        markers.highlightOn.connectFrom(this.selectionVar.value);
        this.root.addElement((Element)markers);
        return true;
    }

    @Override
    protected int getRoleInt(Object role) {
        int roleInt = -1;
        if (role != null) {
            if (role instanceof String) {
                String s = (String)role;
                if (s.equalsIgnoreCase("x") || s.equalsIgnoreCase(this.xRole.toString())) {
                    roleInt = this.xRole.intValue();
                } else if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase(this.yRole.toString())) {
                    roleInt = this.yRole.intValue();
                } else if (s.equalsIgnoreCase("z") || s.equalsIgnoreCase(this.zRole.toString())) {
                    roleInt = this.zRole.intValue();
                }
            } else if (role instanceof Number) {
                roleInt = ((Number)role).intValue();
            }
        }
        return roleInt;
    }

    public Object[] getMarkerValues(int winX, int winY, boolean formatted) {
        Element element;
        SelectResult sr = this.root.selectClosest(winX, winY, 1, 1);
        Object[] markerValues = null;
        if (sr != null && (element = sr.getElement()) != null) {
            int index = sr.getValueIndex();
            markerValues = new Object[3];
            try {
                markerValues[0] = this.xVar instanceof StringVariable ? (formatted ? ((StringVariable)this.xVar).formattedValue.getValue(index) : ((StringVariable)this.xVar).value.getValue(index)) : (formatted ? ((NumericVariable)this.xVar).formattedValue.getValue(index) : new Double(((NumericVariable)this.xVar).value.getValue(index)));
                markerValues[1] = this.yVar instanceof StringVariable ? (formatted ? ((StringVariable)this.yVar).formattedValue.getValue(index) : ((StringVariable)this.yVar).value.getValue(index)) : (formatted ? ((NumericVariable)this.yVar).formattedValue.getValue(index) : new Double(((NumericVariable)this.yVar).value.getValue(index)));
                markerValues[2] = this.zVar instanceof StringVariable ? (formatted ? ((StringVariable)this.zVar).formattedValue.getValue(index) : ((StringVariable)this.zVar).value.getValue(index)) : (formatted ? ((NumericVariable)this.zVar).formattedValue.getValue(index) : new Double(((NumericVariable)this.zVar).value.getValue(index)));
            }
            catch (MissingValueException e) {
                return null;
            }
        }
        return markerValues;
    }

    private Point getAbsLocation() {
        Component cc = this.root.getChannel().getComponent();
        Point location = cc.getLocation();
        for (Container parent = cc.getParent(); parent != null && !(parent instanceof BaseElementComponent) && !(parent instanceof JLayeredPane); parent = parent.getParent()) {
            location.x += parent.getX();
            location.y += parent.getY();
        }
        return location;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        boolean extSel;
        if (this.getActionMode() == 14) {
            if (!(selectRegion instanceof Shape)) {
                return false;
            }
            Shape selectShape = (Shape)selectRegion;
            Vector selectableShapes = new Vector();
            Vector feedback = new Vector();
            Channel channel = this.root.getChannel();
            channel.glFeedbackBuffer(3, feedback);
            channel.glRenderMode(2);
            channel.glPushMatrix();
            this.root.draw(channel, true);
            channel.glPopMatrix();
            channel.glRenderMode(0);
            NetworkRoot.addFeedbackToSelectableShape(feedback, selectableShapes);
            Point location = this.getAbsLocation();
            SelectableShape.translate(selectableShapes, (int)location.x, (int)location.y);
            Vector<Integer> selectedIndices = new Vector<Integer>();
            if (selectableShapes.size() > 0) {
                for (int i = selectableShapes.size() - 1; i >= 0; --i) {
                    SelectableShape selectableShape = (SelectableShape)selectableShapes.elementAt(i);
                    if (!selectShape.intersects(selectableShape.getShape().getBounds2D())) continue;
                    selectedIndices.add(selectableShape.getSelectResult().getValueIndex());
                }
                if (selectedIndices.size() > 0) {
                    this.dataFilter.setSelected(selectedIndices, true);
                }
            }
            return true;
        }
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        boolean bl = extSel = (event.getModifiers() & 2) != 0;
        if (selectArea.isEmpty()) {
            this.selectMarker(selectArea.getLocation(), extSel);
        } else {
            this.selectMarkers(selectArea);
        }
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (!this.networkBuilt) {
            return null;
        }
        Object[] values = this.getMarkerValues(screenX, screenY, true);
        if (values == null) {
            return null;
        }
        Object xvar = this.roles.getVariable((Object)RoleInterface.ROLE_X, 0);
        Object yvar = this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0);
        Object zvar = this.roles.getVariable((Object)RoleInterface.ROLE_Z, 0);
        Object xlabel = this.dataFilter.getVariableDescription(xvar);
        Object ylabel = this.dataFilter.getVariableDescription(yvar);
        Object zlabel = this.dataFilter.getVariableDescription(zvar);
        Message probeMessage = new Message(this.probeFormat);
        String xTip = probeMessage.toString(xlabel, values[0]);
        String yTip = probeMessage.toString(ylabel, values[1]);
        String zTip = probeMessage.toString(zlabel, values[2]);
        String tip = xTip + "\n" + yTip + "\n" + zTip;
        return tip;
    }

    public void selectMarkers(Rectangle r) {
        if (r == null || r.isEmpty()) {
            return;
        }
        Vector selections = this.root.select(r.x, r.y, r.width, r.height, true, true);
        this.dataFilter.unselectAll();
        this.dataFilter.setSelected((Object)selections, true, (IOBSInterface)this);
    }

    public void selectMarker(Point pt, boolean toggle) {
        SelectResult sr;
        if (pt == null) {
            return;
        }
        if (!toggle) {
            this.dataFilter.unselectAll();
        }
        if ((sr = this.root.selectClosest(pt.x, pt.y, 1, 1)) == null) {
            return;
        }
        if (toggle && this.dataFilter.isSelected((long)sr.getValueIndex())) {
            this.dataFilter.setSelected((long)sr.getValueIndex(), false);
        } else {
            this.dataFilter.setSelected((long)sr.getValueIndex(), true);
        }
    }

    public long getObservationIndex(Object o) {
        if (o == null) {
            return -1L;
        }
        return ((SelectResult)o).getValueIndex();
    }

    @Override
    public double[] getPreferredAxisSize() {
        if (!this.networkBuilt) {
            return null;
        }
        double xSpan = 0.0;
        double ySpan = 0.0;
        double zSpan = 0.0;
        double[] size = new double[]{1.0, 1.0, 1.0};
        if (this.normalized) {
            return size;
        }
        if (!(this.xRange instanceof ContinuousRange)) {
            return size;
        }
        xSpan = ((ContinuousRange)this.xRange).getMax() - ((ContinuousRange)this.xRange).getMin();
        if (!(this.yRange instanceof ContinuousRange)) {
            return size;
        }
        ySpan = ((ContinuousRange)this.yRange).getMax() - ((ContinuousRange)this.yRange).getMin();
        if (!(this.zRange instanceof ContinuousRange)) {
            return size;
        }
        zSpan = ((ContinuousRange)this.zRange).getMax() - ((ContinuousRange)this.zRange).getMin();
        double max = Math.max(xSpan, Math.max(ySpan, zSpan));
        double min = Math.min(xSpan, Math.min(ySpan, zSpan));
        if (min / max < 0.2) {
            size[0] = xSpan * 0.2 / min;
            size[1] = ySpan * 0.2 / min;
            size[2] = zSpan * 0.2 / min;
        } else {
            size[0] = xSpan / max;
            size[1] = ySpan / max;
            size[2] = zSpan / max;
        }
        return size;
    }

    @Override
    protected boolean areRequiredVariablesSet() {
        return this.getObject(this.roles.getVariable((Object)this.xRole)) != null && this.getObject(this.roles.getVariable((Object)this.yRole)) != null && this.getObject(this.roles.getVariable((Object)this.zRole)) != null;
    }

    @Override
    public void setColorBy(Object role) {
        SILKNumber oldColorBy = this.colorByRole;
        int roleInt = this.getRoleInt(role);
        switch (roleInt) {
            case 24: {
                this.colorByRole = this.xRole;
                break;
            }
            case 25: {
                this.colorByRole = this.yRole;
                break;
            }
            case 51: {
                this.colorByRole = this.zRole;
                break;
            }
            default: {
                this.colorByRole = null;
            }
        }
        if (this.dataFilter != null && this.colorByRole != null && !this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.colorByRole, 0))) {
            this.colorByRole = null;
        }
        if (oldColorBy != this.colorByRole) {
            this.userSetProperties.set(10101);
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireLayerListenerChanged(6, this.colorRole);
            this.rebuildRequired = true;
            this.fireRedrawEvent(1);
        }
    }

    @Override
    public SILKNumber getColorBy() {
        return this.colorByRole;
    }

    private boolean isColorMapped() {
        if (this.colorRole == null) {
            return false;
        }
        Object cvar = this.getObject(this.roles.getVariable((Object)this.colorRole));
        return cvar != null;
    }

    @Override
    public boolean isLegendNeeded() {
        if (this.isColorMapped()) {
            return true;
        }
        return this.colorByRole != null;
    }

    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.colorRole.equals((Object)currentLegend)) {
            if (this.isColorMapped()) {
                return this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
            }
            if (this.colorByRole != null) {
                return this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.colorByRole, 0));
            }
            return null;
        }
        return null;
    }

    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null || !this.colorRole.equals((Object)currentLegend)) {
            return null;
        }
        if (this.silkColorMapper == null) {
            this.initColorRamp();
        }
        if (this.silkColorMapper == null) {
            return null;
        }
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
        ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4);
        if (r == null) {
            return null;
        }
        Color c = this.silkColorMapper.getColor(r.getMin());
        double cv = r.getMin();
        MarkerAttrib msi = new MarkerAttrib(true, c);
        legendEntries.addElement(new LegendEntry((Object)new Double(cv), (MarkerStyleInterface)msi, null));
        c = this.silkColorMapper.getNeutralColor();
        if (c != null && r.contains((DataPoint)new ContinuousPoint(this.silkColorMapper.getNeutralValue()))) {
            cv = this.silkColorMapper.getNeutralValue();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry((Object)new Double(cv), (MarkerStyleInterface)msi, null));
        }
        c = this.silkColorMapper.getColor(r.getMax());
        cv = r.getMax();
        msi = new MarkerAttrib(true, c);
        legendEntries.addElement(new LegendEntry((Object)new Double(cv), (MarkerStyleInterface)msi, null));
        return legendEntries;
    }

    public boolean isMarkerFilled() {
        return this.markerFilled;
    }

    public void setMarkerFilled(boolean fill) {
    }

    public boolean areMarkerOutlinesOn() {
        return this.markerOutlinesOn;
    }

    public void setMarkerOutlinesOn(boolean on) {
        if (this.markerOutlinesOn != on) {
            this.markerOutlinesOn = on;
            this.userSetProperties.set(2018);
            this.rebuildRequired = true;
            this.fireRedrawEvent(1);
        }
    }

    public Object getMarkerColor() {
        return this.markerColor;
    }

    public boolean setMarkerColor(Object value) {
        return false;
    }

    public Object getMarkerSize() {
        return new Integer(this.markerSize);
    }

    public boolean setMarkerSize(Object value) {
        if (value == null || !(value instanceof Number)) {
            return false;
        }
        if (((Number)value).intValue() == this.markerSize) {
            return true;
        }
        this.markerSize = ((Number)value).intValue();
        this.userSetProperties.set(2006);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
        return true;
    }

    public boolean areMarkersAutoSized() {
        return false;
    }

    public void setAutoSizeMarkers(boolean auto) {
    }

    public Object getMarkerShape() {
        return new Integer(this.markerShape);
    }

    public String getMarkerShapeString() {
        return null;
    }

    public boolean setMarkerShape(Object shape) {
        if (shape == null) {
            return false;
        }
        int oldValue = this.markerShape;
        if (shape instanceof String) {
            return false;
        }
        if (shape instanceof Number) {
            this.markerShape = ((Number)shape).intValue();
            if (this.markerShape == oldValue) {
                return true;
            }
        } else {
            return false;
        }
        this.userSetProperties.set(2015);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
        return true;
    }

    public Color getMarkerOutlineColor() {
        return this.markerOutlineColor;
    }

    public boolean setMarkerOutlineColor(Object color) {
        return false;
    }

    public boolean areOutlinesAutoColored() {
        return false;
    }

    public boolean setAutoColorOutlines(boolean auto) {
        return false;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                if (value == null) break;
                String leg = value.toString();
                if (leg.equalsIgnoreCase(this.colorRole.toString()) || leg.equalsIgnoreCase(this.colorRole.getEnglishName())) {
                    this.currentLegend = this.colorRole;
                } else if (this.colorByRole != null && (leg.equalsIgnoreCase(this.colorByRole.toString()) || leg.equalsIgnoreCase(this.colorByRole.getEnglishName()))) {
                    this.currentLegend = this.colorByRole;
                }
                rc = true;
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object value = null;
        Object obj = null;
        Object marker = null;
        switch (id) {
            case 53: {
                value = this.isLegendNeeded() ? this.rampName : null;
                break;
            }
            case 10116: {
                Vector<SILKNumber> r = new Vector<SILKNumber>();
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                    r.addElement(this.xRole);
                }
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                    r.addElement(this.yRole);
                }
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.zRole, 0))) {
                    r.addElement(this.zRole);
                }
                value = r.toArray();
                break;
            }
            case 10101: {
                value = this.colorByRole;
                break;
            }
            case 10102: {
                value = new Boolean(this.isColorMapped());
                break;
            }
            case 2017: {
                value = new Boolean(this.markerFilled);
                break;
            }
            case 2018: {
                value = new Boolean(this.markerOutlinesOn);
                break;
            }
            case 2015: {
                value = this.getMarkerShape();
                break;
            }
            case 2006: {
                value = this.getMarkerSize();
                break;
            }
            case 2009: {
                value = new Integer(25);
                break;
            }
            case 2008: {
                value = new Integer(2);
                break;
            }
            case 19001: {
                value = this.styleElement;
                break;
            }
            case 19002: {
                value = Boolean.TRUE;
                break;
            }
            case 19003: {
                value = this.isLegendNeeded() ? ContextNames.rampContexts : ContextNames.dataContexts;
                break;
            }
            case 23: {
                value = this.currentLegend;
                break;
            }
            case 434: {
                if (!this.colorRole.equals((Object)this.currentLegend)) break;
                if (this.isColorMapped()) {
                    value = this.roles.getVariable((Object)this.colorRole, 0);
                    break;
                }
                if (this.colorByRole == null) break;
                value = this.roles.getVariable((Object)this.colorByRole, 0);
                break;
            }
            case 24: 
            case 25: {
                if (!this.isLegendNeeded()) break;
                value = this.colorRole;
                break;
            }
            case 433: {
                value = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                value = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                value = Boolean.TRUE;
                break;
            }
            case 10103: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_X, 0));
                break;
            }
            case 10105: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0));
                break;
            }
            case 10107: {
                value = this.getVarLabel(this.roles.getVariable((Object)RoleInterface.ROLE_Z, 0));
                break;
            }
            case 10104: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_X, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10106: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10108: {
                obj = this.roles.getVariable((Object)RoleInterface.ROLE_Z, 0);
                if (obj == null || this.dataFilter == null) break;
                value = this.dataFilter.getFormat(obj, SASFormat.class);
                break;
            }
            case 10109: {
                value = new Object[]{RoleInterface.ROLE_X};
                break;
            }
            case 10110: {
                value = new Object[]{RoleInterface.ROLE_Y};
                break;
            }
            case 10111: {
                value = new Object[]{RoleInterface.ROLE_Z};
                break;
            }
            case 10112: {
                value = "perspective";
                break;
            }
            case 19089: {
                value = Boolean.TRUE;
                break;
            }
            default: {
                value = super.getPropertyValue(id);
            }
        }
        return value;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 53: {
                if (!(value instanceof String)) break;
                this.setColorRampName(value.toString());
                this.initColorRamp();
                this.initializeColorMapper();
                break;
            }
            case 10101: {
                this.setColorBy(value);
                break;
            }
            case 2017: {
                if (!(value instanceof Boolean)) break;
                this.setMarkerFilled((Boolean)value);
                break;
            }
            case 2018: {
                if (!(value instanceof Boolean)) break;
                this.setMarkerOutlinesOn((Boolean)value);
                break;
            }
            case 2015: {
                this.setMarkerShape(value);
                break;
            }
            case 2006: {
                this.setMarkerSize(value);
                break;
            }
            case 19001: {
                if (value == null) break;
                if (this.isLegendNeeded()) {
                    this.setStyleElement("RAMP", value.toString());
                    break;
                }
                this.setStyleElement("DEFAULT", value.toString());
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public boolean isWireframeSupported() {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        Scatter3DObject pi = this;
        if (listener != null && listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        if (category == 1 && dialogIn instanceof TabbedPropertiesDialog) {
            TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
            TabPanelInterface tpi = null;
            tpi = tpd.getTab(Scatter3DPanel.class);
            if (tpi != null) {
                tpi.addPropertyListener((PropertyInterface)pi);
            } else {
                tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DObject.ScatterPanelTitle.txt", (String)"Scatter"), (TabPanelInterface)new Scatter3DPanel(pi));
            }
        } else if (category == 1 && dialogIn instanceof GraphPropertiesDialog) {
            GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
            GraphPropertiesDialog.PropertiesTreeNode node = gpd.getRootNode((Object)"Chart", true);
            node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"Scatter3DObject.ScatterPanelTitle.txt", (String)"Scatter"));
            if (node.getPanel() == null) {
                node.setPanel((Component)new Scatter3DPanel(pi));
            } else if (node.getPanel() instanceof TabPanelInterface) {
                ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)pi);
            }
        }
        return true;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                this.rebuildRequired = true;
                break;
            }
            case 3: {
                this.removeRole(e);
                this.rebuildRequired = true;
            }
        }
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        this.selectionVar.connectFrom(this.dataFilter);
        this.edgeWidthCalculator.inA.connectFrom(this.selectionVar.value);
        return rc;
    }

    @Override
    public void draw() {
        Channel ch = this.root.getChannel();
        if (ch == null || !this.networkBuilt) {
            return;
        }
        ch.glPushAttrib(0);
        ch.glEnable(4);
        ch.glDisable(1);
        if (this.opacity < 1.0) {
            ch.glEnable(12);
        } else {
            ch.glDisable(12);
        }
        this.root.draw();
        ch.glPopAttrib();
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        switch (dimension) {
            case 4: {
                if (this.isColorMapped() || this.colorByRole == null) {
                    rc = super.getDataRange(dimension);
                    break;
                }
                Object colorByVar = this.roles.getVariable((Object)this.colorByRole, 0);
                if (this.dataFilter == null || colorByVar == null) {
                    return null;
                }
                int colorVarIndex = this.dataFilter.getVariableIndex(colorByVar);
                if (colorVarIndex < 0) {
                    return null;
                }
                double colorMin = Double.NaN;
                double colorMax = Double.NaN;
                DataFilterInfoInterface infoFilter = null;
                if (!(this.dataFilter instanceof DataFilterInfoInterface)) {
                    return null;
                }
                infoFilter = (DataFilterInfoInterface)this.dataFilter;
                Object o = infoFilter.getMinimumValue(this.dataFilter.getVariableId(colorVarIndex), false);
                if (o instanceof Number) {
                    colorMin = ((Number)o).doubleValue();
                }
                if ((o = infoFilter.getMaximumValue(this.dataFilter.getVariableId(colorVarIndex), false)) instanceof Number) {
                    colorMax = ((Number)o).doubleValue();
                }
                rc = new ContinuousRange(colorMin, colorMax);
                break;
            }
            default: {
                rc = super.getDataRange(dimension);
            }
        }
        return rc;
    }

    @Override
    public String getMenuXMLPath() {
        return "/com/sas/graphics/silk/util/menus/Scatter3DMenu.xml";
    }
}

