/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListenerList;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.interfaces.Drawable3DObjectInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericToNumericMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Vector;

public abstract class SILK3DObject
implements Drawable3DObjectInterface,
DataRangeInterface,
UpdateInterface,
PropertyInterface {
    protected NumericMapper xMapper = null;
    protected NumericMapper yMapper = null;
    protected NumericMapper zMapper = null;
    protected NetworkRoot root = null;
    protected boolean networkBuilt = false;
    protected Vector redrawListeners = new Vector();
    protected RangeChangeListenerList rangeChangeListeners = new RangeChangeListenerList();
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange zRange = null;
    protected boolean rebuildRequired = true;
    protected boolean drawWireframe = false;
    protected boolean wireframeRotate = false;
    protected boolean enableBlend = false;
    protected boolean enableDepthTest = true;
    protected boolean enableCullFace = true;
    protected double opacity = 1.0;
    protected PropertyList pending = new PropertyList();
    protected HashMap supportedProperties = null;
    protected UserSetPropertyBitMask userSetProperties = null;
    public static final int[] supportedObjectProperties = new int[]{10300, 10301, 10302};
    public static final String constantMapperStringValue = "CONSTANT";
    public static final double constantMapperNumericValue = 0.0;

    public SILK3DObject() {
        this.setSupportedProperties(supportedObjectProperties);
        this.userSetProperties = new UserSetPropertyBitMask(supportedObjectProperties);
    }

    public SILK3DObject(Channel channel) {
        this();
        this.setChannel(channel);
    }

    public void setChannel(Channel channel) {
        if (channel != null) {
            this.root = new NetworkRoot(channel);
        }
    }

    public void dispose() {
        this.xMapper = null;
        this.yMapper = null;
        this.zMapper = null;
        this.root = null;
        if (this.redrawListeners != null) {
            this.redrawListeners.removeAllElements();
            this.redrawListeners = null;
        }
        if (this.rangeChangeListeners != null) {
            RangeChangeListener[] rcl = this.rangeChangeListeners.getListeners();
            for (int i = 0; i < rcl.length; ++i) {
                this.rangeChangeListeners.remove(rcl[i]);
            }
            this.rangeChangeListeners = null;
        }
        this.xRange = null;
        this.yRange = null;
        this.zRange = null;
        this.pending = null;
        this.userSetProperties = null;
    }

    public boolean addRedrawListener(RedrawListener listener) {
        if (listener == null) {
            return false;
        }
        this.redrawListeners.add(listener);
        return true;
    }

    public boolean removeRedrawListener(RedrawListener listener) {
        if (listener == null) {
            return false;
        }
        this.redrawListeners.remove(listener);
        return true;
    }

    public void removeAllRedrawListeners() {
        this.redrawListeners.removeAllElements();
    }

    protected void fireRedrawEvent(int type) {
        RedrawEvent re = new RedrawEvent((Object)this);
        re.type = type;
        block5: for (int i = 0; i < this.redrawListeners.size(); ++i) {
            RedrawListener rl = (RedrawListener)this.redrawListeners.elementAt(i);
            switch (type) {
                case 1: {
                    rl.redraw(re);
                    continue block5;
                }
                case 2: {
                    rl.boundingBoxChanged(re);
                    continue block5;
                }
                case 3: {
                    rl.outerMarginChanged(re);
                    continue block5;
                }
            }
        }
    }

    public abstract boolean applyStyle(Style var1);

    public NumericMapper getMapper(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xMapper;
            }
            case 2: {
                return this.yMapper;
            }
            case 3: {
                return this.zMapper;
            }
        }
        return null;
    }

    public NumericMap getMap(byte dimension) {
        switch (dimension) {
            case 1: {
                if (this.xMapper == null) break;
                return this.xMapper.getNumericMap();
            }
            case 2: {
                if (this.yMapper == null) break;
                return this.yMapper.getNumericMap();
            }
            case 3: {
                if (this.zMapper == null) break;
                return this.zMapper.getNumericMap();
            }
        }
        return null;
    }

    public boolean shareMaps(SILK3DObject obj) {
        boolean xShared = this.shareMap(obj, (byte)1);
        boolean yShared = this.shareMap(obj, (byte)2);
        boolean zShared = this.shareMap(obj, (byte)3);
        return xShared && yShared && zShared;
    }

    public boolean shareMap(SILK3DObject obj, byte dimension) {
        NumericMapper myMapper = this.getMapper(dimension);
        NumericMapper shareMapper = obj.getMapper(dimension);
        return this.shareMap(myMapper, shareMapper);
    }

    protected boolean shareMap(NumericMapper mapper, NumericMapper sharedMapper) {
        if (mapper == null || sharedMapper == null) {
            return false;
        }
        if (mapper instanceof ContinuousRangeToNumericMapper) {
            if (!(sharedMapper instanceof ContinuousRangeToNumericMapper)) {
                return false;
            }
            ((ContinuousRangeToNumericMapper)mapper).shareMap((ContinuousRangeToNumericMapper)sharedMapper);
            return true;
        }
        if (mapper instanceof StringToNumericMapper) {
            if (!(sharedMapper instanceof StringToNumericMapper)) {
                return false;
            }
            ((StringToNumericMapper)mapper).shareMap((StringToNumericMapper)sharedMapper);
            return true;
        }
        if (mapper instanceof NumericToNumericMapper) {
            if (!(sharedMapper instanceof NumericToNumericMapper)) {
                return false;
            }
            ((NumericToNumericMapper)mapper).shareMap((NumericToNumericMapper)sharedMapper);
            return true;
        }
        return false;
    }

    public void resetDataRanges() {
        this.xRange = null;
        this.yRange = null;
        this.zRange = null;
    }

    @Override
    public NetworkRoot getRoot() {
        return this.root;
    }

    @Override
    public boolean isNetworkBuilt() {
        return this.networkBuilt;
    }

    @Override
    public abstract void draw();

    @Override
    public boolean setWireframe(boolean wireframe) {
        if (!this.isWireframeSupported()) {
            return false;
        }
        if (wireframe == this.drawWireframe) {
            return true;
        }
        this.drawWireframe = wireframe;
        this.userSetProperties.set(10300);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
        return true;
    }

    @Override
    public boolean isWireframe() {
        return this.drawWireframe;
    }

    @Override
    public boolean setWireframeRotate(boolean b) {
        if (!this.isWireframeSupported()) {
            return false;
        }
        if (this.wireframeRotate == b) {
            return true;
        }
        this.wireframeRotate = b;
        this.userSetProperties.set(10301);
        return true;
    }

    @Override
    public boolean getWireframeRotate() {
        return this.wireframeRotate;
    }

    @Override
    public void setOpacity(double opacityValue) {
        if (this.opacity == opacityValue) {
            return;
        }
        if (opacityValue >= 1.0) {
            this.opacity = 1.0;
            this.enableBlend = false;
            this.enableDepthTest = true;
        } else {
            this.enableBlend = true;
            this.enableDepthTest = false;
            this.opacity = opacityValue < 0.0 ? 0.0 : opacityValue;
        }
        this.userSetProperties.set(10302);
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
    }

    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 3: {
                return this.zRange;
            }
        }
        return null;
    }

    public void removeRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.remove(l);
        }
    }

    public void addRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.add(l);
        }
    }

    protected void fireRangeChangeEvent(RangeChangedEvent evt) {
        if (this.rangeChangeListeners == null) {
            return;
        }
        this.rangeChangeListeners.rangeChanged(evt);
    }

    public boolean create(Object createData) {
        return false;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public boolean build(Object buildData) {
        return true;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean success = this.build(buildData);
        this.fireRedrawEvent(1);
        return success;
    }

    protected boolean isRebuildRequired(Object buildData) {
        if (this.rebuildRequired) {
            return true;
        }
        return buildData instanceof Boolean && (Boolean)buildData != false;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 10302: {
                if (!(value instanceof Number)) break;
                this.setOpacity(((Number)value).doubleValue());
                break;
            }
            case 10300: {
                if (!(value instanceof Boolean)) break;
                this.setWireframe((Boolean)value);
                break;
            }
            case 10301: {
                if (!(value instanceof Boolean)) break;
                this.setWireframeRotate((Boolean)value);
            }
        }
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            this.applyChange(key, value);
        }
        if (changes.size() > 0) {
            this.fireRedrawEvent(1);
        }
        this.pending.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        if (this.supportedProperties == null || this.supportedProperties.size() == 0) {
            return false;
        }
        return this.supportedProperties.containsKey(new Integer(id));
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id) && id != 23) {
            return this.pending.store(id, value);
        }
        return false;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        if (this.userSetProperties != null) {
            rc = this.userSetProperties.get(id);
        }
        return rc;
    }

    public Object getPropertyValue(int id) {
        if (this.pending != null && this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Constable rc = null;
        switch (id) {
            case 10302: {
                rc = new Double(this.opacity);
                break;
            }
            case 10300: {
                rc = new Boolean(this.drawWireframe);
                break;
            }
            case 10301: {
                rc = new Boolean(this.wireframeRotate);
            }
        }
        return rc;
    }

    protected void setSupportedProperties(int[] properties) {
        if (properties != null) {
            if (this.supportedProperties == null) {
                this.supportedProperties = new HashMap();
            }
            for (int i = 0; i < properties.length; ++i) {
                Integer property = new Integer(properties[i]);
                this.supportedProperties.put(property, property);
            }
        }
    }

    protected void removePropertySupport(int[] properties) {
        if (properties != null && this.supportedProperties != null) {
            for (int i = 0; i < properties.length; ++i) {
                Integer property = new Integer(properties[i]);
                this.supportedProperties.remove(property);
            }
        }
    }
}

