/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.silk3d;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.Layer3DInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.StyleElementInterface;
import com.sas.graphics.silk.silk3d.SILK3DObject;
import com.sas.graphics.silk.util.ColorMapper;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericToNumericMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.Format;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public abstract class SILK3DChart
extends SILK3DObject
implements RoleInterface,
RoleListenerInterface,
DataFilterListenerInterface,
PropertyInterface,
StyleElementInterface,
Layer3DInterface,
CellItemInterface,
BaseComponentInterface {
    protected DataFilterReadInterface dataFilter = null;
    protected RoleManager roles = null;
    protected Style style = null;
    protected boolean normalized = false;
    protected GlobalDefaults defaults = null;
    protected Object id = null;
    int actionMode = 0;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_CHART = 1;
    public static final int ERROR_NO_DATA = 2;
    public static final int ERROR_INVALID_DATA = 3;
    public static final int ERROR_ROLE_ASSIGNMENT = 4;
    protected int errorCode = 0;
    protected String styleElement = "GraphDataStyleDefault";
    protected String rampName = "ThreeColorRamp";
    protected ColorMapper silkColorMapper = null;
    protected SILKNumber currentLegend = null;
    protected EventListenerList layerListenerList = new EventListenerList();
    protected LayerChangedEvent lce = null;
    public static final int[] supportedChartProperties = new int[]{53, 10100, 35, 10101, 19010, 19011};
    protected StyleElementAttrs fillAttrs = null;
    protected StyleElementAttrs markerAttrs = null;

    public SILK3DChart(Channel channel) {
        this();
        this.setChannel(channel);
    }

    public SILK3DChart() {
        this.roles = new RoleManager();
        this.roles.addRoleListener((RoleListenerInterface)this);
        this.defaults = new GlobalDefaults();
        this.setSupportedProperties(supportedChartProperties);
        this.userSetProperties.appendProperties(supportedChartProperties);
    }

    @Override
    public void dispose() {
        EventListener[] listeners;
        super.dispose();
        if (this.dataFilter != null) {
            this.dataFilter.removeDataFilterListener((Object)this);
        }
        this.dataFilter = null;
        this.roles = null;
        this.style = null;
        this.defaults = null;
        if (this.layerListenerList != null && (listeners = this.layerListenerList.getListeners(LayerListenerInterface.class)) != null) {
            for (int i = 0; i < listeners.length; ++i) {
                this.layerListenerList.remove(LayerListenerInterface.class, (LayerListenerInterface)listeners[i]);
            }
        }
        this.layerListenerList = null;
        this.lce = null;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String toString() {
        if (this.getId() == null) {
            return super.toString();
        }
        return this.getId().toString();
    }

    public RoleManager getRoleManager() {
        return this.roles;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    protected void applyStyleElement() {
    }

    @Override
    public boolean applyStyle(Style styleIn) {
        if (styleIn == null) {
            return false;
        }
        this.style = styleIn;
        this.applyStyleElement();
        this.rebuildRequired = true;
        this.fireRedrawEvent(1);
        return true;
    }

    public void setNormalized(boolean normalize) {
        if (this.normalized == normalize) {
            return;
        }
        this.normalized = normalize;
        this.userSetProperties.set(10100);
        this.fireRedrawEvent(1);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public DataFilterReadInterface getFilter() {
        return this.dataFilter;
    }

    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource(Object id) {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null) {
            return false;
        }
        this.dataFilter = FilterFactory.getDataSourceFilter((Object)source);
        this.roles.setDataset(null, (Object)this.dataFilter);
        if (this.dataFilter != null) {
            this.dataFilter.addDataFilterListener((Object)this);
        }
        return this.dataFilter != null;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public Object getAllVariables(Object role) {
        return this.roles.getAllVariables(role);
    }

    public Object getVariable(Object role) {
        return this.roles.getVariable(role, 0);
    }

    public Object getRole(Object variableId) {
        return this.roles.getRole(variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        return this.roles.setRole(variableId, role);
    }

    public boolean addRole(Object variableId, Object role) {
        return this.roles.addRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        return this.roles.removeRole(variableId, role);
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public boolean isDiscrete(Object role) {
        return this.roles.isDiscrete(role);
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        return this.roles.setDiscrete(role, discrete);
    }

    public int getMaxAllowed(Object role) {
        return this.roles.getMaxAllowed(role);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return this.roles.supportsMultipleAssignments(role);
    }

    public Object getSortOrder(Object variableId) {
        return this.roles.getSortOrder(variableId);
    }

    public boolean setSortOrder(Object variableId, Object order) {
        return this.roles.setSortOrder(variableId, order);
    }

    public void addRoleListener(RoleListenerInterface rli) {
        this.roles.addRoleListener(rli);
    }

    public void removeRoleListener(RoleListenerInterface rli) {
        this.roles.removeRoleListener(rli);
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return this.roles.getSupportedSortableRoles();
    }

    public int[] getSupportedSortDirections(Object role) {
        return this.roles.getSupportedSortDirections(role);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return this.roles.getSupportedRoles(id, discrete);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.isAdjusting) {
            return;
        }
        switch (evt.type) {
            case 2: {
                this.dataSelectionChanged(evt);
                break;
            }
            case 3: {
                this.roles.checkRoles();
                this.updateVariables();
                this.rebuildRequired = true;
                this.fireRedrawEvent(1);
                break;
            }
        }
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.dataFilter == null) {
            return false;
        }
        boolean rc = this.dataFilter.applyWhereClause(clause, clearPrevious);
        this.roles.checkRoles();
        if (rc) {
            this.fireLayerListenerChanged(4);
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 3));
        }
        if (this.dataFilter.getWhereClause() != null && this.dataFilter.getWhereClause().length() > 0) {
            this.userSetProperties.set(35);
        } else {
            this.userSetProperties.clear(35);
        }
        return rc;
    }

    public String getWhereClause() {
        return this.dataFilter.getWhereClause();
    }

    public boolean isActionEnabled(String action) {
        return false;
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public boolean isDataListening() {
        return false;
    }

    private void dataSelectionChanged(DvrDataFilterEvent evt) {
        this.fireRedrawEvent(1);
    }

    protected abstract boolean areRequiredVariablesSet();

    protected abstract void validateData();

    protected abstract void updateVariables();

    protected abstract int getRoleInt(Object var1);

    public abstract double[] getPreferredAxisSize();

    public abstract void setColorBy(Object var1);

    public abstract SILKNumber getColorBy();

    public abstract boolean isLegendNeeded();

    protected Object getObject(Object obj) {
        return Extract.getObject((Object)obj, (int)0, (int)Extract.getSourceType((Object)obj));
    }

    protected void connectVariableToData(Variable var, Object varName) {
        if (var instanceof GTKNumericDataFilterVariable) {
            ((GTKNumericDataFilterVariable)var).connectFrom(this.dataFilter, varName);
        } else {
            ((GTKStringDataFilterVariable)var).connectFrom(this.dataFilter, varName);
        }
        if (this.dataFilter.getFormat(varName, SASFormat.class) == null && this.defaults != null) {
            var.setFormat(new GTKFormat((Format)this.defaults.defaultNumericFormat));
        }
    }

    protected boolean disconnectMapper(NumericMapper mapper) {
        if (mapper == null) {
            return false;
        }
        if (mapper instanceof StringToNumericMapper) {
            ((StringToNumericMapper)mapper).input.disconnect();
        } else if (mapper instanceof NumericToNumericMapper) {
            ((NumericToNumericMapper)mapper).input.disconnect();
        } else if (mapper instanceof ContinuousRangeToNumericMapper) {
            ((ContinuousRangeToNumericMapper)mapper).input.disconnect();
        } else {
            return false;
        }
        return true;
    }

    protected boolean connectMapperToVariable(NumericMapper mapper, Variable var) {
        StringPipe stringPipe = null;
        NumericPipe numericPipe = null;
        if (mapper == null) {
            return false;
        }
        if (var == null) {
            if (mapper instanceof StringToNumericMapper) {
                ((StringToNumericMapper)mapper).input.setValue("CONSTANT");
            } else if (mapper instanceof NumericToNumericMapper) {
                ((NumericToNumericMapper)mapper).input.setValue(0.0);
            } else if (mapper instanceof ContinuousRangeToNumericMapper) {
                ((ContinuousRangeToNumericMapper)mapper).input.setValue(0.0);
            } else {
                return false;
            }
            return true;
        }
        if (!var.isConnected()) {
            return false;
        }
        if (var instanceof NumericVariable) {
            numericPipe = ((NumericVariable)var).value;
            stringPipe = ((NumericVariable)var).formattedValue;
        } else if (var instanceof StringVariable) {
            stringPipe = ((StringVariable)var).formattedValue;
        }
        if (mapper instanceof StringToNumericMapper && stringPipe != null) {
            ((StringToNumericMapper)mapper).input.connectFrom(stringPipe);
        } else if (mapper instanceof NumericToNumericMapper && numericPipe != null) {
            ((NumericToNumericMapper)mapper).input.connectFrom(numericPipe);
        } else if (mapper instanceof ContinuousRangeToNumericMapper && numericPipe != null) {
            ((ContinuousRangeToNumericMapper)mapper).input.connectFrom(numericPipe);
        } else {
            return false;
        }
        return true;
    }

    protected Vector getUniqueDataValues(Variable var) {
        Vector<Object> values = new Vector<Object>();
        for (int i = 0; i < var.getUniqueValueCount(); ++i) {
            try {
                if (var instanceof StringVariable) {
                    values.add(((StringVariable)var).uniqueValue.getValue(i));
                    continue;
                }
                if (!(var instanceof NumericVariable)) continue;
                values.add(new Double(((NumericVariable)var).uniqueValue.getValue(i)));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return values;
    }

    public void setStyleElement(String id, String elementName) {
        if (id == null || elementName == null) {
            return;
        }
        String oldValue = null;
        if ("DEFAULT".equalsIgnoreCase(id)) {
            oldValue = this.styleElement;
            this.styleElement = elementName;
        }
        if (oldValue == null || !elementName.equalsIgnoreCase(oldValue)) {
            this.applyStyleElement();
            this.userSetProperties.set(19001);
            this.rebuildRequired = true;
            this.fireRedrawEvent(1);
        }
    }

    public String getStyleElement(String id) {
        if ("DEFAULT".equalsIgnoreCase(id)) {
            return this.styleElement;
        }
        return null;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return this.addTabs(id, dialogIn, category, null);
    }

    public abstract boolean addTabs(Object var1, Dialog var2, int var3, Object var4);

    public boolean areChartTipsOn() {
        return false;
    }

    public void setChartTipsOn(boolean on) {
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public boolean setActionMode(int mode) {
        this.actionMode = mode;
        return true;
    }

    public String getMenuXMLPath() {
        return null;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        return this;
    }

    public ColorSchemeInterface getColorScheme() {
        return new ColorScheme(this.style);
    }

    public String getColorSchemeName() {
        return this.style.getSchemeName();
    }

    public boolean setColorScheme(Object newScheme) {
        return false;
    }

    public void roleChanged(RoleEvent e) {
    }

    public DataRange getPreferredRange(Object which) {
        if (this.dataFilter == null) {
            return null;
        }
        OrdinalRange rc = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            Object role = rolesEnum.nextElement();
            Object vars = this.roles.getAllVariables(role);
            Enumeration e = Extract.elements((Object)vars);
            while (e.hasMoreElements()) {
                Object var = e.nextElement();
                int varIndex = this.dataFilter.getVariableIndex(var);
                if (this.dataFilter.isNumericVariable(var) && !this.roles.isDiscrete(role)) {
                    double min = Double.MAX_VALUE;
                    double max = Double.MIN_VALUE;
                    if (this.dataFilter instanceof DataFilterInfoInterface) {
                        min = ((Number)((DataFilterInfoInterface)this.dataFilter).getMinimumValue(var)).doubleValue();
                        max = ((Number)((DataFilterInfoInterface)this.dataFilter).getMaximumValue(var)).doubleValue();
                    } else {
                        for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
                            double val = this.dataFilter.getNumericValue(varIndex, (long)i);
                            if (Double.isNaN(val)) continue;
                            min = Math.min(min, val);
                            max = Math.max(max, val);
                        }
                    }
                    if (rc == null) {
                        rc = new ContinuousRange(min, max);
                    }
                    if (!(rc instanceof ContinuousRange)) continue;
                    ((ContinuousRange)rc).setMin(Math.min(((ContinuousRange)rc).getMin(), min));
                    ((ContinuousRange)rc).setMax(Math.max(((ContinuousRange)rc).getMax(), max));
                    continue;
                }
                if (this.dataFilter.isNumericVariable(var) && this.roles.isDiscrete(role)) {
                    RangeInfoModel rangeInfoModel = (RangeInfoModel)this.dataFilter.getAdapter(RangeInfoModel.class);
                    if (rangeInfoModel != null) {
                        rc = rangeInfoModel.getOrdinalRange(var);
                        continue;
                    }
                    LinkedHashMap<String, Object> unformatted = new LinkedHashMap<String, Object>();
                    for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
                        Object d = this.dataFilter.getValue(varIndex, (long)i);
                        String f = this.dataFilter.getFormattedValue(var, (long)i, null);
                        if (unformatted.containsKey(f)) continue;
                        unformatted.put(f, d);
                    }
                    Object[] fvalues = unformatted.values().toArray();
                    Object[] uvalues = unformatted.keySet().toArray();
                    OrdinalRange or = new OrdinalRange(uvalues, fvalues);
                    rc = RangeMerger.mergeRange((DataRange)rc, (DataRange)or);
                    continue;
                }
                DiscreteRange dr = null;
                if (this.dataFilter instanceof DataFilterInfoInterface) {
                    Object[] data = ((DataFilterInfoInterface)this.dataFilter).getUniqueValues(var, true);
                    data = this.sortUniqueValues(data, this.roles.getSortOrder(role));
                    dr = new DiscreteRange(data);
                } else {
                    LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                    for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
                        Object value = this.dataFilter.getValue(varIndex, (long)i);
                        if (map.containsKey(value)) continue;
                        map.put(value, value);
                    }
                    Object[] data = this.sortUniqueValues(map.keySet().toArray(), this.roles.getSortOrder(role));
                    dr = new DiscreteRange(data);
                }
                if (rc == null) {
                    rc = dr;
                    continue;
                }
                if (!(rc instanceof DiscreteRange)) continue;
                rc.union((DataRange)dr);
            }
        }
        return rc;
    }

    public boolean getAxesVisible() {
        return false;
    }

    public int getNumRanges(byte dim) {
        return 1;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public void setRange(byte dim, int index, DataRange range) {
        if (range == null) {
            return;
        }
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            if (dim == 1) {
                this.xRange = new ContinuousRange((DataRange)cr);
            } else if (dim == 2) {
                this.yRange = new ContinuousRange((DataRange)cr);
            } else if (dim == 3) {
                this.zRange = new ContinuousRange((DataRange)cr);
            }
        } else if (range instanceof DiscreteRange) {
            DiscreteRange dr = (DiscreteRange)range;
            if (dim == 1) {
                this.xRange = new DiscreteRange((DataRange)dr);
            } else if (dim == 2) {
                this.yRange = new DiscreteRange((DataRange)dr);
            } else if (dim == 3) {
                this.zRange = new DiscreteRange((DataRange)dr);
            }
        }
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public Insets getInnerMargin() {
        return null;
    }

    public Insets getOuterMargin() {
        return null;
    }

    public Insets getPreferredInnerMargin() {
        return null;
    }

    public Insets getPreferredOuterMargin() {
        return null;
    }

    public void setInnerMargin(Insets margin) {
    }

    public void setOuterMargin(Insets margin) {
    }

    public void addMarginListener(MarginListener listener) {
    }

    public void removeMarginListener(MarginListener listener) {
    }

    protected void fireMarginChanged(MarginChangeEvent event) {
    }

    public Rectangle getBounds() {
        return null;
    }

    public void setBounds(int x, int y, int w, int h) {
    }

    public void setBackground(Color color) {
    }

    public void setBounds(Rectangle r) {
    }

    public void setComponentSize(int compWidth, int compHeight) {
    }

    protected void layoutChart() {
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        switch (dimension) {
            case 4: {
                Object colorVar = this.roles.getVariable((Object)RoleInterface.ROLE_COLOR, 0);
                if (this.dataFilter == null || colorVar == null) {
                    return null;
                }
                int colorVarIndex = this.dataFilter.getVariableIndex(colorVar);
                if (colorVarIndex < 0) {
                    return null;
                }
                double colorMin = Double.NaN;
                double colorMax = Double.NaN;
                DataFilterInfoInterface infoFilter = null;
                if (!(this.dataFilter instanceof DataFilterInfoInterface)) {
                    return null;
                }
                infoFilter = (DataFilterInfoInterface)this.dataFilter;
                Object o = infoFilter.getMinimumValue(this.dataFilter.getVariableId(colorVarIndex), false);
                if (o instanceof Number) {
                    colorMin = ((Number)o).doubleValue();
                }
                if ((o = infoFilter.getMaximumValue(this.dataFilter.getVariableId(colorVarIndex), false)) instanceof Number) {
                    colorMax = ((Number)o).doubleValue();
                }
                rc = new ContinuousRange(colorMin, colorMax);
                break;
            }
            default: {
                rc = super.getDataRange(dimension);
            }
        }
        return rc;
    }

    protected Object[] sortUniqueValues(Object[] data, Object sortDirection) {
        if (sortDirection == null) {
            return data;
        }
        if (sortDirection == RoleInterface.ROLE_SORT_ASCENDING) {
            Arrays.sort(data);
        } else if (sortDirection == RoleInterface.ROLE_SORT_DESCENDING) {
            Arrays.sort(data);
            for (int i = 0; i < data.length / 2; ++i) {
                Object temp = data[i];
                data[i] = data[data.length - 1 - i];
                data[data.length - 1 - i] = temp;
            }
        }
        return data;
    }

    protected Object getVarLabel(Object variableId) {
        if (variableId == null) {
            return null;
        }
        if (this.dataFilter == null) {
            return variableId.toString();
        }
        return this.dataFilter.getVariableDescription(variableId);
    }

    public void addLayerListener(LayerListenerInterface lli) {
        if (lli != null) {
            if (this.layerListenerList == null) {
                this.layerListenerList = new EventListenerList();
            }
            this.layerListenerList.add(LayerListenerInterface.class, lli);
        }
    }

    public void removeLayerListener(LayerListenerInterface lli) {
        if (lli != null) {
            this.layerListenerList.remove(LayerListenerInterface.class, lli);
        }
    }

    protected void fireLayerListenerChanged(LayerChangedEvent evt) {
        if (evt == null || this.layerListenerList == null) {
            return;
        }
        Object[] listeners = this.layerListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LayerListenerInterface.class) continue;
            ((LayerListenerInterface)listeners[i + 1]).layerChanged(this.lce);
        }
    }

    protected void fireLayerListenerChanged(int action) {
        this.fireLayerListenerChanged(action, null);
    }

    protected void fireLayerListenerChanged(int action, Object buildData) {
        if (this.lce == null) {
            this.lce = new LayerChangedEvent((Object)this, action);
        } else {
            this.lce.setSource((Object)this);
            this.lce.setAction(action);
        }
        this.lce.setBuildData(buildData);
        this.fireLayerListenerChanged(this.lce);
    }

    protected void setColorRampName(String rampName) {
        if (rampName == this.rampName) {
            return;
        }
        this.rampName = rampName;
        this.userSetProperties.set(53);
    }

    protected void initColorRamp() {
        ColorMapper tempMapper = ColorMapper.getInstance((String)this.rampName);
        if (tempMapper == this.silkColorMapper) {
            return;
        }
        if (this.silkColorMapper != null) {
            this.silkColorMapper.unRegister((CellItemInterface)this);
        }
        this.silkColorMapper = tempMapper;
        if (this.silkColorMapper != null) {
            this.silkColorMapper.register((CellItemInterface)this);
        }
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 53: {
                if (!(value instanceof String)) break;
                this.setColorRampName(value.toString());
                this.initColorRamp();
                break;
            }
            case 10100: {
                if (!(value instanceof Boolean)) break;
                this.setNormalized((Boolean)value);
                break;
            }
            case 35: {
                if (value == null) break;
                this.applyWhereClause(value.toString(), true);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pending != null && this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 53: {
                rc = this.rampName;
                break;
            }
            case 10100: {
                rc = new Boolean(this.normalized);
                break;
            }
            case 35: {
                rc = this.getWhereClause();
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    protected String getFormattedValue(Object var, int obs) {
        if (this.dataFilter == null) {
            return null;
        }
        int varIdx = this.dataFilter.getVariableIndex(var);
        if (var == null || varIdx < 0 || obs < 0 || obs >= this.dataFilter.getNumberObservations(-1)) {
            return null;
        }
        Object value = this.dataFilter.getValue(varIdx, (long)obs);
        if (value == null) {
            return null;
        }
        return this.getFormattedValue(var, value);
    }

    protected String getFormattedValue(Object var, Object value) {
        int varIdx = this.dataFilter.getVariableIndex(var);
        if (var == null || varIdx < 0) {
            return null;
        }
        if (value == null) {
            return null;
        }
        SASFormat format = (SASFormat)this.dataFilter.getFormat(var, SASFormat.class);
        if (format == null) {
            return this.getDefaultFormattedValue(value);
        }
        if (value instanceof String && format.isCharacterFormat() || value instanceof Number && !format.isCharacterFormat()) {
            return format.format(value);
        }
        return value.toString();
    }

    protected String getDefaultFormattedValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return this.defaults.defaultNumericFormat.format(value);
        }
        return value.toString();
    }
}

