/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.util;

public class MimeTypeUtility {
    public static final String DOCUMENT = "Document";
    public static final String WORDDOCUMENT = "WordDocument";
    public static final String PDFDOCUMENT = "PDFDocument";
    public static final String EXCELREPORT = "ExcelReport";
    public static final String WEBDOCUMENT = "WebDocument";

    private MimeTypeUtility() {
    }

    public static String mapMimeTypeToContentType(String mimeType) {
        String type = WEBDOCUMENT;
        if (mimeType.equals("application/ms-excel") || mimeType.equals("application/vnd.ms-excel") || mimeType.equals("application/msexcel")) {
            type = EXCELREPORT;
        } else if (mimeType.equals("application/x-pdf") || mimeType.equals("application/pdf")) {
            type = PDFDOCUMENT;
        } else if (mimeType.equals("application/msword") || mimeType.equals("application/ms-word")) {
            type = WORDDOCUMENT;
        }
        return type;
    }

    public static String mapContentTypeToMimeType(String contentType) {
        String type = "text/html";
        if (WORDDOCUMENT.equals(contentType)) {
            type = "application/msword";
        } else if (PDFDOCUMENT.equals(contentType)) {
            type = "application/pdf";
        } else if (EXCELREPORT.equals(contentType)) {
            type = "application/vnd.ms-excel";
        }
        return type;
    }
}

