/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackToUrlEncoder {
    private static final String BACK_TO_URL_START = "_bkurl_a=";
    private static final String BACK_TO_URL_END = "_bkurl_z";
    private static final String BACK_TO_DESCR_START = "_bkdescr_a=";
    private static final String BACK_TO_DESCR_END = "_bkdescr_z";
    private static final String BACK_TO_LABEL_START = "_bklabel_a=";
    private static final String BACK_TO_LABEL_END = "_bklabel_z";
    private static final Pattern BACK_TO_URL_PATTERN = Pattern.compile("_bkurl_a=(.*?)_bkurl_z");
    private static final Pattern BACK_TO_DESCR_PATTERN = Pattern.compile("_bkdescr_a=(.*?)_bkdescr_z");
    private static final Pattern BACK_TO_LABEL_PATTERN = Pattern.compile("_bklabel_a=(.*?)_bklabel_z");
    private List<String> _backToUrls;
    private List<String> _backToDescrs;
    private List<String> _backToLabels;

    public boolean containsBackToUrl(String queryString) {
        boolean retval = false;
        if (queryString != null) {
            retval = queryString.contains(BACK_TO_URL_START);
        }
        return retval;
    }

    public void setBackToUrls(List<String> backToUrls) {
        this._backToUrls = backToUrls;
    }

    public void setBackToDescrs(List<String> backToDescs) {
        this._backToDescrs = backToDescs;
    }

    public void setBackToLabels(List<String> backToLabels) {
        this._backToLabels = backToLabels;
    }

    public String encode() {
        StringBuilder retval = new StringBuilder();
        if (this._backToUrls != null && !this._backToUrls.isEmpty()) {
            for (String s : this._backToUrls) {
                retval.append(BACK_TO_URL_START).append(this.urlEncode(s)).append(BACK_TO_URL_END).append("&");
            }
        }
        if (this._backToDescrs != null && !this._backToDescrs.isEmpty()) {
            for (String s : this._backToDescrs) {
                retval.append(BACK_TO_DESCR_START).append(this.urlEncode(s)).append(BACK_TO_DESCR_END).append("&");
            }
        }
        if (this._backToLabels != null && !this._backToLabels.isEmpty()) {
            for (String s : this._backToLabels) {
                retval.append(BACK_TO_LABEL_START).append(this.urlEncode(s)).append(BACK_TO_LABEL_END).append("&");
            }
        }
        if (retval.length() > 0) {
            retval.setLength(retval.length() - 1);
        }
        return retval.toString();
    }

    public List<String> decodeBackToUrls(String queryString) {
        return this.urlDecode(BACK_TO_URL_PATTERN, queryString);
    }

    public List<String> decodeBackToDescrs(String queryString) {
        return this.urlDecode(BACK_TO_DESCR_PATTERN, queryString);
    }

    public List<String> decodeBackToLabels(String queryString) {
        return this.urlDecode(BACK_TO_LABEL_PATTERN, queryString);
    }

    private List<String> urlDecode(Pattern pattern, String queryString) {
        ArrayList<String> retval = new ArrayList<String>();
        if (queryString != null) {
            Matcher matcher = pattern.matcher(queryString);
            String val = null;
            while (matcher.find()) {
                try {
                    val = URLDecoder.decode(matcher.group(1), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                retval.add(val);
            }
        }
        return retval;
    }

    private String urlEncode(String param) {
        String retval = null;
        try {
            retval = URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return retval;
    }
}

