/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.forms.WizardInterface;
import com.sas.framework.webapp.forms.WizardPage;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class WizardStepTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_TEMPLATE = "wizardSteps";
    protected static final String CURRENT_TEMPLATE = "currentWizardStep";
    protected static final String COMPLETED_TEMPLATE = "completedWizardStep";
    protected static final String FUTURE_TEMPLATE = "futureWizardStep";
    private String key = "com.sas.framework.webapp.forms.Wizard";
    private String completedImage = "wizard_step_completed";
    private String completedStyle = "wizardStepComplete";
    private String currentStyle = "wizardStepCurrent";
    private String futureStyle = "wizardStepFuture";
    private String dividerStyle = "wizardDivider";

    public WizardStepTag() {
        this.setTemplate(DEFAULT_TEMPLATE);
    }

    public String getKey() {
        return null == this.key ? "com.sas.framework.webapp.forms.Wizard" : this.key;
    }

    public void setKey(String k) {
        this.key = k;
    }

    public int doStartTag() throws JspException {
        String thiskey = this.getKey();
        WizardInterface wizard = (WizardInterface)this.pageContext.getAttribute(thiskey, 3);
        JspWriter out = this.pageContext.getOut();
        int currentStep = wizard.getCurrentPage();
        List pageList = wizard.getPageList();
        try {
            StringBuilder steps = new StringBuilder();
            for (int i = 0; i < pageList.size(); ++i) {
                String step = i < currentStep ? this.getCompletedStep((WizardPage)pageList.get(i), i) : (i == currentStep ? this.getCurrentStep((WizardPage)pageList.get(i), i) : this.getFutureStep((WizardPage)pageList.get(i), i));
                steps.append(step);
            }
            Dictionary dict = this.getTemplateDictionary();
            dict.set((Object)"STEPS", (Object)steps);
            String value = this.applyTemplate(dict, this.getTemplate());
            out.println(value);
        }
        catch (ThemeException te) {
            throw new JspException("WizardHeadingTag: " + te.getMessage(), (Throwable)te);
        }
        catch (IOException e) {
            throw new JspException("WizardHeadingTag: " + e.getMessage());
        }
        return 0;
    }

    protected Dictionary getTemplateDictionary() {
        Dictionary dict = new Dictionary();
        return dict;
    }

    protected String getCurrentStep(WizardPage action, int number) throws ThemeException {
        Dictionary dict = this.getBaseStepDictionary(action, number);
        dict.set((Object)"STYLE_CLASS", (Object)this.getCurrentStyle());
        String value = this.applyTemplate(dict, CURRENT_TEMPLATE);
        return value;
    }

    protected String getCompletedStep(WizardPage action, int number) throws ThemeException {
        Dictionary dict = this.getBaseStepDictionary(action, number);
        dict.set((Object)"IMG_SRC", (Object)ThemeHelper.getImageFromTheme((HttpServletRequest)this.pageContext.getRequest(), this.getTheme(), this.getCompletedImage()));
        String actionCommand = action.getUrl();
        WizardInterface wizard = (WizardInterface)this.pageContext.getAttribute(this.getKey(), 3);
        if (wizard.isPreviousEnabled()) {
            dict.set((Object)"STEP_URL", (Object)(actionCommand + "?command=" + "goTo" + "&step=" + number));
        } else {
            dict.set((Object)"STEP_URL", (Object)"#");
        }
        dict.set((Object)"STYLE_CLASS", (Object)this.getCompletedStyle());
        String value = this.applyTemplate(dict, COMPLETED_TEMPLATE);
        return value;
    }

    protected String getFutureStep(WizardPage action, int number) throws ThemeException {
        Dictionary dict = this.getBaseStepDictionary(action, number);
        dict.set((Object)"STYLE_CLASS", (Object)this.getFutureStyle());
        String value = this.applyTemplate(dict, FUTURE_TEMPLATE);
        return value;
    }

    protected Dictionary getBaseStepDictionary(WizardPage action, int number) {
        Dictionary dict = new Dictionary();
        dict.set((Object)"STEP_TEXT", (Object)action.getLabel());
        dict.set((Object)"DIVIDER_STYLE_CLASS", (Object)this.getDividerStyle());
        dict.set((Object)"STEP_NUMBER", (Object)(number + 1));
        return dict;
    }

    public String getCompletedImage() {
        return this.completedImage;
    }

    public String getCompletedStyle() {
        return this.completedStyle;
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    public String getFutureStyle() {
        return this.futureStyle;
    }

    public void setCompletedImage(String string) {
        this.completedImage = string;
    }

    public void setCompletedStyle(String string) {
        this.completedStyle = string;
    }

    public void setCurrentStyle(String string) {
        this.currentStyle = string;
    }

    public void setFutureStyle(String string) {
        this.futureStyle = string;
    }

    public String getDividerStyle() {
        return this.dividerStyle;
    }

    public void setDividerStyle(String string) {
        this.dividerStyle = string;
    }
}

