/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.resolvers.PreferenceResolverInterface;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.taglib.BaseBodyTag;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class UIBodyTagSupport
extends BaseBodyTag {
    private static final long serialVersionUID = 1L;
    public static final String PAGE = "page";
    public static final String REQUEST = "request";
    public static final String SESSION = "session";
    public static final String APPLICATION = "application";
    private transient PreferenceResolverInterface preferenceResolver;
    protected String styleClass = null;
    protected String themeName = null;

    public String getStyleClass() {
        return this.styleClass;
    }

    public PreferenceResolverInterface getPreferenceResolver() {
        if (null == this.preferenceResolver) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            this.preferenceResolver = FrameworkHelper.getPreferenceResolver(request);
        }
        return this.preferenceResolver;
    }

    public void setStyleClass(String style) {
        this.styleClass = style;
    }

    protected Theme getTheme() throws ThemeException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        return ThemeHelper.getTheme(request);
    }

    protected String getImagesPath() throws ThemeException {
        return this.getImagesPath(true);
    }

    protected String getImagesPath(boolean trailingSeparator) throws ThemeException {
        return this.getAssetPath("IMAGE", trailingSeparator);
    }

    protected String getAssetPath(String elementType) throws ThemeException {
        return this.getAssetPath(elementType, true);
    }

    protected String getAssetPath(String elementType, boolean trim) throws ThemeException {
        if (null == elementType) {
            return "";
        }
        return ThemeHelper.getThemePath(elementType, trim, (HttpServletRequest)this.pageContext.getRequest());
    }

    protected String getTemplatesPath() throws ThemeException {
        return this.getAssetPath("TEMPLATE");
    }

    protected Locale getUserLocale() {
        return FrameworkHelper.getUserLocale((HttpServletRequest)this.pageContext.getRequest());
    }

    protected String getContextPath(boolean requiresBaseUrl) {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        return FrameworkHelper.getContextPath(request, requiresBaseUrl);
    }

    protected String getContextPath() {
        return this.getContextPath(false);
    }
}

