/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.PopupMenuTag;
import com.sas.servlet.tbeans.models.TreeNode;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.TreeModel;

public class TreePopupMenuTag
extends PopupMenuTag {
    private static final long serialVersionUID = 1L;
    private static final String NODE_ID_PARM = "nodeId=";
    protected String modelName = null;
    protected StringBuffer treeIdentifierParameter = null;
    private String tmpComponentId;
    private String tmpRelativeId;

    public void setModel(String thisModel) {
        this.modelName = thisModel;
    }

    public String getModel() {
        return this.modelName;
    }

    @Override
    public String getPopupMenuHTML() throws ThemeException {
        TreeModel model = this.getModelInstance();
        TreeNode rootNode = (TreeNode)model.getRoot();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ResourceBundle rb = ResourceBundle.getBundle(FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Resources"), this.getUserLocale());
        ActionResourceLoader actionLoader = new ActionResourceLoader(rb, (Object)this);
        StringBuffer menusHTML = new StringBuffer();
        this.tmpComponentId = this.getComponentId();
        this.tmpRelativeId = this.getPositionRelativeToId();
        this.walkTree(rootNode, actionLoader, menusHTML, this.getId());
        return menusHTML.toString();
    }

    @Override
    protected String getActionURL(Action action, StringBuffer parameters) {
        this.addParameter(parameters, this.treeIdentifierParameter);
        StringBuilder url = new StringBuilder(super.getActionURL(action, parameters));
        return url.toString();
    }

    private void walkTree(TreeNode parentNode, ActionResourceLoader actionLoader, StringBuffer menusHTML, String baseId) throws ThemeException {
        String menuId = parentNode.getName();
        this.treeIdentifierParameter = new StringBuffer();
        this.treeIdentifierParameter.append(NODE_ID_PARM).append(menuId);
        ActionList actionList = actionLoader.getActionList(this.getActionList());
        List actions = actionList.getActions();
        this.setId(baseId + menuId);
        this.setComponentId(this.tmpComponentId + menuId);
        this.setPositionRelativeToId(this.tmpRelativeId + menuId);
        menusHTML.append(this.getPopupMenuHTML(actions));
        if (!parentNode.isExpanded()) {
            return;
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            TreeNode childNode = (TreeNode)parentNode.getChildAt(i);
            this.walkTree(childNode, actionLoader, menusHTML, baseId);
        }
    }

    private TreeModel getModelInstance() {
        TreeModel model = null;
        String scope = this.getScope();
        if (scope.equalsIgnoreCase("request")) {
            model = (TreeModel)this.pageContext.getRequest().getAttribute(this.modelName);
        } else if (scope.equalsIgnoreCase("session")) {
            model = (TreeModel)this.pageContext.getSession().getAttribute(this.modelName);
        } else if (scope.equalsIgnoreCase("page")) {
            model = (TreeModel)this.pageContext.getAttribute(this.modelName);
        }
        return model;
    }
}

