/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.taglib.BaseTextSupport;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class ThemeImageTag
extends BaseTextSupport {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String altKey;
    private String width;
    private String height;
    private String border;
    private String hspace;
    private String vspace;
    private String align;
    private String onclick;
    public static final String BOTTOM = "bottom";
    public static final String MIDDLE = "middle";
    public static final String TOP = "top";
    public static final String ABSMIDDLE = "absmiddle";

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setWidth(String w) {
        this.width = w;
    }

    public String getWidth() {
        return this.width;
    }

    public void setHeight(String h) {
        this.height = h;
    }

    public String getHeight() {
        return this.height;
    }

    public void setBorder(String b) {
        this.border = b;
    }

    public String getBorder() {
        return this.border;
    }

    public void setHspace(String hs) {
        this.hspace = hs;
    }

    public String getHspace() {
        return this.hspace;
    }

    public void setVspace(String v) {
        this.vspace = v;
    }

    public String getVspace() {
        return this.vspace;
    }

    public void setAlign(String a) {
        this.align = BOTTOM.equalsIgnoreCase(a) || MIDDLE.equalsIgnoreCase(a) || TOP.equalsIgnoreCase(a) || ABSMIDDLE.equalsIgnoreCase(a) ? a : null;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAltKey(String key) {
        this.altKey = key;
    }

    public String getAltKey() {
        return this.altKey;
    }

    public void setOnclick(String oc) {
        this.onclick = oc;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        Theme theme = null;
        try {
            theme = this.getTheme();
        }
        catch (ThemeException te) {
            throw new JspException("ThemeImageTag: " + te.getMessage(), (Throwable)te);
        }
        String nam = this.getName();
        if (null == nam) {
            return 0;
        }
        Image image = theme.getImage(nam);
        if (null == image) {
            return 0;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        StringBuffer imgtag = new StringBuffer("<img src=\"");
        String imgFile = image.getFile();
        if (imgFile.length() > 5 && (imgFile.substring(0, 5).equalsIgnoreCase("http:") || imgFile.substring(0, 6).equalsIgnoreCase("https:"))) {
            imgtag.append(imgFile);
        } else {
            try {
                imgtag.append(ThemeHelper.getThemePath("IMAGE", true, request));
            }
            catch (ThemeException e) {
                throw new JspException((Throwable)e);
            }
            imgtag.append(imgFile);
        }
        imgtag.append("\"");
        String str = this.checkAltKey(image);
        if (null != str) {
            imgtag.append(" alt=\"").append(str).append("\"");
        }
        if (null != str && !"".equals(str.trim())) {
            imgtag.append(" title=\"").append(str).append("\"");
        }
        if (null != (str = this.checkWidth(image))) {
            imgtag.append(" width=\"").append(str).append("\"");
        }
        if (null != (str = this.checkHeight(image))) {
            imgtag.append(" height=\"").append(str).append("\"");
        }
        if (null != (str = this.getBorder())) {
            imgtag.append(" border=\"").append(str).append("\"");
        }
        if (null != (str = this.getAlign())) {
            imgtag.append(" align=\"").append(str).append("\"");
        }
        if (null != (str = this.getHspace())) {
            imgtag.append(" hspace=\"").append(str).append("\"");
        }
        if (null != (str = this.getVspace())) {
            imgtag.append(" vspace=\"").append(str).append("\"");
        }
        if (null != (str = this.getOnclick())) {
            imgtag.append(" onclick=\"").append(str).append("\"");
        }
        if (null != (str = this.getId())) {
            imgtag.append(" id=\"").append(str).append("\"");
        }
        if (null != (str = this.getStyleClass())) {
            imgtag.append(" class=\"").append(str).append("\"");
        }
        imgtag.append(" />");
        try {
            writer.print(imgtag.toString());
        }
        catch (IOException ioe) {
            throw new JspException("ThemeImageTag: " + ioe.getMessage(), (Throwable)ioe);
        }
        return 0;
    }

    protected String checkWidth(Image image) {
        if (null != this.getWidth()) {
            return this.getWidth();
        }
        if (null != image.getWidth()) {
            return image.getWidth();
        }
        return null;
    }

    protected String checkHeight(Image image) {
        if (null != this.getHeight()) {
            return this.getHeight();
        }
        if (null != image.getHeight()) {
            return image.getHeight();
        }
        return null;
    }

    protected String checkAltKey(Image image) {
        String alt;
        String key = this.getAltKey();
        if (null == key) {
            key = image.getAltTextKey();
        }
        if (null != key) {
            alt = this.getTextFromResource(key);
            if ("! MISSING-RESOURCE !".equals(alt)) {
                ResourceBundle rb = ResourceBundle.getBundle("com.sas.framework.webapp.i18n.AppResources", this.getUserLocale());
                try {
                    alt = rb.getString(key);
                }
                catch (MissingResourceException mre) {
                    alt = image.getDescription();
                }
            }
        } else {
            alt = image.getDescription();
        }
        if ("! MISSING-RESOURCE !".equals(alt) || null == alt) {
            alt = "";
        }
        return alt;
    }
}

