/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.PopupMenuTag;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.swing.table.TableModel;

public class TablePopupMenuTag
extends PopupMenuTag {
    private static final long serialVersionUID = 1L;
    protected String modelName = null;
    protected String keyColumnIndex = null;
    protected String actionListColumnIndex = null;
    protected int startRow = -1;
    protected int endRow = -1;
    protected StringBuffer rowIdentifierParameter = null;

    public void setKeyColumnIndex(String keyColumnIndex) {
        this.keyColumnIndex = keyColumnIndex;
    }

    public String getKeyColumnIndex() {
        return this.keyColumnIndex;
    }

    public void setActionListColumnIndex(String actionListColumnIndex) {
        this.actionListColumnIndex = actionListColumnIndex;
    }

    public String getActionListColumnIndex() {
        return this.actionListColumnIndex;
    }

    public void setModel(String modelName) {
        this.modelName = modelName;
    }

    public String getModel() {
        return this.modelName;
    }

    @Override
    protected String getPopupMenuHTML() throws ThemeException {
        String menuid = this.getId();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ResourceBundle rb = ResourceBundle.getBundle(FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Actions"), this.getUserLocale());
        ActionResourceLoader actionLoader = new ActionResourceLoader(rb, (Object)this);
        ActionList actionList = null;
        StringBuffer menusHTML = new StringBuffer();
        TableModel model = this.getModelInstance();
        if (null == model) {
            return "";
        }
        int rowCount = model.getRowCount();
        int start = this.getStartRow();
        int end = this.getEndRow() + 1;
        if (start < 0) {
            start = 0;
        }
        if (end <= 0) {
            end = rowCount;
        }
        String tmpComponentId = this.getComponentId();
        String tmpRelativeId = this.getPositionRelativeToId();
        for (int row = start; row < end; ++row) {
            List actions;
            this.setComponentId(tmpComponentId + row);
            this.setPositionRelativeToId(tmpRelativeId + row);
            if (null == this.getActionListColumnIndex()) {
                actionList = actionLoader.getActionList(this.getActionList());
                actions = actionList.getActions();
            } else {
                Object modelObject = model.getValueAt(row, Integer.parseInt(this.getActionListColumnIndex()));
                if (null == modelObject) continue;
                if (modelObject instanceof List) {
                    actions = (List)modelObject;
                } else if (modelObject instanceof String) {
                    actionList = actionLoader.getActionList((String)modelObject);
                    actions = actionList.getActions();
                } else {
                    actionList = actionLoader.getActionList(this.getActionList());
                    actions = actionList.getActions();
                }
            }
            if (null == actions || actions.size() < 1) continue;
            this.rowIdentifierParameter = new StringBuffer();
            if (null != this.getKeyColumnIndex() && !"".equals(this.getKeyColumnIndex())) {
                String keyColumn = this.getKeyColumnIndex();
                StringTokenizer tokenizer = new StringTokenizer(keyColumn, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    int index = Integer.parseInt(token);
                    Object keyValue = model.getValueAt(row, index);
                    String keyName = model.getColumnName(index);
                    this.rowIdentifierParameter.append(keyName).append("=").append(keyValue);
                    if (!tokenizer.hasMoreTokens()) continue;
                    this.rowIdentifierParameter.append("&");
                }
            }
            this.setId(menuid + row);
            menusHTML.append(this.getPopupMenuHTML(actions));
        }
        return menusHTML.toString();
    }

    @Override
    protected String getActionURL(Action action, StringBuffer parameters) {
        this.addParameter(parameters, this.rowIdentifierParameter);
        StringBuilder url = new StringBuilder(super.getActionURL(action, parameters));
        return url.toString();
    }

    private TableModel getModelInstance() {
        TableModel model = null;
        if (this.getScope().equalsIgnoreCase("request")) {
            model = (TableModel)this.pageContext.getRequest().getAttribute(this.modelName);
        } else if (this.getScope().equalsIgnoreCase("session")) {
            model = (TableModel)this.pageContext.getSession().getAttribute(this.modelName);
        } else if (this.getScope().equalsIgnoreCase("page")) {
            model = (TableModel)this.pageContext.getAttribute(this.modelName);
        }
        return model;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }
}

