/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseMessageTag;
import com.sas.util.SimpleTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class SystemQuiescedTag
extends BaseMessageTag {
    private static final long serialVersionUID = 1L;
    private static final String HTML_TR = "<tr>";
    private static final String HTML_TR_CLOSE = "</tr>";
    private static final String HTML_TABLE_CLOSE = "</table>";

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        boolean paused = false;
        String alreadyReported = (String)request.getAttribute("sas_solutions_sessions_quiesced");
        if (Boolean.TRUE.toString().equals(alreadyReported)) {
            paused = true;
        }
        if (!paused) {
            paused = this.isQuiesced();
        }
        if (!paused) {
            return 0;
        }
        JspWriter writer = this.pageContext.getOut();
        boolean isPortlet = FrameworkHelper.isPortlet(request);
        try {
            HashMap<String, String> dictionary = new HashMap<String, String>();
            dictionary.put("ICON", this.getImagesPath() + this.getIcon());
            dictionary.put("IMAGE_PATH", this.getImagesPath(true));
            dictionary.put("TITLE_STYLE", this.getTitleStyleClass());
            dictionary.put("TEXT_STYLE", this.getStyleClass());
            dictionary.put("BG_STYLE", this.getBgStyleClass());
            dictionary.put("MESSAGE", RB.getString("SystemQuiescedTag.warning.txt", this.getUserLocale()));
            SimpleTemplate template = new SimpleTemplate();
            if (isPortlet) {
                template.setTemplate(this.getPortletTemplate());
            } else {
                template.setTemplate(this.getWebappTemplate());
            }
            writer.println(template.format(dictionary));
        }
        catch (ThemeException te) {
            throw new JspException("SystemQuiescedTag. " + te.getMessage(), (Throwable)te);
        }
        catch (IOException ioe) {
            throw new JspException("SystemQuiescedTag. " + ioe.getMessage(), (Throwable)ioe);
        }
        return 0;
    }

    private String getPortletTemplate() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("<div id=\"sas_system_quiesced\">");
        pw.println("<!-- System quiesced message for portlet -->");
        pw.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" class=\"%BG_STYLE(%BG_STYLE,dataEntryBG)\">");
        pw.println(HTML_TR);
        pw.println("   <td height=\"2\"><img src=\"%IMAGE_PATH/spacer.gif\" height=\"2\"></td>");
        pw.println(HTML_TR_CLOSE);
        pw.println(HTML_TR);
        pw.println("   <td>");
        pw.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">");
        pw.println(HTML_TR);
        pw.println("<td width=\"2\"><img src=\"%IMAGE_PATH/spacer.gif\" width=\"2\"></td>");
        pw.print("<td nowrap valign=\"top\" width=\"19\"><img src=\"%IMAGE_PATH/MessageWarning16.gif\"");
        pw.println("border=\"0\" height=\"16\" width=\"16\"><img src=\"%IMAGE_PATH/spacer.gif\" width=\"3\"></td>");
        pw.println("<td align=\"left\" class=\"%TEXT_STYLE\">");
        pw.println("<span class=\"%TEXT_STYLE\">");
        pw.println("<b>%MESSAGE</b>");
        pw.println("      </span></td>");
        pw.println("      <td width=\"2\"><img src=\"%IMAGE_PATH/spacer.gif\" width=\"2\"></td>");
        pw.println("   </tr>");
        pw.println(HTML_TABLE_CLOSE);
        pw.println("   </td>");
        pw.println(HTML_TR_CLOSE);
        pw.println(HTML_TABLE_CLOSE);
        pw.println("</div>");
        pw.close();
        return baos.toString();
    }

    private String getWebappTemplate() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("<div id=\"sas_system_quiesced\">");
        pw.println("<!-- System quiesced message for portlet -->");
        pw.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" class=\"%BG_STYLE(%BG_STYLE,dataEntryBG)\">");
        pw.println(HTML_TR);
        pw.println("   <td height=\"3\"><img src=\"%IMAGE_PATH/spacer.gif\" height=\"3\"></td>");
        pw.println(HTML_TR_CLOSE);
        pw.println(HTML_TR);
        pw.println("   <td>");
        pw.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"  class=\"warningMessageBox\">");
        pw.println("<tr><td colspan=\"4\"><img src=\"%IMAGE_PATH/spacer.gif\" height=\"3\"></td></tr>");
        pw.println(HTML_TR);
        pw.println("<td width=\"2\"><img src=\"%IMAGE_PATH/spacer.gif\" width=\"2\"></td>");
        pw.print("<td nowrap valign=\"top\" width=\"19\"><img src=\"%IMAGE_PATH/MessageWarning16.gif\"");
        pw.println("border=\"0\" height=\"16\" width=\"16\"><img src=\"%IMAGE_PATH/spacer.gif\" width=\"3\"></td>");
        pw.println("<td align=\"left\" class=\"%TEXT_STYLE\">");
        pw.println("<span class=\"%TEXT_STYLE\">");
        pw.println("<b>%MESSAGE</b>");
        pw.println("      </span></td>");
        pw.println("      <td width=\"3\"><img src=\"%IMAGE_PATH/spacer.gif\" width=\"3\"></td>");
        pw.println("   </tr>");
        pw.println("<tr><td colspan=\"4\"><img src=\"%IMAGE_PATH/spacer.gif\" height=\"3\"></td></tr>");
        pw.println(HTML_TABLE_CLOSE);
        pw.println("   </td>");
        pw.println(HTML_TR_CLOSE);
        pw.println(HTML_TR);
        pw.println("   <td height=\"8\"><img src=\"%IMAGE_PATH/spacer.gif\" height=\"8\"></td>");
        pw.println(HTML_TR_CLOSE);
        pw.println(HTML_TABLE_CLOSE);
        pw.println("</div>");
        pw.close();
        return baos.toString();
    }

    protected boolean isQuiesced() {
        return false;
    }
}

