/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseTextElement;
import com.sas.util.Strings;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class SectionViewTag
extends BaseTextElement {
    private static final long serialVersionUID = 1L;
    private static final String IMG_SHOW = "IMG_SHOW";
    private static final String IMG_HIDE = "IMG_HIDE";
    private static final String IMG_SHOW_ALT = "IMG_SHOW_ALT";
    private static final String IMG_HIDE_ALT = "IMG_HIDE_ALT";
    private static final String HEADING = "HEADING";
    private static final String DIV_NAME = "DIV_NAME";
    private static final String BUTTON_NAME = "BUTTON_NAME";
    private static final String SECTION_STYLE = "SECTION_STYLE";
    private static final String DIV_SECTION = "sas_ui_section_";
    protected String DEFAULT_TEMPLATE = "section_view";
    private String imgShow = "section_show";
    private String imgHide = "section_hide";
    private String sectionStyleClass = "sectionViewDefaultBackground";
    private String name;
    private String displayName;
    private String width = "95%";
    private boolean displayed = false;

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getImgHide() {
        return this.imgHide;
    }

    public String getImgShow() {
        return this.imgShow;
    }

    public void setImgHide(String img) {
        this.imgHide = img;
    }

    public void setImgShow(String img) {
        this.imgShow = img;
    }

    public String getSectionStyleClass() {
        return this.sectionStyleClass;
    }

    public void setSectionStyleClass(String style) {
        this.sectionStyleClass = style;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String wid) {
        this.width = wid;
    }

    public void setDisplayed(boolean flag) {
        this.displayed = flag;
    }

    public boolean isDisplayed() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String parameter = request.getParameter(this.getDivID() + "_hidden");
        String attribute = (String)request.getAttribute(this.getDivID());
        return this.displayed || "true".equals(parameter) || "true".equals(attribute);
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        JspWriter writer = this.pageContext.getOut();
        try {
            Theme theme = this.getTheme();
            String heading = this.getDisplayName() == null ? this.getTextFromResource(this.getResourceKeyName()) : this.getDisplayName();
            String divid = this.getDivID();
            String showImage = ThemeHelper.getImagePath(theme, this.getImgShow());
            String hideImage = ThemeHelper.getImagePath(theme, this.getImgHide());
            Locale userLocale = this.getUserLocale();
            String showAlt = RB.formatString("SectionViewTag.show.section.fmt.txt", userLocale, (Object)heading);
            String hideAlt = RB.formatString("SectionViewTag.hide.section.fmt.txt", userLocale, (Object)heading);
            Dictionary dictionary = new Dictionary();
            dictionary.set((Object)IMG_SHOW, (Object)showImage);
            dictionary.set((Object)IMG_HIDE, (Object)hideImage);
            dictionary.set((Object)IMG_SHOW_ALT, (Object)showAlt);
            dictionary.set((Object)IMG_HIDE_ALT, (Object)hideAlt);
            if (this.isDisplayed()) {
                dictionary.set((Object)"SHOW_IT", (Object)"true");
            }
            dictionary.set((Object)HEADING, (Object)heading);
            dictionary.set((Object)DIV_NAME, (Object)divid);
            dictionary.set((Object)"INPUT_NAME", (Object)(divid + "_hidden"));
            dictionary.set((Object)BUTTON_NAME, (Object)(divid + "_btn"));
            dictionary.set((Object)SECTION_STYLE, (Object)this.getSectionStyleClass());
            dictionary.set((Object)"WINDOW_STATUS", (Object)Strings.escapeForJavaScript((String)RB.formatString("SectionViewTag.window.status.fmt.txt", userLocale, (Object)heading), (boolean)true));
            dictionary.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(true));
            dictionary.set((Object)"STYLE", (Object)this.getStyleClass());
            writer.println("<!-- " + heading + " Section View -->");
            writer.println("<script type=\"text/javascript\">");
            writer.println("function setImagesFor_" + divid + "(){");
            writer.println("   showImg.src=\"" + showImage + "\";hideImg.src=\"" + hideImage + "\"; ");
            writer.println("   showAlt=\"" + showAlt + "\";  hideAlt=\"" + hideAlt + "\"; }");
            writer.println("</script>");
            writer.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"" + this.getWidth() + "\" class=\"sectionView\">");
            writer.println("<tr>");
            writer.println("<td>");
            writer.println(this.applyTemplate(dictionary, this.DEFAULT_TEMPLATE));
            writer.println("</td></tr>");
            writer.println("<tr><td>");
            writer.println("<div id=\"" + divid + "\" class=\"" + this.getSectionStyleClass() + "\" style=\"display:" + (this.isDisplayed() ? "block" : "none") + "\">");
        }
        catch (ThemeException te) {
            throw new JspException("SectionViewTag " + te.getMessage(), (Throwable)te);
        }
        catch (IOException e) {
            throw new JspException("SectionViewTag " + e.getMessage());
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.println("</div><!-- " + this.getDivID() + " -->");
            writer.println("</td></tr>");
            writer.println("</table>");
        }
        catch (IOException e) {
            throw new JspException("SectionViewTag " + e.getMessage());
        }
        this.release();
        return 6;
    }

    protected String getDivID() {
        return DIV_SECTION + this.getName().replace('.', '_');
    }

    @Override
    protected String getResourceKeyName() {
        String headingKey = this.getName();
        if (headingKey.endsWith(".txt")) {
            return headingKey;
        }
        StringBuilder key = new StringBuilder();
        String pageKey = this.getPageKey();
        if (null != pageKey) {
            key.append(pageKey);
            key.append('.');
        }
        key.append(headingKey);
        key.append(".section.txt");
        return key.toString();
    }
}

