/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseTextElement;
import com.sas.framework.webapp.util.ActionErrors;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class PromptTag
extends BaseTextElement {
    private static final long serialVersionUID = 1L;
    protected String DEFAULT_TEMPLATE = "prompt";
    protected String PROMPT_ERROR_TEMPLATE = "prompt_error";
    private boolean required = false;

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean flag) {
        this.required = flag;
    }

    public int doStartTag() throws JspException {
        if (null == this.getProperty()) {
            return 0;
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            Dictionary dict = this.getTemplateDictionary();
            String value = this.applyTemplate(dict, this.DEFAULT_TEMPLATE);
            writer.println(value);
        }
        catch (ThemeException te) {
            throw new JspException("PromptTag. " + te.getMessage(), (Throwable)te);
        }
        catch (IOException e) {
            throw new JspException("PromptTag. " + e.getMessage());
        }
        return 0;
    }

    public boolean isPropertyInError() {
        boolean propertyInError = false;
        ActionErrors strutsErrors = (ActionErrors)this.pageContext.getAttribute("org.apache.struts.action.ERROR", 2);
        if (null != strutsErrors && !strutsErrors.isEmpty()) {
            Iterator props = strutsErrors.properties();
            while (props.hasNext()) {
                String property = (String)props.next();
                if (!property.equals(this.getProperty())) continue;
                propertyInError = true;
                break;
            }
        }
        return propertyInError;
    }

    protected Dictionary getTemplateDictionary() throws ThemeException {
        Dictionary dict = new Dictionary();
        dict.set((Object)"PROMPT_STYLE", (Object)this.getStyleClass());
        dict.set((Object)"PROMPT", (Object)this.getTextFromResource(this.getResourceKeyName()));
        if (this.isRequired()) {
            dict.set((Object)"REQUIRED", (Object)"true");
            dict.set((Object)"REQUIRED_TEXT", (Object)RB.getString("PromptTag.required.txt", this.getUserLocale()));
        }
        dict.set((Object)"ERROR_IMAGE", (Object)this.getErrorImageTemplate());
        dict.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(true));
        return dict;
    }

    protected String getErrorImageTemplate() throws ThemeException {
        String template = "";
        if (this.isPropertyInError()) {
            Dictionary dict = new Dictionary();
            dict.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(true));
            dict.set((Object)"ERROR", (Object)RB.getString("PromptTag.error.txt", this.getUserLocale()));
            template = this.applyTemplate(dict, this.PROMPT_ERROR_TEMPLATE);
        }
        return template;
    }

    @Override
    protected String getResourceKeyName() {
        String property = this.getProperty();
        if (property.endsWith(".txt")) {
            return property;
        }
        StringBuilder key = new StringBuilder();
        String pageKey = this.getPageKey();
        if (null != pageKey) {
            key.append(pageKey).append('.');
        }
        key.append(property).append(".prompt.txt");
        return key.toString();
    }
}

