/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.collection.DictionaryInterface;
import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.BaseTextSupport;
import com.sas.framework.webapp.util.ToggledPopMenuTO;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.util.Strings;
import com.sas.util.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PopupMenuTag
extends BaseTextSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuTag.class);
    public static final String ACTION_TARGET = "target";
    public static final String DEFAULT_TARGET = "_self";
    public static final String MENU_LIST = "com.sas.solutions.menus.list";
    public static final String TOGGLED_MENU_LIST = "sas.solutions.toggled.menus";
    protected String actionListName = "";
    protected String actionParms = "";
    protected String form = "";
    protected String imageStyle = "";
    protected boolean imageAlley = true;
    protected String otherId;
    protected boolean writeClose = false;
    protected String source;
    protected String uniqueId;
    protected String relativeComponentId;
    protected String positionRelativeToId;

    public void setComponentId(String componentId) {
        this.relativeComponentId = componentId;
    }

    public String getComponentId() {
        return this.relativeComponentId;
    }

    public String getPositionRelativeToId() {
        return this.positionRelativeToId != null ? this.positionRelativeToId : this.relativeComponentId;
    }

    public void setPositionRelativeToId(String setPositionRelativeComponentId) {
        this.positionRelativeToId = setPositionRelativeComponentId;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getForm() {
        return this.form;
    }

    public void setActionParms(String actionParms) {
        this.actionParms = actionParms;
    }

    public String getActionParms() {
        return this.actionParms;
    }

    public void setActionList(String actionList) {
        this.actionListName = actionList;
    }

    public String getActionList() {
        return this.actionListName;
    }

    protected String getPopupMenuHTML() throws ThemeException {
        List list;
        if ("session".equals(this.getScope())) {
            list = (List)this.pageContext.getSession().getAttribute(this.getActionList());
        } else {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            ResourceBundle rb = ResourceBundle.getBundle(FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Actions"), this.getUserLocale());
            ActionResourceLoader actionLoader = new ActionResourceLoader(rb, (Object)this);
            ActionList actionList = actionLoader.getActionList(this.getActionList());
            list = actionList.getActions();
        }
        if (null == list) {
            return "";
        }
        return this.getPopupMenuHTML(list);
    }

    protected String getPopupMenuHTML(List actions) throws ThemeException {
        String unique = this.getId();
        if (null != this.getUniqueId()) {
            unique = unique + this.getUniqueId();
        }
        PopupMenu popMenu = new PopupMenu(unique);
        popMenu.setRequest((HttpServletRequest)this.pageContext.getRequest());
        popMenu.setResponse((HttpServletResponse)this.pageContext.getResponse());
        if (null != this.positionRelativeToId && !"".equals(this.positionRelativeToId)) {
            popMenu.setPositionRelativeTo(this.positionRelativeToId);
        }
        popMenu.attachTo(this.relativeComponentId);
        ArrayList<PopupMenuItem> menuModel = new ArrayList<PopupMenuItem>();
        for (Object actionObject : actions) {
            if (actionObject instanceof String) {
                PopupMenuItem item = new PopupMenuItem();
                item.setSeparator(true);
                menuModel.add(item);
                continue;
            }
            if (actionObject instanceof ActionList) continue;
            Action action = (Action)actionObject;
            String url = this.buildCommand(action);
            String name = (String)action.getValue("Name");
            String imageName = (String)action.getValue("SmallIconName");
            String target = (String)action.getValue(ACTION_TARGET);
            String string = target = null != target ? target : DEFAULT_TARGET;
            if (StringUtils.isNotEmpty((CharSequence)this.getForm())) {
                target = DEFAULT_TARGET;
            }
            PopupMenuItem item = new PopupMenuItem();
            item.setText(name);
            item.setImage(imageName);
            item.setUrl(url);
            menuModel.add(item);
        }
        popMenu.setModel(menuModel);
        return popMenu.toString();
    }

    protected String getActionHTML(String actionId, Action action) throws ThemeException {
        String type;
        String url = this.buildCommand(action);
        String name = (String)action.getValue("Name");
        String imageName = (String)action.getValue("SmallIconName");
        String imagePath = this.getImagesPath(true);
        String target = (String)action.getValue(ACTION_TARGET);
        String string = target = null != target ? target : DEFAULT_TARGET;
        if (StringUtils.isNotEmpty((CharSequence)this.getForm())) {
            target = DEFAULT_TARGET;
        }
        StringBuffer image = new StringBuffer();
        if (StringUtils.isNotEmpty((CharSequence)imageName)) {
            imageName = imagePath + imageName;
            image.append("<img src=\"").append(imageName).append("\" border=\"0\" id=\"").append(actionId).append("Img\" alt=\"").append(name).append("\"/>");
        }
        if (null != (type = (String)action.getValue("Type")) && type.equals("boolean") && url.startsWith("javascript:")) {
            if (!url.endsWith(";")) {
                url = url + ";";
            }
            url = url + "toggleActionState('" + actionId + "');";
            this.setToggledStateMenu(actionId, action, imagePath);
        }
        StringBuilder shade = new StringBuilder(25);
        shade.append("shadeAction('").append(actionId).append("', ").append(this.imageAlley);
        StringBuilder unshade = new StringBuilder(25);
        unshade.append("unshadeAction('").append(actionId).append("', ").append(this.imageAlley);
        StringBuilder retValue = new StringBuilder(300);
        retValue.append("<tr><td width=\"100%\">");
        retValue.append("<table id=\"").append(actionId).append("\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"");
        retValue.append("onMouseOver=\"").append((CharSequence)shade).append(");this.style.cursor='hand';\"");
        retValue.append(" onMouseOut=\"").append((CharSequence)unshade).append(")\">");
        if (null == target || "".equals(target)) {
            target = DEFAULT_TARGET;
        }
        retValue.append("<a onFocus=\"").append((CharSequence)shade).append(")\"");
        retValue.append(" onBlur=\"").append((CharSequence)unshade).append(")\"");
        retValue.append(" target=\"").append(target).append("\" href=\"").append(url).append("\">");
        retValue.append("<tr><td id=\"").append(actionId).append("Image").append("\" class=\"").append(this.imageStyle).append("\">");
        retValue.append("<a tabindex=\"-1\" target=\"").append(target).append("\" href=\"").append(url).append("\">");
        retValue.append(image);
        retValue.append("</a>");
        retValue.append("</td><td class=\"popupMenuActionText\">");
        retValue.append(name);
        retValue.append("</td></tr>");
        retValue.append("</a>");
        retValue.append("</table></td></tr>\n");
        return retValue.toString();
    }

    protected String getSeparatorHTML(String actionId) {
        StringBuilder retValue = new StringBuilder(300);
        retValue.append("<tr><td width=\"100%\">");
        retValue.append("<table id=\"").append(actionId).append("\" cellpadding=\"0\" cellspacing=\"0\">");
        retValue.append("<tr style=\"height: 6\"><td class=\"");
        retValue.append(this.imageStyle);
        retValue.append("\"/><td class=\"popupMenuActionText\"/></tr>");
        retValue.append("<tr style=\"height: 1\"><td class=\"");
        retValue.append(this.imageStyle);
        retValue.append("\"/><td class=\"popupMenuSeparator\"/></tr>");
        retValue.append("<tr style=\"height: 6\"><td class=\"");
        retValue.append(this.imageStyle);
        retValue.append("\"/><td class=\"popupMenuActionText\"/></tr>");
        retValue.append("</table></td></tr>");
        return retValue.toString();
    }

    protected String buildCommand(Action action) {
        StringBuffer command = new StringBuffer();
        String destination = this.getActionURL(action, this.getBaseParameters());
        String target = (String)action.getValue(ACTION_TARGET);
        target = null != target ? target : DEFAULT_TARGET;
        String confirmKey = (String)action.getValue("confirm.key");
        if (StringUtils.isNotEmpty((CharSequence)this.getForm()) || StringUtils.isNotEmpty((CharSequence)confirmKey)) {
            command.append("javascript:");
        }
        if (StringUtils.isNotEmpty((CharSequence)confirmKey)) {
            String confirmMessage = this.getTextFromResource(confirmKey);
            command.append("if (confirmAction('").append(Strings.escapeForJavaScript((String)confirmMessage)).append("')) ");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getForm())) {
            command.append("submitFormAction('").append(this.getForm()).append("','").append(destination).append("','").append(target).append("');");
        } else if (StringUtils.isNotEmpty((CharSequence)confirmKey)) {
            command.append("document.location='").append(destination).append("';");
        } else {
            command.append(destination);
        }
        return command.toString();
    }

    protected StringBuffer getBaseParameters() {
        StringBuffer parms = new StringBuffer();
        if (null != this.getActionParms() && !this.getActionParms().equals("")) {
            this.addParameter(parms, new StringBuffer(this.getActionParms()));
        }
        return parms;
    }

    protected String getActionURL(Action action, StringBuffer parameters) {
        StringBuilder actionURL = new StringBuilder();
        Object actionCommand = action.getValue("command.notrans");
        actionURL.append(actionCommand);
        if (actionURL.indexOf("?") >= 0 && parameters.indexOf("?") >= 0) {
            parameters = new StringBuffer("&" + parameters.substring(1));
        }
        if (!actionURL.toString().startsWith("javascript:")) {
            actionURL.append(parameters);
        } else if (actionURL.indexOf("%") > 0) {
            Dictionary dict = new Dictionary();
            String parms = parameters.substring(1);
            dict.set((Object)"ACTION_PARMS", (Object)parms);
            Template template = new Template((DictionaryInterface)dict);
            String actionString = actionURL.toString();
            template.setTemplate(actionString);
            actionString = template.getText();
            actionURL = new StringBuilder(actionString);
        }
        return actionURL.toString();
    }

    protected void addParameter(StringBuffer baseURL, StringBuffer parameter) {
        if (baseURL.indexOf("?") == -1) {
            baseURL.append("?").append(parameter);
        } else {
            baseURL.append("&").append(parameter);
        }
    }

    protected boolean imagesPresent(List actions) {
        for (Object actionObject : actions) {
            Action action;
            String imageName;
            if (!(actionObject instanceof Action) || !StringUtils.isNotEmpty((CharSequence)(imageName = (String)(action = (Action)actionObject).getValue("SmallIconName")))) continue;
            return true;
        }
        return false;
    }

    protected void setToggledStateMenu(String actionId, Action action, String imagePath) {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ArrayList<ToggledPopMenuTO> toggledPopMenus = (ArrayList<ToggledPopMenuTO>)request.getAttribute(TOGGLED_MENU_LIST);
        if (toggledPopMenus == null) {
            toggledPopMenus = new ArrayList<ToggledPopMenuTO>();
            request.setAttribute(TOGGLED_MENU_LIST, toggledPopMenus);
        }
        ToggledPopMenuTO to = new ToggledPopMenuTO();
        to.setId(actionId);
        to.setEnabledImage(imagePath + (String)action.getValue("SmallIconName"));
        to.setDisabledImage(imagePath + (String)action.getValue("SmallDisabledIconName"));
        String state = (String)action.getValue("GroupName");
        to.setState("on".equalsIgnoreCase(state));
        toggledPopMenus.add(to);
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.println(this.getPopupMenuHTML());
        }
        catch (ThemeException te) {
            LOGGER.error(te.getMessage(), (Throwable)te);
            throw new JspException();
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getMessage(), (Throwable)ioe);
            throw new JspException();
        }
        return 0;
    }

    public String getOtherId() {
        return this.otherId;
    }

    public void setOtherId(String i) {
        this.otherId = i;
    }

    public boolean getWriteClose() {
        return this.writeClose;
    }

    public void setWriteClose(boolean w) {
        this.writeClose = w;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public String getUniqueId() {
        return this.uniqueId == null ? "" : this.uniqueId;
    }

    public void setUniqueId(String u) {
        this.uniqueId = u;
    }
}

