/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.webapp.taglib.UIBodyTagSupport;
import com.sas.framework.webapp.util.ToggledPopMenuTO;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PopupMenuCloseTag
extends UIBodyTagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuCloseTag.class);

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            this.writeClose(out);
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getMessage(), (Throwable)ioe);
            throw new JspException();
        }
        return 0;
    }

    private void writeClose(JspWriter out) throws IOException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String maxMenuCount = (String)request.getAttribute("sas.max.portlet.popmenu.rows");
        List menuList = (List)request.getAttribute("com.sas.solutions.menus.list");
        List toggledPopMenus = (List)request.getAttribute("sas.solutions.toggled.menus");
        if (null != menuList) {
            out.println("<script type=\"text/javascript\">");
            out.println("  function closeAll(e)");
            out.println("  {");
            for (String next : menuList) {
                if (null == maxMenuCount) {
                    out.println("    closeMenus('" + next + "');");
                    continue;
                }
                out.println("    closePortletMenus('" + next + "', " + maxMenuCount + ");");
            }
            out.println("    showTags('SELECT');");
            out.println("    showTags('APPLET');");
            out.println("  }");
            out.println("  document.onmouseup = closeAll;");
            if (null != toggledPopMenus) {
                out.println("  var toggledPopMenus = new Array( ");
                int ctr = 1;
                for (ToggledPopMenuTO to : toggledPopMenus) {
                    out.print("     new ToggledPopMenu('" + to.getId() + "','" + to.getEnabledImage() + "',");
                    out.print("'" + to.getDisabledImage() + "', " + Boolean.toString(to.isState()) + ")");
                    if (ctr < toggledPopMenus.size()) {
                        out.println(",");
                    }
                    ++ctr;
                }
                out.println("     ); ");
                out.println("  initToggledPopMenus();");
            }
            out.println("</script>");
        }
    }
}

