/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.webapp.taglib.UIBodyTagSupport;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class MetaRefreshTag
extends UIBodyTagSupport {
    private static final long serialVersionUID = 1L;
    private String url = null;
    private int interval = -1;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public int getInterval() {
        if (this.interval > 0) {
            return this.interval;
        }
        int refreshInterval = this.pageContext.getSession().getMaxInactiveInterval();
        Integer ri = (Integer)this.pageContext.getAttribute("sas.framework.meta_refresh_int", 2);
        if (null != ri) {
            refreshInterval = ri;
        }
        return refreshInterval;
    }

    public void setInterval(int i) {
        this.interval = i;
    }

    public int doStartTag() throws JspException {
        Boolean flag = (Boolean)this.pageContext.getAttribute("sas.framework.meta_refresh", 2);
        if (null == flag) {
            flag = Boolean.TRUE;
        }
        if (!flag.booleanValue()) {
            return 0;
        }
        String targetUrl = this.getUrl();
        if (null == targetUrl || "".equals(targetUrl.trim())) {
            return 0;
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print("<meta http-equiv=\"refresh\" content=\"");
            writer.print(Integer.toString(this.getInterval()));
            writer.println("; url=" + targetUrl + "\" />");
        }
        catch (IOException e) {
            throw new JspException("MetaRefreshTag. " + e.getMessage());
        }
        return 0;
    }
}

