/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.collection.DictionaryInterface;
import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.MenuHelper;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import com.sas.servlet.tbeans.html.TabButton;
import com.sas.servlet.tbeans.html.TabMenu;
import com.sas.servlet.tbeans.menus.menubar.html.SimpleMenuBar;
import com.sas.servlet.tbeans.menus.model.MenuBarItem;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.util.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;

public class MenuBarTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private String defaultMenuHeight;
    private String primaryRowClass;
    private String secondaryRowClass;
    private String menuId;
    private boolean useContext = true;
    private static final String MENU_PREFIX = "menuPrefix";
    private static final String THEME_IMAGE = "theme.image";
    protected String DEFAULT_TEMPLATE = "menubar";

    public MenuBarTag() {
        this.setTemplate(this.DEFAULT_TEMPLATE);
    }

    public void setDefaultMenuHeight(String height) {
        this.defaultMenuHeight = height;
    }

    public String getDefaultMenuHeight() {
        return null == this.defaultMenuHeight ? "0" : this.defaultMenuHeight;
    }

    public void setPrimaryRowClass(String newclass) {
        this.primaryRowClass = newclass;
    }

    public String getPrimaryRowClass() {
        return null == this.primaryRowClass ? "primaryMenuRow" : this.primaryRowClass;
    }

    public void setSecondaryRowClass(String newclass) {
        this.secondaryRowClass = newclass;
    }

    public String getSecondaryRowClass() {
        return null == this.secondaryRowClass ? "secondaryMenuRow" : this.secondaryRowClass;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public boolean isUseContext() {
        return this.useContext;
    }

    public void setUseContext(boolean ctxt) {
        this.useContext = ctxt;
    }

    public Dictionary getTemplateDictionary(TabMenu primary, SimpleMenuBar secondary, HttpServletRequest request) throws ThemeException {
        String primaryString = "";
        String secondaryString = "";
        if (null != primary) {
            primaryString = primary.toString();
        }
        if (null != secondary) {
            secondaryString = secondary.toString();
        }
        Dictionary dict = new Dictionary();
        dict.set((Object)"PRIMARY_MENUBAR", (Object)primaryString);
        dict.set((Object)"SECONDARY_MENUBAR", (Object)secondaryString);
        if (null == secondary && null != primary) {
            dict.set((Object)"SECONDARY_MENU_HEIGHT", (Object)"0");
        } else {
            dict.set((Object)"SECONDARY_MENU_HEIGHT", (Object)this.getDefaultMenuHeight());
        }
        dict.set((Object)"PRIMARY_ROW_CLASS", (Object)this.getPrimaryRowClass());
        dict.set((Object)"SECONDARY_ROW_CLASS", (Object)this.getSecondaryRowClass());
        if (null != primary && null == secondary && !"false".equals(request.getAttribute("USE_MENU_DIVIDER"))) {
            dict.set((Object)"MENU_DIVIDER", (Object)this.applyTemplate(dict, "menu_divider"));
        }
        return dict;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        try {
            this.createMenus(request, response);
            TabMenu primary = (TabMenu)request.getAttribute("com.sas.web.primary.menubar");
            SimpleMenuBar secondary = (SimpleMenuBar)request.getAttribute("com.sas.web.secondary.menubar");
            JspWriter out = this.pageContext.getOut();
            Dictionary dict = this.getTemplateDictionary(primary, secondary, request);
            String value = this.applyTemplate(dict, this.getTemplate());
            out.println(value);
        }
        catch (ThemeException te) {
            throw new JspException("MenuBarTag. " + te.getMessage(), (Throwable)te);
        }
        catch (IOException ioe) {
            throw new JspException("MenuBarTag. " + ioe.getMessage());
        }
        return 0;
    }

    private String getImageFromAction(Action action, HttpServletRequest request, boolean disabled) {
        String image = (String)action.getValue(THEME_IMAGE);
        if (null != image) {
            Theme theme = ThemeHelper.getTheme(request);
            Image imageObj = theme.getImage(image, true);
            image = imageObj.getFile();
        } else {
            if (disabled) {
                image = (String)action.getValue("SmallDisabledIconName");
            }
            if (null == image) {
                image = (String)action.getValue("SmallIconName");
            }
        }
        return image;
    }

    private void createMenus(HttpServletRequest request, HttpServletResponse response) throws ThemeException {
        Object secondaryObj;
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        String actionBundle = settings.getProperty("WebApp.Actions");
        Locale locale = this.getUserLocale();
        ResourceBundle rb = ResourceBundle.getBundle(actionBundle, locale);
        ActionResourceLoader map = new ActionResourceLoader(rb, (Object)this);
        Object primaryObj = request.getAttribute("com.sas.web.primary.menubar");
        if (null != primaryObj) {
            if (!(primaryObj instanceof String)) {
                throw new IllegalStateException("Menu key is not a string; application flow in error.");
            }
            String menuKey = (String)primaryObj;
            if ("".equals(menuKey.trim())) {
                request.setAttribute("com.sas.web.primary.menubar", null);
            } else {
                String mostRecentKey = "";
                ActionList actionList = map.getActionList(menuKey);
                TabMenu tabMenu = new TabMenu();
                tabMenu.setRequest(request);
                tabMenu.setResponse(response);
                tabMenu.setLook("Banner");
                if (null == this.menuId) {
                    tabMenu.setId(menuKey.replace('.', '_'));
                } else {
                    tabMenu.setId("primary_" + this.menuId);
                }
                for (Object nextObj : actionList.getActions()) {
                    if (!(nextObj instanceof Action)) {
                        throw new IllegalStateException("Primary menu only contains top level action objects.");
                    }
                    Action nextAction = (Action)nextObj;
                    String key = (String)nextAction.getValue("ActionCommandKey");
                    if (MenuHelper.getRemovedMenuList(request).contains(key) || key.equals(mostRecentKey)) continue;
                    mostRecentKey = key;
                    String label = (String)nextAction.getValue("Name");
                    String url = this.getURL(nextAction, request);
                    TabButton tab = new TabButton(label);
                    tab.setId(key.replace('.', '_'));
                    tab.setURL(url);
                    tab.setButtonType(4);
                    tabMenu.add(tab);
                    if (!this.isMenuSelected(key, request)) continue;
                    tabMenu.setActiveTab(tab);
                }
                request.setAttribute("com.sas.web.primary.menubar", (Object)tabMenu);
            }
        }
        if (null != (secondaryObj = request.getAttribute("com.sas.web.secondary.menubar"))) {
            if (!(secondaryObj instanceof String)) {
                throw new IllegalStateException("Menu key [com.sas.web.secondary.menubar] is not a String; application flow in error.");
            }
            String menuKey = (String)secondaryObj;
            if ("".equals(menuKey.trim())) {
                request.setAttribute("com.sas.web.secondary.menubar", null);
            } else {
                String mostRecentKey = "";
                ActionList actionList = map.getActionList(menuKey);
                SimpleMenuBar simpleMenuBar = new SimpleMenuBar();
                simpleMenuBar.setRequest(request);
                simpleMenuBar.setResponse(response);
                if (null == this.menuId) {
                    simpleMenuBar.setId(menuKey.replace('.', '_'));
                } else {
                    simpleMenuBar.setId("secondary_" + this.menuId);
                }
                ArrayList<MenuBarItem> menuModel = new ArrayList<MenuBarItem>();
                Iterator it = actionList.getActions().iterator();
                while (it.hasNext()) {
                    String key;
                    boolean disabled = false;
                    Object actionObj = it.next();
                    if (actionObj instanceof String) {
                        if ("-".equals(mostRecentKey)) continue;
                        mostRecentKey = "-";
                        MenuBarItem item = new MenuBarItem();
                        item.setSeparator(true);
                        menuModel.add(item);
                        continue;
                    }
                    if (actionObj instanceof ActionList) {
                        ActionList actions = (ActionList)actionObj;
                        key = (String)actions.getValue("ActionCommandKey");
                        if (MenuHelper.getRemovedMenuList(request).contains(key)) continue;
                        MenuBarItem item = new MenuBarItem();
                        String label = (String)actions.getValue("Name");
                        String image = this.getImageFromAction((Action)actions, request, disabled);
                        item.setText(label);
                        if (null != image) {
                            item.setImage(image);
                        }
                        ArrayList<PopupMenuItem> subItems = new ArrayList<PopupMenuItem>();
                        boolean lastWasSeparator = false;
                        for (Object o : actions.getActions()) {
                            if (o instanceof Action) {
                                Action action = (Action)o;
                                String actionKey = (String)action.getValue("ActionCommandKey");
                                if (MenuHelper.getRemovedMenuList(request).contains(actionKey)) continue;
                                String subLabel = (String)action.getValue("Name");
                                String subImage = this.getImageFromAction(action, request, disabled);
                                String url = this.getURL(action, request);
                                String confirmKey = (String)action.getValue("confirm.key");
                                PopupMenuItem subItem = new PopupMenuItem();
                                subItem.setText(subLabel);
                                if (null != image) {
                                    subItem.setImage(subImage);
                                }
                                if (StringUtils.isNotEmpty((CharSequence)confirmKey)) {
                                    StringBuilder javascript = new StringBuilder("javascript:");
                                    String confirmMessage = this.getTextFromResource(confirmKey);
                                    javascript.append("if (confirmAction('").append(confirmMessage).append("')) ");
                                    javascript.append("document.location='").append(url).append("';");
                                    subItem.setJavascript(javascript.toString());
                                } else {
                                    subItem.setUrl(url);
                                }
                                subItems.add(subItem);
                                lastWasSeparator = false;
                                continue;
                            }
                            if (!(o instanceof String) || lastWasSeparator || subItems.size() == 0) continue;
                            lastWasSeparator = true;
                            PopupMenuItem subItem = new PopupMenuItem();
                            subItem.setSeparator(true);
                            subItems.add(subItem);
                        }
                        int lastItemIndex = subItems.size() - 1;
                        PopupMenuItem lastItem = (PopupMenuItem)subItems.get(lastItemIndex);
                        if (lastItem.isSeparator()) {
                            subItems.remove(lastItemIndex);
                        }
                        item.setSubMenu(subItems);
                        menuModel.add(item);
                        continue;
                    }
                    Action action = (Action)actionObj;
                    key = (String)action.getValue("ActionCommandKey");
                    if (MenuHelper.getRemovedMenuList(request).contains(key) || key.equals(mostRecentKey)) continue;
                    mostRecentKey = key;
                    if (MenuHelper.getDisabledMenuList(request).contains(key)) {
                        disabled = true;
                    }
                    String label = (String)action.getValue("Name");
                    String image = this.getImageFromAction(action, request, disabled);
                    String url = this.getURL(action, request);
                    String menuPrefix = (String)action.getValue(MENU_PREFIX);
                    MenuBarItem item = new MenuBarItem();
                    if (menuPrefix == null && image == null || menuPrefix != null && menuPrefix.contains("text")) {
                        item.setText(label);
                    }
                    item.setAlternateText(label);
                    item.setTitle(label);
                    item.setDisabled(disabled);
                    item.setImage(image);
                    item.setUrl(url);
                    if (this.isMenuSelected(key, request)) {
                        item.setSelected(true);
                    }
                    menuModel.add(item);
                }
                simpleMenuBar.setModel(menuModel);
                request.setAttribute("com.sas.web.secondary.menubar", (Object)simpleMenuBar);
            }
        }
    }

    private String getURL(Action action, HttpServletRequest request) {
        Object actionCommand = action.getValue("command.notrans");
        String actionUrl = String.valueOf(actionCommand);
        String url = actionUrl.startsWith("javascript") ? actionUrl : (!this.isUseContext() ? actionUrl : request.getContextPath() + actionUrl);
        if (url.indexOf(37) > -1) {
            Dictionary dict = MenuHelper.getParameterDictionary(request);
            Template template = new Template((DictionaryInterface)dict);
            template.setTemplate(url);
            url = template.getText();
        }
        return url;
    }

    private boolean isMenuSelected(String key, HttpServletRequest request) {
        List list = MenuHelper.getSelectedMenuList(request);
        return list.contains(key);
    }
}

