/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.config.UrlGeneratorInterface;
import com.sas.framework.personalization.HelpSetting;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.PreferenceHelper;
import com.sas.framework.webapp.taglib.PopupMenuTag;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelpScriptTag
extends PopupMenuTag {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(HelpScriptTag.class);
    private static final String QUICKHELP = "HelpQuick";
    private static final String ABOUT_ACTION = "shell/about.jsp";
    public static final String SASDOC_SOFTWARE_COMPONENT = "SASDoc";
    public static final String HELP_POPUP_MENU = "sas.framework.help.popup.menu";
    public static final String HELPMENU = "HelpMenu";
    public static final String HELPMENU_QUICKHELP_ENABLED = "HelpMenuQuickHelp";
    public static final String HELPMENU_QUICKHELP_ON = "HelpMenuQuickHelpAlwaysOn";
    public static final String HELPMENU_QUICKHELP_DISABLED = "HelpMenuQuickHelpDisabled";
    public static final String HELPMENU_LOGGED_OFF = "HelpLoggedOffMenu";
    private String docset = null;
    private final String componentId = "sasHELP_MENU_ID";

    public HelpScriptTag() {
        super.setComponentId("sasHELP_MENU_ID");
    }

    @Override
    public void setComponentId(String componentId) {
        super.setComponentId(componentId);
    }

    public void setDocset(String ds) {
        this.docset = ds;
    }

    public String getDocset() {
        return this.docset;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        JspWriter writer = this.pageContext.getOut();
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        StringBuffer about = new StringBuffer();
        about.append(this.getContextPath());
        if (!this.getContextPath().endsWith("/")) {
            about.append("/");
        }
        about.append(ABOUT_ACTION);
        try {
            writer.println("<!-- About page -->");
            writer.println("<script type=\"text/javascript\">");
            writer.println("   function showAbout() {");
            writer.println("       openHelpDialog(\"" + about.toString() + "\");");
            writer.println("   }");
            writer.println("</script>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        String product = this.getDefinedDocSet(settings);
        String systemnav = this.getSystemDocSet(settings);
        if (null == product || null == systemnav) {
            return 0;
        }
        String contextPath = FrameworkHelper.getContextPath(request, true);
        String softwareVersion = FrameworkHelper.getApplicationConfiguration(request).getSoftwareVersion();
        String docLanguage = this.getDocLanguage(this.getUserLocale());
        try {
            StringBuffer contents = new StringBuffer();
            contents.append(contextPath);
            contents.append("Director?_directive=webdocmd_Contents");
            contents.append("&selectedProduct=").append(systemnav);
            contents.append("&macroVersion=").append(softwareVersion);
            contents.append("&selectedLocale=").append(docLanguage);
            contents.append("&selectedTopic=").append(product).append(".hlp%2Fabout.htm");
            writer.println("<!-- Help Contents -->");
            writer.println("<script type=\"text/javascript\">");
            writer.println("   function showHelpContents() {");
            writer.println("       openSASDocWindow(\"" + contents.toString() + "\");");
            writer.println("   }");
            writer.println("</script>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        List helpids = FrameworkHelper.getHelpIds(request);
        StringBuilder helppage = new StringBuilder();
        String help = null;
        String topic = (String)this.pageContext.getAttribute("sas.framework.taglib.HelpScriptTag.page", 2);
        help = null == topic || "".equals(topic) || "NONE".equalsIgnoreCase(topic) ? "" : topic;
        String requestProduct = this.getTopicDocSet();
        if (null != requestProduct) {
            product = requestProduct;
        }
        helppage.append(contextPath);
        helppage.append("Director?_directive=webdocmd_Show in Contents");
        helppage.append("&selectedProduct=").append(systemnav);
        helppage.append("&macroVersion=").append(softwareVersion);
        helppage.append("&selectedLocale=").append(docLanguage);
        helppage.append("&selectedTopic=").append(product).append(".hlp%2F").append(topic).append(".htm");
        boolean toggle = PreferenceHelper.isQuickHelpOn(request);
        try {
            writer.println("");
            writer.println("<!-- Topic Help Scripts -->");
            writer.println("<script type=\"text/javascript\">");
            if (null != helpids) {
                writer.println("   var isHelpOn=" + toggle + ";");
                writer.println("   function toggleHelp() {");
                if (!this.isAlwaysOn()) {
                    int i;
                    writer.println("      if (isHelpOn) {");
                    for (i = 0; i < helpids.size(); ++i) {
                        writer.println("         document.getElementById('" + (String)helpids.get(i) + "').style.display=\"none\";");
                    }
                    writer.println("         isHelpOn = false;");
                    writer.println("      }");
                    writer.println("      else {");
                    for (i = 0; i < helpids.size(); ++i) {
                        writer.println("         document.getElementById('" + (String)helpids.get(i) + "').style.display=\"block\";");
                    }
                    writer.println("         isHelpOn = true;");
                    writer.println("      }");
                } else {
                    writer.println("      showHelp();");
                }
                writer.println("   }");
                writer.println("");
            }
            writer.println("   function showHelp() {");
            writer.println("       openSASDocWindow(\"" + helppage.toString() + "\");");
            writer.println("   }");
            writer.println("</script>");
        }
        catch (IOException ioe) {
            throw new JspException("HelpScriptTag. " + ioe.getMessage(), (Throwable)ioe);
        }
        return 0;
    }

    protected boolean isAlwaysOn() {
        boolean alwaysOn = false;
        HelpSetting helpSetting = this.getPreferenceResolver().getHelpSetting();
        if (null != helpSetting) {
            alwaysOn = helpSetting.getKey().equals(HelpSetting.ALWAYS_ON.getKey());
        }
        return alwaysOn;
    }

    @Override
    public String getActionList() {
        boolean quickHelpOff;
        String menu = super.getActionList();
        if (null != menu && !"".equals(menu.trim())) {
            return menu;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String popmenu = (String)request.getAttribute(HELP_POPUP_MENU);
        Boolean quickHelpObj = (Boolean)request.getAttribute("sas.framework.webapp.quick.help.off");
        boolean bl = quickHelpOff = null == quickHelpObj ? false : quickHelpObj;
        if (quickHelpOff) {
            return HELPMENU_QUICKHELP_DISABLED;
        }
        if (null == popmenu) {
            return HELPMENU;
        }
        return popmenu;
    }

    @Override
    protected String getPopupMenuHTML() throws ThemeException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ResourceBundle rb = ResourceBundle.getBundle(FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Actions"), this.getUserLocale());
        ActionResourceLoader actionLoader = new ActionResourceLoader(rb, (Object)this);
        ActionList actionList = actionLoader.getActionList(this.getActionList());
        List list = actionList.getActions();
        if (null == list) {
            return "";
        }
        List helpids = FrameworkHelper.getHelpIds(request);
        if (null == helpids) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Action next;
                String key;
                Object o = it.next();
                if (!(o instanceof Action) || !QUICKHELP.equals(key = (String)(next = (Action)o).getValue("ActionCommandKey"))) continue;
                it.remove();
            }
        }
        return this.getPopupMenuHTML(list);
    }

    private String getSASDocURL() {
        StringBuilder url = new StringBuilder();
        String context = "";
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        UrlGeneratorInterface ugi = FrameworkHelper.getUrlGenerator(request);
        context = ugi.generateUrl(SASDOC_SOFTWARE_COMPONENT, null, "");
        url.append(context);
        if (!context.endsWith("/")) {
            url.append("/");
        }
        return url.toString();
    }

    private String getDefinedDocSet(Properties settings) {
        HttpServletRequest request;
        String applicationKey;
        String doc = settings.getProperty("WebApp.DocSet");
        if (null == doc && !"Logon Manager 9.4".equals(applicationKey = FrameworkHelper.getApplicationKey(request = (HttpServletRequest)this.pageContext.getRequest()))) {
            LOGGER.error("ERROR: There is no docset defined for the " + applicationKey + " application. Check the Application Configuration metadata.");
        }
        return doc;
    }

    private String getTopicDocSet() {
        String doc = (String)this.pageContext.getAttribute("sas.framework.topic.docset", 2);
        return doc;
    }

    private String getSystemDocSet(Properties settings) {
        HttpServletRequest request;
        String applicationKey;
        String doc = settings.getProperty("WebApp.SystemDocSet");
        if (null == doc && !"Logon Manager 9.4".equals(applicationKey = FrameworkHelper.getApplicationKey(request = (HttpServletRequest)this.pageContext.getRequest()))) {
            LOGGER.error("ERROR: There is no system docset defined for the " + applicationKey + " application. Check the Application Configuration metadata.");
        }
        return doc;
    }

    protected String getDocLanguage(Locale locale) {
        String language = locale.getLanguage();
        if (null == language) {
            return "en";
        }
        String country = locale.getCountry();
        if (country == null || country.trim().length() == 0) {
            return language;
        }
        return language + '_' + country;
    }
}

