/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.themes.client.Image;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.ImagePicker;
import com.sas.servlet.tbeans.models.Item;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomIconPickerTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(CustomIconPickerTag.class);
    private static final String DEFAULT_TEMPLATE = "custom_icon_picker";
    private String directories;
    private String name;
    private String defaultIcon;
    private String iconImage = "icon_image";
    private String base = "/images/";
    private List directoryList;

    public CustomIconPickerTag() {
        this.setTemplate(DEFAULT_TEMPLATE);
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ImagePicker picker = new ImagePicker();
        picker.setLocale(this.getUserLocale());
        picker.setRequest(request);
        List model = this.getModel();
        picker.setModel(model);
        StyleInfo colorPreviewCell = new StyleInfo("pickedIconCell");
        picker.getStyleMap().put("PALETTE_PREVIEW_CELL", colorPreviewCell);
        StyleInfo container = new StyleInfo("");
        picker.getStyleMap().put("PALETTE_CONTAINER", container);
        Image img = ThemeHelper.getImageFile(this.getTheme(), this.iconImage);
        String image = img.getFile();
        picker.setLaunchImage(image.substring(image.lastIndexOf("/") + 1));
        picker.setDefaultValue(this.getDefaultImage());
        if (null != this.name && this.name.trim().length() != 0) {
            picker.setId(this.name);
        }
        try {
            picker.write((Writer)out);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private List getModel() throws JspException {
        ArrayList l = new ArrayList();
        for (String next : this.getDirectoryList()) {
            l.addAll(this.readTokens(next));
        }
        ArrayList<Item> model = new ArrayList<Item>();
        for (String next : l) {
            Item i = new Item(next, next);
            model.add(i);
        }
        if (null == this.getDefaultIcon()) {
            this.setDefaultIcon((String)l.get(0));
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List readTokens(String nextToken) throws JspException {
        ArrayList l;
        block18: {
            String next = nextToken;
            l = new ArrayList();
            ServletContext context = this.pageContext.getServletContext();
            String baseDirectory = this.getBase();
            if ("<base>".equals(next)) {
                next = "";
                baseDirectory = baseDirectory.substring(0, baseDirectory.length() - 1);
            }
            InputStream is = null;
            try {
                is = context.getResourceAsStream(baseDirectory + next + "/icons.config");
                if (null == is) break block18;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StreamTokenizer tokens = new StreamTokenizer(reader);
                tokens.wordChars(32, 126);
                ArrayList<String> list = new ArrayList<String>();
                String imageBaseDirectory = baseDirectory;
                if (imageBaseDirectory.startsWith("/")) {
                    imageBaseDirectory = imageBaseDirectory.substring(1);
                }
                try {
                    int type;
                    block13: while ((type = tokens.nextToken()) != -1) {
                        switch (type) {
                            case -3: {
                                list.add(imageBaseDirectory + next + "/" + tokens.sval);
                                continue block13;
                            }
                            case -2: {
                                LOGGER.error("Unable to parse numerical images");
                                continue block13;
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new JspException((Throwable)ioe);
                }
                if (list.size() > 0) {
                    l.addAll(list);
                }
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    LOGGER.warn("Unable to close file handle for CustomIconPicker.");
                }
            }
        }
        return l;
    }

    public String getBase() {
        return this.base.endsWith("/") ? this.base : this.base + "/";
    }

    public void setBase(String b) {
        this.base = b;
        if (!this.base.startsWith("/")) {
            this.base = "/" + this.base;
        }
    }

    public String getDirectories() {
        return this.directories;
    }

    public void setDirectories(String dir) {
        this.directoryList = new ArrayList();
        this.directories = dir;
        String[] dirs = this.directories.split(",");
        this.directoryList = Arrays.asList(dirs);
    }

    public List getDirectoryList() {
        return this.directoryList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getIconImage() {
        return this.iconImage;
    }

    public void setIconImage(String image) {
        this.iconImage = image;
    }

    public String getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(String d) {
        this.defaultIcon = d;
    }

    public String getDefaultImage() {
        return this.getDefaultIcon();
    }
}

