/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseIconSupport
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(BaseIconSupport.class);
    protected static final String IMAGE = ".image";
    protected static final String LABEL = ".label.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getLocalProperties(HttpServletRequest request) throws ThemeException {
        Locale locale = this.getUserLocale();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String imagePath = ThemeHelper.getThemePath("IMAGE", true, request);
        String properties = "icons.properties";
        String propertiesLanguage = "icons_" + language + ".properties";
        String propertiesExplicit = "icons_" + language + "_" + country + ".properties";
        String[] propertiesArray = new String[]{propertiesExplicit, propertiesLanguage, "icons.properties"};
        Properties props = new Properties();
        for (int i = 0; i < propertiesArray.length; ++i) {
            String urlPath = imagePath + propertiesArray[i];
            InputStream stream = null;
            try {
                URL url = new URL(urlPath);
                stream = url.openStream();
                props.load(stream);
                break;
            }
            catch (MalformedURLException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Unable to find icon properties " + propertiesArray[i] + " resorting to more generic properties.");
                continue;
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Unable to find icon properties " + propertiesArray[i] + " resorting to more generic properties.");
                continue;
            }
            finally {
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return props;
    }
}

