/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.util.VersionInfo;
import com.sas.framework.legal.SASLegalNotices;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseTextSupport;
import com.sas.framework.webapp.util.Acknowledgement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AboutTag
extends BaseTextSupport {
    private static final long serialVersionUID = 1L;
    private static final String NONE = "none";
    private static final String COPYRIGHT_STARTS = "2011";
    private static final Logger LOGGER = LogManager.getLogger(AboutTag.class);

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        try {
            Locale locale = FrameworkHelper.getUserLocale(request);
            request.setAttribute("com.sas.web.title", (Object)RB.getString("AboutTag.pageTitle.txt", locale));
            String product = this.getApplicationDisplayName();
            if (null == product || "".equals(product.trim())) {
                product = RB.getString("AboutTag.default.product.name.txt", locale);
            }
            request.setAttribute("sas.framework.product.name", (Object)product);
            VersionInfo versionInfo = this.getVersionInfo(request);
            if (null != versionInfo) {
                request.setAttribute("sas.framework.AppVersion", (Object)(versionInfo.getBuildVersion() + " ( " + versionInfo.getImplementationVersion() + " )"));
                request.setAttribute("sas.framework.AppBuildDate", (Object)versionInfo.getBuildDateString(locale));
            }
            Acknowledgement apache = new Acknowledgement(SASLegalNotices.getAcknowledgement((String)"SASLegalNotices.Acknowledgement.Apache.txt", (Locale)locale, (boolean)true));
            apache.setUrl("http://www.apache.org/licenses");
            apache.setUrlLabel("LICENSE");
            this.addAcknowledgement(apache, request);
            this.addAcknowledgements(request);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new JspException("AboutTag: " + t.getMessage());
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        JspWriter writer = this.pageContext.getOut();
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        try {
            String title = (String)this.pageContext.getAttribute("sas.framework.product.name", 2);
            String version = (String)this.pageContext.getAttribute("sas.framework.AppVersion", 2);
            String buildDate = (String)this.pageContext.getAttribute("sas.framework.AppBuildDate", 2);
            writer.println("<!-- Product title, version, and build date information -->");
            writer.println("<table width=\"100%\">");
            writer.println("<tr>");
            writer.println("<td>");
            writer.println("<span class=\"commonHeading\">" + title + "</span>");
            if (null != version && !"".equals(version.trim())) {
                writer.println("<br/>" + this.getTextFromResource("AboutTag.version.txt") + " " + version);
            }
            if (null != buildDate && !"".equals(buildDate.trim())) {
                writer.println("<br/>" + this.getTextFromResource("AboutTag.buildDate.txt") + " " + buildDate);
            }
            writer.println("</p>");
            writer.println("</td>");
            writer.println("</tr>");
            writer.println("</table>");
            writer.println("<span class=\"commonSubheading\">" + this.getTextFromResource("AboutTag.legal.notices.txt") + "</span>");
            writer.println("<fieldset>");
            writer.print("<legend><b>");
            writer.print(this.getTextFromResource("AboutTag.copyright.info.txt"));
            writer.println("</b></legend>");
            writer.print("<p align=\"center\"><span class=\"solutionsSmallHelpItem\">");
            writer.print(this.getLegalNotice(settings));
            writer.println("</span></p>");
            writer.println("</fieldset>");
            writer.println("");
            List acknowledgements = (List)request.getAttribute("com.sas.framework.webapp.util.ACKNOWLEDGEMENTS");
            if (null != acknowledgements) {
                writer.println("<!-- Legal Acknowledgements Contents -->");
                writer.println("<p>");
                writer.println("<fieldset>");
                writer.print("<legend><b>");
                writer.print(this.getTextFromResource("AboutTag.acknowledgements.txt"));
                writer.println("</b></legend>");
                for (Acknowledgement ack : acknowledgements) {
                    writer.print("<p><span class=\"solutionsSmallHelpItem\">");
                    writer.print(ack.getText());
                    writer.print("</span>");
                    String url = ack.getUrl();
                    if (null != url) {
                        writer.print("&nbsp;<a href=\"" + url + "\">&raquo;");
                        String label = ack.getUrlLabel();
                        if (null != label) {
                            writer.print(label);
                        }
                        writer.print("</a>");
                    }
                    writer.println("</p>");
                }
                writer.println("</fieldset>");
                writer.println("</p>");
                writer.println("<p>&nbsp;</p>");
                writer.println("");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 6;
    }

    private VersionInfo getVersionInfo(HttpServletRequest request) {
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        String versionClassName = settings.getProperty("Version.Class");
        if (null != versionClassName) {
            try {
                return VersionInfo.getVersionInfo((String)versionClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unable to locate the version class " + versionClassName + "specified in the application configuration for " + FrameworkHelper.getApplicationKey(request) + ".");
                }
                return null;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No version class specified in the application configuration for " + FrameworkHelper.getApplicationKey(request) + ".");
        }
        return null;
    }

    protected void addAcknowledgement(Acknowledgement ack, HttpServletRequest request) {
        ArrayList<Acknowledgement> acknowledgements = (ArrayList<Acknowledgement>)request.getAttribute("com.sas.framework.webapp.util.ACKNOWLEDGEMENTS");
        if (null == acknowledgements) {
            acknowledgements = new ArrayList<Acknowledgement>();
            request.setAttribute("com.sas.framework.webapp.util.ACKNOWLEDGEMENTS", acknowledgements);
        }
        acknowledgements.add(ack);
    }

    protected void addAcknowledgements(HttpServletRequest request) {
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        String ack = settings.getProperty("application-acknowledgements");
        if (null == ack || "".equals(ack)) {
            return;
        }
        String[] acks = ack.split(",");
        String license = settings.getProperty("application-acknowledgement-licenses");
        String[] licenses = license.split(",");
        boolean showLicenses = true;
        if (licenses.length < acks.length) {
            LOGGER.error("Incomplete list of legal acknowledgements defined in web.xml; check the application-acknowledgement-licenses context parameter.");
            showLicenses = false;
        }
        for (int idx = 0; idx < acks.length; ++idx) {
            Acknowledgement a = new Acknowledgement(this.getTextFromResource(acks[idx]));
            String url = licenses[idx];
            if (showLicenses && !url.equalsIgnoreCase(NONE)) {
                a.setUrl(url);
                a.setUrlLabel("LICENSE");
            }
            this.addAcknowledgement(a, request);
        }
    }

    protected String getLegalNotice(Properties settings) {
        String start = settings.getProperty("application-copyright-from");
        if (null == start || "".equals(start.trim())) {
            start = COPYRIGHT_STARTS;
        } else {
            try {
                Integer.parseInt(start);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Incorrect year value in application-copyright-from context parameter: " + start);
                start = COPYRIGHT_STARTS;
            }
        }
        String end = settings.getProperty("application-copyright-to");
        if (null == end || "".equals(end.trim())) {
            end = null;
        } else {
            try {
                Integer.parseInt(end);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Incorrect year value in application-copyright-to context parameter: " + end);
                end = null;
            }
        }
        return SASLegalNotices.getLegalStatement((String)start, (String)end, null, (boolean)true);
    }
}

