/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet.sanitizers;

import com.sas.framework.commons.util.Sanitizer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultCrossSiteScriptingSanitizer
implements Sanitizer {
    private static final Logger LOGGER = LogManager.getLogger(DefaultCrossSiteScriptingSanitizer.class);
    private String expression = "((%3C)|<)[^\n]+((%3E)|>)";
    private Pattern expressionPattern = Pattern.compile(this.expression);

    public void setExpression(String expression) {
        this.expression = expression;
        this.expressionPattern = Pattern.compile(expression);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Using expression '" + expression + "' to validate strings.");
        }
    }

    public boolean matches(String value) {
        if (null == value) {
            return false;
        }
        return this.expressionPattern.matcher(value).find();
    }

    public String sanitize(String name, String value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing name, '" + name + "', and value '" + value + "'.");
        }
        if (null == value) {
            return null;
        }
        String retval = value;
        if (this.matches(value)) {
            retval = StringEscapeUtils.escapeHtml4((String)value);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sanitized value is now '" + retval + "'.");
            }
        }
        return retval;
    }
}

