/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.commons.resolvers.UserResolverInterface;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.util.WebKey;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionAttributeListener
implements HttpSessionAttributeListener {
    private Logger logger;

    public void attributeAdded(HttpSessionBindingEvent event) {
        String value = " added " + this.getEventValue(event) + " to session under " + this.getEventName(event) + " in application " + this.getWebappContext(event);
        this.log(event, value);
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        String value = " removed " + this.getEventValue(event) + " from session under " + this.getEventName(event) + " in application " + this.getWebappContext(event);
        this.log(event, value);
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        String value = " replaced " + this.getEventValue(event) + " on session under " + this.getEventName(event) + " in application " + this.getWebappContext(event);
        this.log(event, value);
    }

    private String getEventName(HttpSessionBindingEvent event) {
        return event.getName();
    }

    private String getEventValue(HttpSessionBindingEvent event) {
        return event.getValue().getClass().getName();
    }

    private void log(HttpSessionBindingEvent event, String theValue) {
        if (null == this.logger) {
            this.logger = LogManager.getLogger((String)(this.getClass().getName() + "." + this.getWebappContext(event)));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.getUserName(event) + " : " + theValue);
        }
    }

    private String getWebappContext(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        ServletContext context = session.getServletContext();
        String contextName = null;
        if (null != context) {
            contextName = context.getServletContextName();
        }
        if (null == contextName) {
            contextName = "UNKNOWN";
        }
        return WebKey.deblank(contextName);
    }

    private String getUserName(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        ServletContext context = session.getServletContext();
        UserResolverInterface uri = FrameworkHelper.getUserResolver(context);
        String name = uri.getUserName();
        if (null == name) {
            name = "UNKNOWN";
        }
        return name;
    }
}

