/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;

public abstract class OncePerRequestFilter
implements Filter,
BeanNameAware {
    private static final String ALREADY_PROCESSED = ".FILTERED";
    private static final String IGNORED_TYPES = "ignored.types";
    private FilterConfig config;
    private String beanName;
    TreeSet<String> ignoredTypes = new TreeSet();
    private static final Logger LOGGER = LogManager.getLogger(OncePerRequestFilter.class);

    public void init(FilterConfig c) throws ServletException {
        this.config = c;
        String types = this.config.getInitParameter(IGNORED_TYPES);
        this.setIgnoredTypes(types);
    }

    private void setIgnoredTypes(String types) {
        if (null != types) {
            StringTokenizer token = new StringTokenizer(types.trim(), ";");
            while (token.hasMoreTokens()) {
                this.ignoredTypes.add(token.nextToken());
            }
        }
        if (this.ignoredTypes.isEmpty() && LOGGER.isInfoEnabled()) {
            LOGGER.info("The application's web.xml file does not contain an <init-param> named 'ignored.types'; filter processing will occur on all content.");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String attributeName = this.getAlreadyFilteredAttributeName();
        if (null != req.getAttribute(attributeName) || this.shouldNotFilter(req)) {
            chain.doFilter(req, resp);
        } else {
            req.setAttribute(attributeName, (Object)Boolean.TRUE);
            this.onDoFilter(req, resp, chain);
        }
    }

    protected String getAlreadyFilteredAttributeName() {
        String name = this.getFilterName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ALREADY_PROCESSED;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected abstract void onDoFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException;

    protected String getFilterName() {
        return null != this.config ? this.config.getFilterName() : this.beanName;
    }

    protected boolean shouldNotFilter(ServletRequest request) {
        String uri = ((HttpServletRequest)request).getRequestURI();
        if (this.shouldNotFilterNeedsPeriod(uri)) {
            return true;
        }
        return this.shouldNotFilterNeedsSlash(uri);
    }

    private boolean shouldNotFilterNeedsPeriod(String uri) {
        int idx = uri.lastIndexOf(46);
        if (idx <= 0) {
            return false;
        }
        String suffix = uri.substring(idx);
        return this.ignoredTypes.contains(suffix);
    }

    private boolean shouldNotFilterNeedsSlash(String uri) {
        int idx = uri.lastIndexOf(47);
        if (idx <= 0) {
            return false;
        }
        String suffix = uri.substring(idx);
        return this.ignoredTypes.contains(suffix);
    }

    public void destroy() {
        this.config = null;
    }
}

