/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.commons.resolvers.LocaleResolverInterface;
import com.sas.framework.commons.resolvers.PreferenceResolverInterface;
import com.sas.framework.commons.resolvers.UserResolverInterface;
import com.sas.framework.webapp.resolvers.BasicLocaleResolver;
import com.sas.framework.webapp.resolvers.BasicPreferenceResolver;
import com.sas.framework.webapp.resolvers.BasicUserResolver;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrameworkContextListener
implements ServletContextListener {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String applicationName = context.getInitParameter("application-name");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroying " + applicationName);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String applicationName = context.getInitParameter("application-name");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing " + applicationName);
        }
        this.loadResolvers(context);
    }

    protected void loadResolvers(ServletContext context) {
        context.setAttribute("sas_locale_resolver", (Object)this.getLocaleResolver(context));
        context.setAttribute("sas_preference_resolver", (Object)this.getPreferenceResolver(context));
        context.setAttribute("sas_user_resolver", (Object)this.getUserResolver(context));
    }

    public LocaleResolverInterface getLocaleResolver(ServletContext context) {
        return new BasicLocaleResolver();
    }

    public PreferenceResolverInterface getPreferenceResolver(ServletContext context) {
        return new BasicPreferenceResolver();
    }

    public UserResolverInterface getUserResolver(ServletContext context) {
        return new BasicUserResolver();
    }
}

