/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressionFilter
implements Filter {
    static final Logger LOGGER = LogManager.getLogger(CompressionFilter.class);

    public void destroy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Destroying CompressionFilter...");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initializing CompressionFilter...");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String ae = request.getHeader("accept-encoding");
            if (null != ae && ae.indexOf("gzip") != -1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("GZIP supported, compressing..." + request.getRequestURI());
                }
                CompressionResponseWrapper wrappedResponse = new CompressionResponseWrapper(response);
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("GZIP *not* supported, *not* compressing..." + request.getRequestURI());
            }
        }
        chain.doFilter(req, res);
    }

    private class CompressionResponseStream
    extends ServletOutputStream {
        protected ByteArrayOutputStream baos;
        protected GZIPOutputStream gzos;
        protected boolean closed = false;
        protected HttpServletResponse response;
        protected ServletOutputStream output;

        public CompressionResponseStream(HttpServletResponse response) throws IOException {
            this.response = response;
            this.output = response.getOutputStream();
            this.baos = new ByteArrayOutputStream();
            this.gzos = new GZIPOutputStream(this.baos);
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("This output stream has already been closed");
            }
            this.gzos.finish();
            byte[] abyte0 = this.baos.toByteArray();
            this.response.addHeader("Content-Length", Integer.toString(abyte0.length));
            this.response.addHeader("Content-Encoding", "gzip");
            this.output.write(abyte0);
            this.output.flush();
            this.output.close();
            this.closed = true;
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush a closed output stream");
            }
            this.gzos.flush();
        }

        public void write(int i) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed output stream");
            }
            this.gzos.write((byte)i);
        }

        public void write(byte[] abyte0) throws IOException {
            this.write(abyte0, 0, abyte0.length);
        }

        public void write(byte[] abyte0, int i, int j) throws IOException {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Writing...");
            }
            if (this.closed) {
                throw new IOException("Cannot write to a closed output stream");
            }
            this.gzos.write(abyte0, i, j);
        }

        public boolean closed() {
            return this.closed;
        }

        public void reset() {
        }
    }

    private class CompressionResponseWrapper
    extends HttpServletResponseWrapper {
        protected HttpServletResponse response;
        protected ServletOutputStream stream;
        protected PrintWriter writer;

        public CompressionResponseWrapper(HttpServletResponse response) {
            super(response);
            this.response = response;
        }

        public ServletOutputStream createOutputStream() throws IOException {
            return new CompressionResponseStream(this.response);
        }

        public void finishResponse() {
            try {
                if (null != this.writer) {
                    this.writer.close();
                } else if (null != this.stream) {
                    this.stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }

        public void flushBuffer() throws IOException {
            this.stream.flush();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (null != this.writer) {
                throw new IllegalStateException("getWriter() has already been called!");
            }
            if (null == this.stream) {
                this.stream = this.createOutputStream();
            }
            return this.stream;
        }

        public PrintWriter getWriter() throws IOException {
            if (null != this.writer) {
                return this.writer;
            }
            if (null != this.stream) {
                throw new IllegalStateException("getOutputStream() has already been called!");
            }
            this.stream = this.createOutputStream();
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, "UTF-8"));
            return this.writer;
        }

        public void setContentLength(int i) {
        }
    }
}

