/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.webapp.util.WebKey;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationAttributeListener
implements ServletContextAttributeListener {
    private Logger logger;

    public void attributeAdded(ServletContextAttributeEvent event) {
        String name = this.getEventName(event);
        String value = this.getEventValue(event);
        String context = this.getWebappContext(event);
        String msg = " added " + value + " to context under " + name + " in application " + context;
        this.log(event, msg);
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        String name = this.getEventName(event);
        String value = this.getEventValue(event);
        String context = this.getWebappContext(event);
        String msg = " removed " + value + " from context under " + name + " in application " + context;
        this.log(event, msg);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        String name = this.getEventName(event);
        String value = this.getEventValue(event);
        String context = this.getWebappContext(event);
        String msg = " replaced " + value + " on context under " + name + " in application " + context;
        this.log(event, msg);
    }

    private String getEventName(ServletContextAttributeEvent event) {
        return event.getName();
    }

    private String getEventValue(ServletContextAttributeEvent event) {
        return event.getValue().getClass().getName();
    }

    private void log(ServletContextAttributeEvent event, String value) {
        if (null == this.logger) {
            this.logger = LogManager.getLogger((String)(this.getClass().getName() + "." + this.getWebappContext(event)));
        }
        this.logger.info(value);
    }

    private String getWebappContext(ServletContextAttributeEvent event) {
        ServletContext context = event.getServletContext();
        String contextName = null;
        if (null != context) {
            contextName = context.getServletContextName();
        }
        if (null == contextName) {
            contextName = "UNKNOWN";
        }
        return WebKey.deblank(contextName);
    }
}

