/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.helpers;

import com.sas.framework.commons.resolvers.PreferenceResolverInterface;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.themes.client.ThemeServiceInterface;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.UserHelper;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThemeHelper {
    private static final Logger LOGGER = LogManager.getLogger(ThemeHelper.class);
    private static ThemeServiceInterface themeService;

    public static void setThemeService(ThemeServiceInterface t) {
        themeService = t;
    }

    private ThemeHelper() {
    }

    public static Theme getTheme(HttpServletRequest request) throws ThemeException {
        Theme theme = (Theme)request.getAttribute("sas.framework.themeobject");
        if (null != theme) {
            return theme;
        }
        if (null == themeService) {
            throw new ThemeException("Theme Service is unavailable or cannot be found.");
        }
        String thisTheme = ThemeHelper.getThemeName(request);
        theme = themeService.getTheme(thisTheme);
        if (null == theme) {
            theme = themeService.getTheme("default");
        }
        return theme;
    }

    public static String getThemeName(HttpServletRequest request) {
        String theme = (String)request.getAttribute("sas.framework.Theme");
        if (null != theme) {
            return theme;
        }
        PreferenceResolverInterface pri = FrameworkHelper.getPreferenceResolver(request);
        theme = pri.getStringPreference("Default.Theme");
        if (null == theme) {
            LOGGER.warn("Unable to retrieve theme preference for user '" + UserHelper.getUserId(request) + "'.");
            theme = "default";
        }
        request.setAttribute("sas.framework.Theme", (Object)theme);
        return theme;
    }

    public static String getImageFromTheme(HttpServletRequest request, Theme theme, String imageName) throws ThemeException {
        return ThemeHelper.getImageFromTheme(request, theme, imageName, null);
    }

    public static String getImageFromTheme(HttpServletRequest request, Theme theme, String imageName, String imageDivID) throws ThemeException {
        return ThemeHelper.getImageFromTheme(request, theme, imageName, imageDivID, null);
    }

    public static String getImageFromTheme(HttpServletRequest request, Theme theme, String imageName, String imageDivID, String onClick) throws ThemeException {
        return ThemeHelper.getImageFromTheme(request, theme, imageName, imageDivID, onClick, null);
    }

    public static String getImageFromTheme(HttpServletRequest request, Theme theme, String imageName, String imageDivID, String onClick, String resourceBundle) throws ThemeException {
        Image image = ThemeHelper.getImageFile(theme, imageName);
        StringBuffer img = new StringBuffer();
        img.append("<img src=\"").append(image.getFile()).append("\" border=\"0\"");
        String str = image.getAltTextKey();
        if (null != str) {
            if (null != resourceBundle) {
                Locale loc = FrameworkHelper.getUserLocale(request);
                ResourceBundle bundle = ResourceBundle.getBundle(resourceBundle, loc);
                str = bundle.getString(str);
            }
            img.append(" alt=\"").append(str).append("\"");
        }
        if (null != (str = image.getDescription())) {
            img.append(" title=\"").append(str).append("\"");
        }
        if (null != (str = image.getHeight())) {
            img.append(" height=\"").append(str).append("\"");
        }
        if (null != (str = image.getWidth())) {
            img.append(" width=\"").append(str).append("\"");
        }
        if (null != imageDivID) {
            img.append(" id=\"").append(imageDivID).append("\"");
        }
        if (null != onClick) {
            img.append(" onClick=\"").append(onClick).append("\"");
        }
        img.append(">");
        return img.toString();
    }

    public static Image getImageFile(Theme theme, String imageName) throws ThemeException {
        if (null == imageName) {
            throw new IllegalArgumentException("Cannot retrieve image name 'null'.");
        }
        Image image = theme.getImage(imageName);
        if (null == image) {
            throw new ThemeException("Cannot locate image: " + imageName + " for theme: " + theme.getName());
        }
        return image;
    }

    public static String getImagePath(Theme theme, String imageName) throws ThemeException {
        Image image = ThemeHelper.getImageFile(theme, imageName);
        return image.getFile();
    }

    public static String getThemePath(String elementType, HttpServletRequest request) throws ThemeException {
        String element = "com.sas.framework.themes." + elementType;
        String path = (String)request.getAttribute(element);
        if (null == path) {
            path = ThemeHelper.getThemePath(elementType, false, request);
            request.setAttribute(element, (Object)path);
        }
        return path;
    }

    public static String getThemePath(String elementType, boolean trailingSeparator, HttpServletRequest request) throws ThemeException {
        Theme theme = ThemeHelper.getTheme(request);
        StringBuilder sb = new StringBuilder();
        String uriPath = theme.getURIPath();
        if (uriPath.length() <= 5 || !uriPath.substring(0, 5).equalsIgnoreCase("http:") && !uriPath.substring(0, 6).equalsIgnoreCase("https:")) {
            sb.append(request.getContextPath()).append("/");
        }
        sb.append(uriPath).append("/").append(theme.getDirectory(elementType));
        String lastChar = sb.substring(sb.length() - 1);
        if (trailingSeparator && !"/".equals(lastChar)) {
            sb.append("/");
        }
        if (!trailingSeparator && "/".equals(lastChar)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getThemeImageFile(HttpServletRequest request, String imageName) throws ThemeException {
        if (null == imageName) {
            throw new ThemeException("Cannot retrieve image name 'null'.");
        }
        Theme theme = ThemeHelper.getTheme(request);
        Image image = theme.getImage(imageName);
        if (null == image) {
            throw new ThemeException("Cannot locate image: " + imageName);
        }
        return image.getFile();
    }
}

