/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.helpers;

import com.sas.collection.Dictionary;
import com.sas.framework.webapp.helpers.NavigationHelper;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class MenuHelper {
    public static final String REMOVED_MENU_LIST = "removedmenulist";
    public static final String DISABLED_MENU_LIST = "disabledmenulist";
    public static final String SELECTED_MENU_LIST = "selectedmenulist";

    private MenuHelper() {
    }

    public static void setMenus(String primary, String secondary, HttpServletRequest request) {
        request.setAttribute("com.sas.web.primary.menubar", (Object)primary);
        request.setAttribute("com.sas.web.secondary.menubar", (Object)secondary);
    }

    public static void setSelectedMenus(String primary, String secondary, HttpServletRequest request) {
        MenuHelper.addSelectedMenu(primary, request);
        MenuHelper.addSelectedMenu(secondary, request);
    }

    public static void addSelectedMenu(String menu, HttpServletRequest request) {
        List list = MenuHelper.getSelectedMenuList(request);
        if (null != menu && !list.contains(menu)) {
            list.add(menu);
        }
    }

    public static List getSelectedMenuList(HttpServletRequest request) {
        return MenuHelper.getRequestBasedList(SELECTED_MENU_LIST, request);
    }

    public static void setReturnToMenu(String returnAction, HttpServletRequest request) {
        if (null != returnAction) {
            NavigationHelper.addBackToLink(request, returnAction, null, true);
        }
    }

    public static void clearMenuDivider(HttpServletRequest request) {
        request.setAttribute("USE_MENU_DIVIDER", (Object)"false");
    }

    public static Dictionary getParameterDictionary(HttpServletRequest request) {
        Dictionary dict = (Dictionary)request.getAttribute("com.sas.web.menu.dictionary");
        if (null == dict) {
            dict = new Dictionary();
            request.setAttribute("com.sas.web.menu.dictionary", (Object)dict);
        }
        return dict;
    }

    public static void addMenuParameter(String key, String value, HttpServletRequest request) {
        Dictionary dict = MenuHelper.getParameterDictionary(request);
        if (null != key && null != value && !dict.containsKey((Object)key)) {
            dict.set((Object)key, (Object)value);
        }
    }

    public static List getDisabledMenuList(HttpServletRequest request) {
        return MenuHelper.getRequestBasedList(DISABLED_MENU_LIST, request);
    }

    public static void addDisabledMenu(String key, HttpServletRequest request) {
        List list = MenuHelper.getDisabledMenuList(request);
        if (null != key) {
            list.add(key);
        }
    }

    public static List getRemovedMenuList(HttpServletRequest request) {
        return MenuHelper.getRequestBasedList(REMOVED_MENU_LIST, request);
    }

    public static void removeMenu(String key, HttpServletRequest request) {
        List list = MenuHelper.getRemovedMenuList(request);
        if (null != key) {
            list.add(key);
        }
    }

    public static void disableMenus(HttpServletRequest request) {
        request.setAttribute("sas_solutions_preferences_menu", (Object)"DISABLED");
        request.setAttribute("sas_solutions_return_to_menu", (Object)"DISABLED");
        request.setAttribute("sas_solutions_logoff_menu", (Object)"DISABLED");
        request.setAttribute("sas_solutions_return_to_app_menu", (Object)"DISABLED");
    }

    private static List getRequestBasedList(String name, HttpServletRequest request) {
        ArrayList l = (ArrayList)request.getAttribute(name);
        if (null == l) {
            l = new ArrayList();
            request.setAttribute(name, l);
        }
        return l;
    }
}

