/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class VectorParser
extends ChartParser {
    SILKElementInfoReader vectorInfo = null;

    public VectorParser() {
        this(null);
    }

    public VectorParser(PropertyInterface vec) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/vector.config";
        this.vectorInfo = new SILKElementInfoReader(configFile);
        this.vectorInfo.setInstance(vec);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement(context, element, this.vectorInfo);
        if (element != null) {
            if (element.hasAttribute("xOrigin")) {
                double x = Double.NaN;
                try {
                    x = Double.parseDouble(element.getAttribute("xOrigin"));
                }
                catch (Exception e) {
                    x = Double.NaN;
                }
                if (!Double.isNaN(x)) {
                    ((PropertyInterface)this.vectorInfo.getXmlTarget()).setPropertyValue(18702, (Object)new Double(x));
                    ((PropertyInterface)this.vectorInfo.getXmlTarget()).applyPropertyChanges();
                } else {
                    ((RoleInterface)this.vectorInfo.getXmlTarget()).setRole(ParserUtils.getVariableID((String)element.getAttribute("xOrigin")), RoleInterface.ROLE_VECTOR_X_FROM);
                }
            }
            if (element.hasAttribute("yOrigin")) {
                double y = Double.NaN;
                try {
                    y = Double.parseDouble(element.getAttribute("yOrigin"));
                }
                catch (Exception e) {
                    y = Double.NaN;
                }
                if (!Double.isNaN(y)) {
                    ((PropertyInterface)this.vectorInfo.getXmlTarget()).setPropertyValue(18703, (Object)new Double(y));
                    ((PropertyInterface)this.vectorInfo.getXmlTarget()).applyPropertyChanges();
                } else {
                    ((RoleInterface)this.vectorInfo.getXmlTarget()).setRole(ParserUtils.getVariableID((String)element.getAttribute("yOrigin")), RoleInterface.ROLE_VECTOR_Y_FROM);
                }
            }
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.toXML(this.getTagName(), context, object, this.vectorInfo);
        if (object instanceof PropertyInterface) {
            PropertyInterface prop = (PropertyInterface)object;
            if (prop.hasUserSetValue(18702)) {
                rc.setAttribute("xOrigin", prop.getPropertyValue(18702).toString());
            }
            if (prop.hasUserSetValue(18703)) {
                rc.setAttribute("yOrigin", prop.getPropertyValue(18703).toString());
            }
        }
        return rc;
    }

    @Override
    public String getTagName() {
        return "VectorPlot";
    }

    @Override
    public Object getObject() {
        return this.vectorInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.vectorInfo != null) {
            this.vectorInfo.setInstance(instance);
        }
        return true;
    }
}

