/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.xml.parsers.ElementInfoReader;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoInterface;
import com.sas.graphics.util.GraphUtilities;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Properties;

public class SILKElementInfoReader
extends ElementInfoReader
implements SILKElementInfoInterface {
    Role[] roleList = null;
    String[] roleNames = null;

    public SILKElementInfoReader(String propertiesFile) {
        super(propertiesFile);
    }

    private boolean loadRoles() {
        if (this.roleList != null) {
            return true;
        }
        if (this.props == null) {
            return false;
        }
        this.roleList = this.loadRoleList(this.props);
        if (this.roleList == null) {
            return false;
        }
        int num = 0;
        for (int i = 0; i < this.roleList.length; ++i) {
            num += this.roleList[i].xmlNames.length;
        }
        this.roleNames = new String[num];
        num = 0;
        int j = 0;
        for (int i = 0; i < this.roleList.length; ++i) {
            for (j = 0; j < this.roleList[i].xmlNames.length; ++j) {
                this.roleNames[num++] = this.roleList[i].xmlNames[j];
            }
        }
        return true;
    }

    private Role[] loadRoleList(Properties p) {
        int i;
        int numRoles;
        Properties p1;
        String parent = p.getProperty("Extends");
        Role[] rc = new Role[]{};
        if (parent != null && (p1 = ResourceLoader.loadProperties((String)parent)) != null) {
            rc = this.loadRoleList(p1);
        }
        if ((numRoles = ParserUtils.getIntValue((String)p.getProperty("Number_Roles"))) <= 0) {
            return rc;
        }
        Role[] currentRoles = new Role[numRoles];
        for (int i2 = 0; i2 < currentRoles.length; ++i2) {
            currentRoles[i2] = new Role();
            currentRoles[i2].name = p.getProperty("Role_" + i2);
            int num = ParserUtils.getIntValue((String)p.getProperty("Role_" + i2 + ".Num_XML_Names"));
            num = Math.max(0, num);
            currentRoles[i2].xmlNames = new String[num];
            for (int j = 0; j < currentRoles[i2].xmlNames.length; ++j) {
                currentRoles[i2].xmlNames[j] = p.getProperty("Role_" + i2 + ".XML_Name" + j);
            }
        }
        Role[] temp = rc;
        rc = new Role[rc.length + currentRoles.length];
        for (i = 0; i < temp.length; ++i) {
            rc[i] = temp[i];
        }
        for (i = 0; i < currentRoles.length; ++i) {
            rc[temp.length + i] = currentRoles[i];
        }
        return rc;
    }

    @Override
    public Object getRole(String role) {
        if (!this.loadRoles()) {
            return null;
        }
        String roleString = null;
        for (int i = 0; i < this.roleList.length && roleString == null; ++i) {
            if (!this.roleList[i].hasXMLName(role)) continue;
            roleString = this.roleList[i].name;
        }
        if (roleString == null) {
            return null;
        }
        return GraphUtilities.getReflectedFieldValue(roleString);
    }

    @Override
    public String getRoleKey(String role) {
        if (!this.loadRoles()) {
            return null;
        }
        String roleString = null;
        for (int i = 0; i < this.roleList.length && roleString == null; ++i) {
            if (!this.roleList[i].hasXMLName(role)) continue;
            roleString = this.roleList[i].name;
        }
        if (roleString == null) {
            return null;
        }
        return GraphParserUtils.getVariableID(roleString);
    }

    @Override
    public String[] getRoleAttributeNames() {
        if (!this.loadRoles()) {
            return null;
        }
        return this.roleNames;
    }

    class Role {
        String name;
        String[] xmlNames;

        Role() {
        }

        public boolean hasXMLName(String name) {
            for (int i = 0; i < this.xmlNames.length; ++i) {
                if (!this.xmlNames[i].equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }
    }
}

