/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class RoleParser
implements ElementParserInterface {
    String[] variables = null;
    boolean discrete = false;
    Object sortOrder = RoleInterface.ROLE_SORT_DATA;
    RoleInterface chart = null;

    public RoleParser() {
        this(null);
    }

    public RoleParser(RoleInterface ri) {
        this.chart = ri;
    }

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        Object obj;
        SILKNumber roleObject;
        String type;
        RoleInterface ri = this.chart;
        if (instance instanceof RoleInterface) {
            ri = (RoleInterface)instance;
        }
        if ((type = element.getAttribute("type")) == null || type.trim().length() == 0) {
            return null;
        }
        Roles r = (Roles)context.get("ROLE_INDEX");
        if (r == null) {
            r = Roles.getInstance(null);
            context.put("ROLE_INDEX", r);
        }
        if ((roleObject = r.getRoleObject(type)) == null) {
            roleObject = r.getRoleObjectForUSName(type);
        }
        if ((obj = roleObject) == null) {
            obj = type;
        }
        String vars = element.getAttribute("variable");
        this.variables = ParserUtils.parseStringArray((String)vars, (String)",");
        this.discrete = ParserUtils.getBooleanValue((String)element.getAttribute("discrete"));
        String sort = element.getAttribute("sortOrder");
        if (sort != null && sort.length() > 0) {
            this.sortOrder = sort.equalsIgnoreCase("Ascending") ? RoleInterface.ROLE_SORT_ASCENDING : (sort.equalsIgnoreCase("Descending") ? RoleInterface.ROLE_SORT_DESCENDING : (sort.equalsIgnoreCase("None") ? RoleInterface.ROLE_SORT_NONE : (sort.equalsIgnoreCase("Custom") ? RoleInterface.ROLE_SORT_CUSTOM : RoleInterface.ROLE_SORT_DATA)));
        }
        if (ri != null) {
            for (int i = 0; i < this.variables.length; ++i) {
                ri.addRole(this.variables[i], obj);
            }
            ri.setDiscrete(obj, this.discrete);
            ri.setSortOrder(obj, this.sortOrder);
            return ri;
        }
        return this;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return null;
    }

    public Object getObject() {
        return this;
    }
}

