/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.CustomTipInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoInterface;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;

public class ParserUtils
extends GraphParserUtils {
    public static String getUniqueChartName(Hashtable context) {
        if (context == null) {
            return "Chart0";
        }
        Integer i = (Integer)context.get("CHART_COUNT");
        if (i == null) {
            context.put("CHART_COUNT", new Integer(1));
            return "Chart0";
        }
        String rc = "Chart" + i;
        context.put("CHART_COUNT", new Integer(i + 1));
        return rc;
    }

    public static Element toXML(String elementName, Hashtable context, Object obj, SILKElementInfoInterface info) {
        if (elementName == null || info == null || obj == null) {
            return null;
        }
        Element rc = ParserUtils.newElement((Hashtable)context, (String)elementName);
        boolean scriptRoles = false;
        if (context != null && context.get("SCRIPT_ROLES") != null && context.get("SCRIPT_ROLES") instanceof Boolean) {
            scriptRoles = (Boolean)context.get("SCRIPT_ROLES");
        }
        Object id = null;
        if (obj instanceof BaseComponentInterface) {
            id = ((BaseComponentInterface)obj).getId();
        }
        if (id != null) {
            rc.setAttribute("name", id.toString());
        }
        if (scriptRoles && obj instanceof RoleInterface) {
            Roles roleIndex = Roles.getInstance(null);
            RoleInterface ri = (RoleInterface)obj;
            String[] roles = info.getRoleAttributeNames();
            String dataName = null;
            Object source = ri.getDataSource();
            dataName = ParserUtils.getNameForDataObject((Object)source, (Hashtable)context);
            if (dataName != null) {
                rc.setAttribute("data", dataName);
            }
            Vector<Object> processedRoles = new Vector<Object>();
            for (int i = 0; i < roles.length; ++i) {
                Object roleObject = info.getRole(roles[i]);
                if (processedRoles.contains(roleObject) || roleObject == null) continue;
                processedRoles.addElement(roleObject);
                Object role = ri.getAllVariables(roleObject);
                Object so = ri.getSortOrder(roleObject);
                if (role == null && so == null) continue;
                Element rElement = ParserUtils.newElement((Hashtable)context, (String)"Role");
                rElement.setAttribute("type", roleIndex.getRoleUSName(info.getRoleKey(roles[i])));
                rElement.setAttribute("discrete", ri.isDiscrete(roleObject) + "");
                if (so != null) {
                    String sortOrder = "Data";
                    if (so instanceof Number) {
                        int sort = ((Number)so).intValue();
                        switch (sort) {
                            case 1: {
                                sortOrder = "Ascending";
                                break;
                            }
                            case -1: {
                                sortOrder = "Descending";
                                break;
                            }
                            case -2: {
                                sortOrder = "None";
                                break;
                            }
                            case -3: {
                                sortOrder = "Custom";
                                break;
                            }
                            default: {
                                sortOrder = "Data";
                                break;
                            }
                        }
                    } else {
                        sortOrder = so.toString();
                    }
                    if (!sortOrder.equalsIgnoreCase("Custom")) {
                        rElement.setAttribute("sortOrder", sortOrder);
                    }
                }
                String vars = "";
                Enumeration e = Extract.elements((Object)role);
                while (e.hasMoreElements()) {
                    vars = vars + ParserUtils.getString(e.nextElement());
                    if (!e.hasMoreElements()) continue;
                    vars = vars + ",";
                }
                if (vars != null && vars.trim().length() > 0) {
                    rElement.setAttribute("variable", vars);
                }
                rc.appendChild(rElement);
            }
        }
        if (obj instanceof PropertyInterface) {
            PropertyInterface pi = (PropertyInterface)obj;
            String[] properties = info.getAttributeNames();
            for (int i = 0; i < properties.length; ++i) {
                Object prop;
                if (!pi.hasUserSetValue(info.getPropertyIndex(properties[i])) || (prop = pi.getPropertyValue(info.getPropertyIndex(properties[i]))) == null) continue;
                rc.setAttribute(properties[i], ParserUtils.getString((Object)prop));
            }
        }
        return rc;
    }

    public static void parseData(Hashtable context, Element element, SILKElementInfoInterface info) {
        if (context == null || element == null || info == null) {
            return;
        }
        Object xmlTarget = info.getXmlTarget();
        String[] roles = info.getRoleAttributeNames();
        if (roles != null && xmlTarget instanceof SourceInterface) {
            String dataName = null;
            for (int i = 0; i < roles.length && dataName == null; ++i) {
                int count;
                String r = element.getAttribute(roles[i]);
                if (r != null && r.length() > 0) {
                    if (r.indexOf(".") <= 0 && r.indexOf(35) <= 0) continue;
                    dataName = ParserUtils.getDataID((String)r);
                    continue;
                }
                if (!(xmlTarget instanceof RoleInterface)) continue;
                Object roleObj = info.getRole(roles[i]);
                int max = ((RoleInterface)xmlTarget).getMaxAllowed(roleObj);
                if (max <= 1) continue;
                String r1 = element.getAttribute(roles[i] + count);
                for (count = 1; r1 != null && count <= max; ++count) {
                    if (r1.indexOf(46) > 0 || r1.indexOf(35) > 0) {
                        dataName = ParserUtils.getDataID((String)r1);
                        count = max + 1;
                    }
                    r1 = element.getAttribute(roles[i] + count);
                }
            }
            if (dataName == null) {
                dataName = element.getAttribute("data");
            }
            if (dataName != null && dataName.trim().length() > 0 && ParserUtils.getDataFromContext((Hashtable)context, (String)dataName) != null) {
                if (((SourceInterface)xmlTarget).getDataSource() == null) {
                    ((SourceInterface)xmlTarget).setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)dataName));
                }
                if (xmlTarget instanceof ComponentInterface && element.hasAttribute("where")) {
                    String where = ParserUtils.convertValidXMLString((String)element.getAttribute("where"));
                    ((ComponentInterface)xmlTarget).applyWhereClause(where, true);
                }
            }
        }
    }

    public static void parseElement(Hashtable context, Element element, SILKElementInfoInterface info) {
        RoleInterface chart;
        if (context == null || element == null || info == null) {
            return;
        }
        Object xmlTarget = info.getXmlTarget();
        String[] roles = info.getRoleAttributeNames();
        ParserUtils.parseData(context, element, info);
        if (roles != null && xmlTarget instanceof RoleInterface) {
            chart = (RoleInterface)xmlTarget;
            for (int i = 0; i < roles.length; ++i) {
                Object roleObj = info.getRole(roles[i]);
                if (roleObj == null) continue;
                int numAllowed = chart.getMaxAllowed(roleObj);
                String varName = ParserUtils.getVariableID((String)element.getAttribute(roles[i]));
                if (numAllowed == 1 && (varName == null || varName.trim().length() == 0)) continue;
                if (varName != null && varName.length() > 0) {
                    chart.setRole(varName, roleObj);
                }
                if (numAllowed <= 1) continue;
                int index = 1;
                boolean done = false;
                while (!done) {
                    varName = ParserUtils.getVariableID((String)element.getAttribute(roles[i] + index));
                    if (varName == null || varName.trim().length() == 0) {
                        done = true;
                    } else {
                        chart.addRole(varName, roleObj);
                    }
                    ++index;
                }
            }
        }
        if (xmlTarget instanceof PropertyInterface) {
            chart = (PropertyInterface)xmlTarget;
            String[] attrs = info.getAttributeNames();
            if (attrs == null) {
                return;
            }
            for (int i = 0; i < attrs.length; ++i) {
                String value = element.getAttribute(attrs[i]);
                if (value == null || value.trim().length() == 0) continue;
                value = ParserUtils.convertValidXMLString((String)value);
                int index = info.getPropertyIndex(attrs[i]);
                Object valids = info.getValidValues(attrs[i]);
                Object obj = ParserUtils.validateAndConvert((Object)valids, (String)value, (Hashtable)context);
                if (obj == null || value == null) continue;
                chart.setPropertyValue(index, obj);
            }
            chart.applyPropertyChanges();
        }
        if ((context.get("OVERLAY_ACTIVE") == null || Boolean.FALSE.equals(context.get("OVERLAY_ACTIVE"))) && xmlTarget instanceof BaseElement && info instanceof SILKElementInfoReader) {
            ((SILKElementInfoReader)info).setInstance(new BaseElementComponent((BaseElement)xmlTarget));
        }
    }

    public static void parseAxisOpts(AxisInterface axis, Element element) {
        String ticks;
        if (axis == null || element == null) {
            return;
        }
        String label = element.getAttribute("label");
        if (label != null && label.length() > 0) {
            axis.setLabel(label);
        }
        if ((ticks = element.getAttribute("ticks")) != null && ticks.length() > 0) {
            String[] strs = ParserUtils.parseStringArray((String)ticks, (String)",");
            Object[] vals = new Double[strs.length];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = new Double(ParserUtils.getDoubleValue((String)strs[i]));
            }
            axis.setAxis(null, null, 0, 0, vals, new Boolean(false), new Boolean(false));
        }
        if (element.hasAttribute("gridDisplay")) {
            boolean gridOn = ParserUtils.getBooleanValue((String)element.getAttribute("gridDisplay"));
            axis.getGridLines().setVisible(gridOn);
        }
    }

    public static void parseFillAttrs(Element fillAttrs, StyleElement styleElement) {
        if (fillAttrs == null || styleElement == null) {
            return;
        }
        if (fillAttrs.hasAttribute("color")) {
            styleElement.setAttribute("fillColor", fillAttrs.getAttribute("color"));
        }
        if (fillAttrs.hasAttribute("transparency")) {
            styleElement.setAttribute("transparency", fillAttrs.getAttribute("transparency"));
        }
    }

    public static void parseLineAttrs(Element lineAttrs, StyleElement styleElement) {
        if (lineAttrs == null || styleElement == null) {
            return;
        }
        if (lineAttrs.hasAttribute("pattern")) {
            styleElement.setAttribute("lineStyle", lineAttrs.getAttribute("pattern"));
        }
        if (lineAttrs.hasAttribute("color")) {
            styleElement.setAttribute("lineColor", lineAttrs.getAttribute("color"));
        }
        if (lineAttrs.hasAttribute("thickness")) {
            styleElement.setAttribute("lineThickness", lineAttrs.getAttribute("thickness"));
        }
    }

    public static void parseMarkerAttrs(Element markerAttrs, StyleElement styleElement) {
        if (markerAttrs == null || styleElement == null) {
            return;
        }
        if (markerAttrs.hasAttribute("color")) {
            styleElement.setAttribute("markerColor", markerAttrs.getAttribute("color"));
        }
        if (markerAttrs.hasAttribute("symbol")) {
            styleElement.setAttribute("markerSymbol", markerAttrs.getAttribute("symbol"));
        }
        if (markerAttrs.hasAttribute("size")) {
            styleElement.setAttribute("markerSize", markerAttrs.getAttribute("size"));
        }
    }

    public static void parseUserDefinedRoles(Element element, RoleInterface plot, RoleManager rm) {
        int i = 1;
        Element role = null;
        while ((role = ParserUtils.getChildWithTagName((String)"Role", (Element)element, (int)i)) != null) {
            if (role.hasAttribute("name")) {
                String name = role.getAttribute("name").toUpperCase();
                rm.newRole(name, 1);
                plot.setRole(ParserUtils.getVariableID((String)role.getTextContent()), name);
            }
            ++i;
        }
    }

    public static void parseTipFormats(Element element, CustomTipInterface cti) {
        int i = 1;
        Element tipFormat = null;
        while ((tipFormat = ParserUtils.getChildWithTagName((String)"TipFormat", (Element)element, (int)i)) != null) {
            if (tipFormat.hasAttribute("name")) {
                String name = tipFormat.getAttribute("name");
                cti.setTipFormat(name.toUpperCase(), tipFormat.getTextContent());
            }
            ++i;
        }
    }

    public static void parseTipLabels(Element element, CustomTipInterface cti) {
        int i = 1;
        Element tipLabel = null;
        while ((tipLabel = ParserUtils.getChildWithTagName((String)"TipLabel", (Element)element, (int)i)) != null) {
            if (tipLabel.hasAttribute("name")) {
                String name = tipLabel.getAttribute("name").toUpperCase();
                cti.setTipLabel(name, tipLabel.getTextContent());
            }
            ++i;
        }
    }

    public static void parseCustomTip(Element element, CustomTipInterface cti) {
        if (element.hasAttribute("tip")) {
            String tip = element.getAttribute("tip");
            if (tip == null || tip.length() == 0) {
                return;
            }
            StringTokenizer st = new StringTokenizer(tip);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toUpperCase();
                cti.addTipDisplayRole(token);
            }
        }
    }
}

