/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.MapElement;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class MapParser
extends ChartParser {
    SILKElementInfoReader mapInfo = null;

    public MapParser() {
        this(null);
    }

    public MapParser(PropertyInterface sc) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/map.config";
        this.mapInfo = new SILKElementInfoReader(configFile);
        this.mapInfo.setInstance(sc);
    }

    @Override
    public Object getFromXML(Hashtable context, Element element, Object instance) {
        Object obj = this.mapInfo.getXmlTarget();
        if (obj instanceof SourceInterface) {
            SourceInterface si = (SourceInterface)obj;
            if (element.hasAttribute("mapData")) {
                si.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)element.getAttribute("mapData")), (Object)"Map");
            } else if (element.hasAttribute("mapId")) {
                si.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)element.getAttribute("mapId"))), (Object)"Map");
            }
            if (element.hasAttribute("data")) {
                si.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)element.getAttribute("data")), (Object)"Response");
            } else if (element.hasAttribute("responseData")) {
                si.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)element.getAttribute("responseData")), (Object)"Response");
            } else if (element.hasAttribute("responseId")) {
                si.setDataSource(ParserUtils.getDataFromContext((Hashtable)context, (String)ParserUtils.getDataID((String)element.getAttribute("responseId"))), (Object)"Response");
            }
        }
        if (element.hasAttribute("fill")) {
            ((MapElement)obj).setFillOn(ParserUtils.getBooleanValue((String)element.getAttribute("fill")));
        }
        if (element.hasAttribute("colorModel")) {
            ((MapElement)obj).setPropertyValue(53, element.getAttribute("colorModel"));
            ((MapElement)obj).applyPropertyChanges();
        }
        return super.getFromXML(context, element, instance);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement(context, element, this.mapInfo);
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        boolean fill;
        SourceInterface si = null;
        if (object instanceof SourceInterface) {
            si = (SourceInterface)object;
        }
        if (si == null) {
            si = this.mapInfo.getXmlTarget() instanceof SourceInterface ? (SourceInterface)this.mapInfo.getXmlTarget() : null;
        }
        Element rc = ParserUtils.toXML(this.getTagName(), context, object, this.mapInfo);
        if (si != null) {
            rc.setAttribute("mapData", ParserUtils.getNameForDataObject((Object)si.getDataSource((Object)"Map"), (Hashtable)context));
        }
        if (!(fill = ((MapElement)object).isFillOn())) {
            rc.setAttribute("fill", "false");
        }
        return rc;
    }

    @Override
    public String getTagName() {
        return "Map";
    }

    @Override
    public Object getObject() {
        return this.mapInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof PropertyInterface)) {
            return false;
        }
        if (this.mapInfo != null) {
            this.mapInfo.setInstance(instance);
        }
        return true;
    }
}

