/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.JTableComponent;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class JTableParser
extends ChartParser {
    private JTableComponent jtable = null;

    public JTableParser() {
        this(null);
    }

    public JTableParser(JTableComponent instance) {
        this.jtable = instance;
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        String headerWrap;
        String scrollToSelected;
        String sortEnabled;
        String varDesc;
        String obsCol = element.getAttribute("showObsColumn");
        if (obsCol != null && obsCol.length() > 0) {
            this.jtable.setObsNumberColumnVisible(ParserUtils.getBooleanValue((String)obsCol));
        }
        if ((varDesc = element.getAttribute("useVariableDescription")) != null && varDesc.length() > 0) {
            this.jtable.setUseVariableDescription(ParserUtils.getBooleanValue((String)varDesc));
        }
        if ((sortEnabled = element.getAttribute("sortEnabled")) != null && sortEnabled.length() > 0) {
            this.jtable.setSortingEnabled(ParserUtils.getBooleanValue((String)sortEnabled));
        }
        if ((scrollToSelected = element.getAttribute("scrollToSelected")) != null && scrollToSelected.length() > 0) {
            this.jtable.setScrollTableToSelectedCell(ParserUtils.getBooleanValue((String)scrollToSelected));
        }
        if ((headerWrap = element.getAttribute("headerWrap")) != null && headerWrap.length() > 0) {
            this.jtable.setHeaderWrap(ParserUtils.getBooleanValue((String)headerWrap));
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"Table");
        if (object != null && object instanceof JTableComponent) {
            JTableComponent component = (JTableComponent)object;
            Object obj = component.getDataSource();
            if (obj != null) {
                rc.setAttribute("data", ParserUtils.getNameForDataObject((Object)obj, (Hashtable)context));
            }
            if (component.isObsNumberColumnVisible()) {
                rc.setAttribute("showObsColumn", "true");
            }
            if (!component.isVariableDescriptionUsed()) {
                rc.setAttribute("useVariableDescription", "false");
            }
            if (!component.isSortingEnabled()) {
                rc.setAttribute("sortEnabled", "false");
            }
            if (component.isTableScrollingToSelectedCell()) {
                rc.setAttribute("scrollToSelected", "true");
            }
            if (component.isHeaderWrapped()) {
                rc.setAttribute("headerWrap", "true");
            }
        }
        return rc;
    }

    @Override
    public Object getObject() {
        if (this.jtable == null) {
            this.jtable = new JTableComponent();
        }
        return this.jtable;
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof JTableComponent)) {
            return false;
        }
        this.jtable = (JTableComponent)instance;
        return true;
    }
}

