/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.w3c.dom.Element;

public class EntryStringParser
extends ChartParser {
    protected JLabel label = null;

    public EntryStringParser() {
        this(new JLabel());
    }

    public EntryStringParser(JLabel instance) {
        this.label = instance;
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        String bgColor;
        if (element.hasAttribute("pad")) {
            int pad = ParserUtils.getIntValue((String)element.getAttribute("pad"));
            this.label.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        }
        if ((bgColor = element.getAttribute("backgroundColor")) != null && bgColor.length() > 0) {
            this.label.setOpaque(true);
            this.label.setBackground(ColorParse.getColorFromString((String)bgColor));
        }
        Element entry = null;
        int index = 1;
        String text = "";
        while ((entry = ParserUtils.getChildWithTagName((String)"EntryItem", (Element)element, (int)index++)) != null) {
            String str = ParserUtils.getElementText((Element)entry);
            if (str == null) continue;
            text = text + str;
        }
        this.label.setText(text);
        Element ta = ParserUtils.getChildWithTagName((String)"TextAttrs", (Element)element);
        if (ta != null) {
            String weight;
            int fontWeight = 0;
            int fontSize = 12;
            Style style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
            String fontFamily = style.getTextStyleElement("ValueText").getFontFamily();
            if (ta.hasAttribute("weight") && (weight = ta.getAttribute("weight")).equalsIgnoreCase("bold")) {
                fontWeight = 1;
            }
            this.label.setFont(new Font(fontFamily, fontWeight, fontSize));
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    public Object getObject() {
        return this.label;
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof JLabel)) {
            return false;
        }
        this.label = (JLabel)instance;
        return true;
    }
}

