/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.text.SASFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class DiscreteLegendParser {
    public static LegendObjectJ2D parseDiscreteLegend(Element element, Hashtable context) {
        if (element == null || context == null) {
            return null;
        }
        Roles roles = Roles.getInstance(null);
        LegendObjectJ2D rc = new LegendObjectJ2D();
        rc.setVisible(true);
        Element graphNames = ParserUtils.getChildWithTagName((String)"GraphNames", (Element)element);
        if (graphNames != null) {
            TextStyleInterface text;
            Element value = null;
            int index = 1;
            Vector v = new Vector();
            int count = 0;
            while ((value = ParserUtils.getChildWithTagName((String)"Value", (Element)graphNames, (int)index++)) != null) {
                Object graph;
                String graphName = ParserUtils.getElementText((Element)value);
                if (graphName == null || !((graph = context.get(graphName)) instanceof PropertyInterface)) continue;
                ++count;
                Enumeration e = DiscreteLegendParser.getEntries((PropertyInterface)graph, roles);
                if (e == null) continue;
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (!(o instanceof LegendEntryInterface)) continue;
                    v.addElement(o);
                }
                if (count == 1 && graph instanceof BaseElement) {
                    BaseElement be = (BaseElement)graph;
                    Object variable = be.getPropertyValue(434);
                    if (variable != null && be.getFilter() != null) {
                        rc.setData(be.getFilter(), variable.toString());
                        rc.getLabel().setFormat(be.getFilter().getFormat(variable, SASFormat.class));
                        continue;
                    }
                    rc.setData(null, null);
                    continue;
                }
                rc.setData(null, null);
            }
            if (element.hasAttribute("title")) {
                rc.setTitle(element.getAttribute("title"));
                rc.getTitle().setVisible(true);
            }
            if (element.hasAttribute("border")) {
                rc.setBorder(new Boolean(ParserUtils.getBooleanValue((String)element.getAttribute("border"))));
            }
            if (element.hasAttribute("across")) {
                rc.setAcross(ParserUtils.getIntValue((String)element.getAttribute("across")));
            } else if (element.hasAttribute("down")) {
                rc.setDown(ParserUtils.getIntValue((String)element.getAttribute("down")));
            }
            if (element.hasAttribute("titleAttrs") && (text = rc.getTitle()) instanceof PropertyInterface) {
                ((PropertyInterface)text).setPropertyValue(9018, (Object)element.getAttribute("titleAttrs"));
                ((PropertyInterface)text).applyPropertyChanges();
            }
            Object[] entries = new LegendEntryInterface[v.size()];
            v.copyInto(entries);
            rc.setValues((LegendEntryInterface[])entries, false);
        }
        return rc;
    }

    private static Enumeration getEntries(PropertyInterface graph, Roles roles) {
        SILKNumber group = roles.getRoleObject("ROLE_GROUP");
        graph.setPropertyValue(23, (Object)group);
        Object entries = graph.getPropertyValue(433);
        if (entries == null) {
            Object overlayEntry = graph.getPropertyValue(444);
            if (overlayEntry instanceof LegendEntry) {
                return Extract.elements((Object)overlayEntry);
            }
            return null;
        }
        return Extract.elements((Object)entries);
    }
}

