/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.text.SASFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class ContinuousLegendParser {
    public static LegendObjectJ2D parseContinuousLegend(Element element, Hashtable context) {
        if (element == null || context == null) {
            return null;
        }
        Roles roles = Roles.getInstance(null);
        LegendObjectJ2D rc = new LegendObjectJ2D();
        rc.setVisible(true);
        Element graphNames = ParserUtils.getChildWithTagName((String)"GraphNames", (Element)element);
        if (graphNames != null) {
            String position;
            TextStyleInterface text;
            Element value = null;
            int index = 1;
            Vector v = new Vector();
            int count = 0;
            while ((value = ParserUtils.getChildWithTagName((String)"Value", (Element)graphNames, (int)index++)) != null) {
                Object graph;
                String graphName = ParserUtils.getElementText((Element)value);
                if (graphName == null || !((graph = context.get(graphName)) instanceof PropertyInterface)) continue;
                ++count;
                PropertyInterface pi = (PropertyInterface)graph;
                Enumeration e = ContinuousLegendParser.getEntries(pi, roles);
                if (e == null) continue;
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (!(o instanceof LegendEntryInterface)) continue;
                    v.addElement(o);
                }
                Object variable = pi.getPropertyValue(434);
                if (variable != null && pi instanceof BaseElement) {
                    rc.getLabel().setFormat(((BaseElement)pi).getFilter().getFormat(variable, SASFormat.class));
                    continue;
                }
                rc.setData(null, null);
            }
            if (element.hasAttribute("title")) {
                rc.setTitle(element.getAttribute("title"));
                rc.getTitle().setVisible(true);
            }
            if (element.hasAttribute("border")) {
                rc.setBorder(new Boolean(ParserUtils.getBooleanValue((String)element.getAttribute("border"))));
            }
            if (element.hasAttribute("titleAttrs") && (text = rc.getTitle()) instanceof PropertyInterface) {
                ((PropertyInterface)text).setPropertyValue(9018, (Object)element.getAttribute("titleAttrs"));
                ((PropertyInterface)text).applyPropertyChanges();
            }
            if (element.hasAttribute("location") && "inside".equalsIgnoreCase(element.getAttribute("location"))) {
                rc.setInside(true);
            }
            if ((position = element.getAttribute("position")) != null && position.length() > 0) {
                if (position.equalsIgnoreCase("East")) {
                    rc.setPosition(3);
                } else if (position.equalsIgnoreCase("NorthEast")) {
                    rc.setPosition(6);
                } else if (position.equalsIgnoreCase("NorthWest")) {
                    rc.setPosition(7);
                } else if (position.equalsIgnoreCase("West")) {
                    rc.setPosition(4);
                } else if (position.equalsIgnoreCase("North")) {
                    rc.setPosition(1);
                } else if (position.equalsIgnoreCase("SouthEast")) {
                    rc.setPosition(8);
                } else if (position.equalsIgnoreCase("SouthWest")) {
                    rc.setPosition(9);
                } else {
                    rc.setPosition(2);
                }
            }
            Object[] entries = new LegendEntryInterface[v.size()];
            v.copyInto(entries);
            rc.setValues((LegendEntryInterface[])entries, true);
        }
        return rc;
    }

    private static Enumeration getEntries(PropertyInterface graph, Roles roles) {
        SILKNumber group = roles.getRoleObject("ROLE_COLOR");
        graph.setPropertyValue(23, (Object)group);
        Object entries = graph.getPropertyValue(433);
        if (entries == null) {
            Object overlayEntry = graph.getPropertyValue(444);
            if (overlayEntry instanceof LegendEntry) {
                return Extract.elements((Object)overlayEntry);
            }
            return null;
        }
        return Extract.elements((Object)entries);
    }
}

