/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.StyleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.BackgroundParser;
import com.sas.graphics.silk.xml.parsers.ChartTipParser;
import com.sas.graphics.silk.xml.parsers.EntryTitleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.TextParser;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentParser
implements ElementParserInterface {
    protected String name = "_NONE_";

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        String n = element.getAttribute("name");
        if (this.name.equals("_NONE_")) {
            this.name = n == null || n.length() == 0 ? ParserUtils.getUniqueChartName(context) : n;
        }
        if (context != null && this.getObject() != null) {
            Object obj = this.getObject();
            if (obj instanceof BaseElement && (context.get("OVERLAY_ACTIVE") == null || Boolean.FALSE.equals(context.get("OVERLAY_ACTIVE")))) {
                obj = new BaseElementComponent((BaseElement)obj);
            }
            context.put(this.name, obj);
        }
        if (this.getObject() instanceof PropertyInterface) {
            Object obj;
            boolean opaque;
            PropertyInterface prop = (PropertyInterface)this.getObject();
            Object applet = context.get("APPLET_CONTEXT");
            if (applet != null) {
                prop.setPropertyValue(36, applet);
            }
            if (element.hasAttribute("createLegends")) {
                boolean b = ParserUtils.getBooleanValue((String)element.getAttribute("createLegends"));
                prop.setPropertyValue(64, (Object)(b ? Boolean.TRUE : Boolean.FALSE));
            }
            boolean bl = opaque = !SILKGlobal.isFlagSet(4);
            if (context.get("STATGRAPH_ROOT_CHART") == null && (context.get("OVERLAY_ACTIVE") == null || Boolean.FALSE.equals(context.get("OVERLAY_ACTIVE")))) {
                opaque = true;
            }
            if (element.hasAttribute("opaque")) {
                opaque = ParserUtils.getBooleanValue((String)element.getAttribute("opaque"));
            }
            prop.setPropertyValue(66, (Object)new Boolean(opaque));
            Element dataLabelAttrs = ParserUtils.getChildWithTagName((String)"DataLabelAttrs", (Element)element);
            if (dataLabelAttrs != null && (obj = ((PropertyInterface)this.getObject()).getPropertyValue(19012)) instanceof StyleElementAttrs) {
                TextParser.parseLabelAttrs(dataLabelAttrs, ((StyleElementAttrs)obj).getOverrides(true));
            }
            prop.applyPropertyChanges();
        }
        if (this.getObject() instanceof SourceInterface && ((SourceInterface)this.getObject()).getDataSource() == null) {
            SourceInterface chart = (SourceInterface)this.getObject();
            String data = element.getAttribute("data");
            if (data != null && data.length() > 0 && chart.getDataSource() == null) {
                chart.setDataSource(context.get(data));
            }
        }
        if (this.getObject() instanceof ComponentInterface) {
            Element chartTip;
            Element background;
            Element title;
            String where;
            ComponentInterface component = (ComponentInterface)this.getObject();
            component.setId(this.name);
            Object style = context.get("DEFAULT_STYLE");
            String localStyle = element.getAttribute("style");
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            Element styleElement = ParserUtils.getChildWithTagName((String)"style:Scheme", (Element)element);
            Style s = Style.getStyle((Element)styleElement);
            if (s != null) {
                sc.addStyle(s);
            }
            if (localStyle != null && localStyle.length() > 0) {
                style = sc.getStyle(localStyle);
            }
            AnnotateInterface ai = component.getAnnotate();
            Element annotation = ParserUtils.getChildWithTagName((String)"Annotation", (Element)element);
            if (ai != null && annotation != null) {
                ai.readFromXML(annotation);
            }
            if (element.hasAttribute("actionMode")) {
                String actionMode = element.getAttribute("actionMode");
                int mode = 0;
                if (actionMode.equalsIgnoreCase("NONE")) {
                    mode = 0;
                } else if (actionMode.equalsIgnoreCase("BRUSH")) {
                    mode = 1;
                } else if (actionMode.equalsIgnoreCase("VIEWPORT")) {
                    mode = 2;
                } else if (actionMode.equalsIgnoreCase("ZOOM")) {
                    mode = 3;
                } else if (actionMode.equalsIgnoreCase("PAN")) {
                    mode = 4;
                } else if (actionMode.equalsIgnoreCase("SELECT")) {
                    mode = 6;
                } else if (actionMode.equalsIgnoreCase("SELECTREGION")) {
                    mode = 14;
                } else if (actionMode.equalsIgnoreCase("DRILLDOWN")) {
                    mode = 8;
                } else if (actionMode.equalsIgnoreCase("EDIT")) {
                    mode = 9;
                } else if (actionMode.equalsIgnoreCase("GEOMETRIC ZOOM")) {
                    mode = 10;
                } else if (actionMode.equalsIgnoreCase("GEMOETRIC PAN")) {
                    mode = 11;
                } else if (actionMode.equalsIgnoreCase("GEOMETRIC ROTATE")) {
                    mode = 12;
                }
                component.setActionMode(mode);
            }
            String localColorScheme = null;
            if (element.hasAttribute("colorSchme")) {
                localColorScheme = element.getAttribute("colorScheme");
                style = sc.getStyle(localColorScheme);
            }
            if (style != null && !(style instanceof StyleInterface)) {
                style = sc.getStyle(style.toString());
            }
            if (style == null) {
                style = sc.getCurrentStyle();
            }
            boolean b = false;
            if (style != null) {
                b = component.setStyle(style);
            }
            if (localColorScheme != null && localColorScheme.length() > 0) {
                b = false;
            }
            if (!b) {
                component.setColorScheme(style);
            }
            if ((where = element.getAttribute("where")) != null && where.length() > 0) {
                component.applyWhereClause(ParserUtils.convertValidXMLString((String)where), true);
            }
            if ((title = ParserUtils.getChildWithTagName((String)"Title", (Element)element)) != null) {
                TextStyleInterface oldTitle = component.getTitle(0);
                TextStyleInterface tsi = TextParser.parseTextElement(title, oldTitle);
                component.setTitle(0, tsi);
            } else {
                title = ParserUtils.getChildWithTagName((String)"EntryTitle", (Element)element, (int)1);
                if (title != null) {
                    EntryTitleParser.parseEntryStyle(title, component.getTitle(0));
                }
            }
            Element subtitle = ParserUtils.getChildWithTagName((String)"Subtitle", (Element)element);
            if (subtitle != null) {
                TextStyleInterface oldTitle = component.getTitle(1);
                TextStyleInterface tsi = TextParser.parseTextElement(subtitle, oldTitle);
                component.setTitle(1, tsi);
            } else {
                subtitle = ParserUtils.getChildWithTagName((String)"EntryTitle", (Element)element, (int)2);
                if (subtitle != null) {
                    EntryTitleParser.parseEntryStyle(subtitle, component.getTitle(1));
                }
            }
            Element footnote = ParserUtils.getChildWithTagName((String)"Footnote", (Element)element);
            if (footnote != null) {
                TextStyleInterface oldFn = component.getFootnote(0);
                TextStyleInterface tsi = TextParser.parseTextElement(footnote, oldFn);
                component.setFootnote(0, tsi);
            }
            if ((background = ParserUtils.getChildWithTagName((String)"Background", (Element)element)) != null && component instanceof GraphBackgroundInterface) {
                BackgroundParser.parseBackgroundElement(background, (GraphBackgroundInterface)((Object)component), context);
            }
            if ((chartTip = ParserUtils.getChildWithTagName((String)"ChartTip", (Element)element)) != null) {
                ChartTipParser.parseTipElement(chartTip, component.getChartTip(), context);
                String visible = chartTip.getAttribute("visible");
                if (visible != null && visible.length() > 0) {
                    component.setChartTipsOn(ParserUtils.getBooleanValue((String)visible));
                }
            }
            if (element.hasAttribute("localSelections") && component.getFilter() != null) {
                component.getFilter().setSelectionsLocal(ParserUtils.getBooleanValue((String)element.getAttribute("localSelections")));
            }
            Object applet = context.get("APPLET_CONTEXT");
            component.addDrilldownListener((DrilldownListenerInterface)applet);
        }
        SILKParser.addMetaData(this.getObject(), context, ParserUtils.parseMetaData((Element)element));
        return this.getObject();
    }

    public String getName() {
        return this.name;
    }

    public Element putToXML(Hashtable context, Object instance) {
        return this.putToXML(context, instance, null);
    }

    public Element putToXML(Hashtable context, Object instance, Element element) {
        Hashtable metaData;
        BackgroundParser bParser;
        Element e;
        Element rc = element;
        if (rc == null) {
            rc = ParserUtils.newElement((Hashtable)context, (String)this.getTagName());
        }
        if (instance instanceof ComponentInterface) {
            AnnotateInterface ai;
            String where;
            TextParser textParser;
            Element e2;
            Object o;
            ComponentInterface component;
            PropertyInterface prop = null;
            if (instance instanceof PropertyInterface) {
                prop = (PropertyInterface)instance;
            }
            if ((component = (ComponentInterface)instance).getId() != null) {
                rc.setAttribute("name", component.getId().toString());
            }
            ChartTipParser parser = new ChartTipParser();
            Element tip = parser.putToXML(context, component.getChartTip());
            if (prop != null && tip != null) {
                if (prop.hasUserSetValue(2) && !component.areChartTipsOn()) {
                    tip.setAttribute("visible", "false");
                }
                if (tip != null && (tip.getAttributes().getLength() > 0 || tip.getChildNodes().getLength() > 0)) {
                    rc.appendChild(tip);
                }
            }
            if (prop != null && prop.hasUserSetValue(64) && (o = prop.getPropertyValue(64)) instanceof Boolean) {
                rc.setAttribute("createLegends", ((Boolean)o).toString());
            }
            if ((e2 = (textParser = new TextParser()).putToXML(context, (Object)component.getTitle(0), "Title")) != null) {
                rc.appendChild(e2);
            }
            if ((e2 = textParser.putToXML(context, (Object)component.getTitle(1), "Subtitle")) != null) {
                rc.appendChild(e2);
            }
            if ((e2 = textParser.putToXML(context, (Object)component.getFootnote(0), "Footnote")) != null) {
                rc.appendChild(e2);
            }
            if ((where = component.getWhereClause()) != null && where.trim().length() > 0) {
                element.setAttribute("where", ParserUtils.buildValidXMLString((String)where));
            }
            if ((ai = component.getAnnotate()) != null) {
                Element anno = ai.getAnnotationElement();
                Node n = rc.getOwnerDocument().importNode(anno, true);
                if (n.getAttributes().getLength() > 0 || n.getChildNodes().getLength() > 0) {
                    rc.appendChild(n);
                }
            }
            String styleName = component.getStyle();
            Document doc = (Document)context.get("XML_DOCUMENT");
            if (context != null && styleName != null) {
                StyleCollection sc;
                NodeList list = doc.getElementsByTagName("style:Scheme");
                boolean found = false;
                if (list != null && list.getLength() > 0) {
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node n = list.item(i);
                        if (n.getNodeType() != 1 || !styleName.equalsIgnoreCase((e2 = (Element)n).getAttribute("name"))) continue;
                        found = true;
                    }
                }
                if (!found && (sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48)) != null && sc.getStyle(styleName) != null && !PredefinedStyles.isPredefinedStyle((String)styleName)) {
                    Element style = sc.getStyle(styleName).toElement();
                    Element newStyle = (Element)doc.importNode(style, true);
                    rc.appendChild(newStyle);
                }
            }
        }
        if (instance instanceof GraphBackgroundInterface && (e = (bParser = new BackgroundParser()).putToXML(context, instance)) != null) {
            rc.appendChild(e);
        }
        if (context != null && (metaData = SILKParser.getMetaData(instance, context)) != null) {
            Element meta = ParserUtils.newElement((Hashtable)context, (String)"Meta");
            Enumeration e3 = metaData.keys();
            while (e3.hasMoreElements()) {
                String key = e3.nextElement().toString();
                meta.setAttribute(key, metaData.get(key).toString());
            }
            rc.appendChild(meta);
        }
        if (instance instanceof GraphInterface) {
            GraphInterface graph = (GraphInterface)instance;
            int actionMode = graph.getActionMode();
            switch (actionMode) {
                case 0: {
                    rc.setAttribute("actionMode", "none");
                    break;
                }
                case 1: {
                    rc.setAttribute("actionMode", "brush");
                    break;
                }
                case 6: {
                    rc.setAttribute("actionMode", "select");
                    break;
                }
                case 14: {
                    rc.setAttribute("actionMode", "selectRegion");
                    break;
                }
                case 4: {
                    rc.setAttribute("actionMode", "pan");
                    break;
                }
                case 2: {
                    rc.setAttribute("actionMode", "viewport");
                    break;
                }
                case 3: {
                    rc.setAttribute("actionMode", "zoom");
                }
            }
        }
        return rc;
    }

    public Object getObject() {
        return null;
    }

    public String getTagName() {
        return "Component";
    }
}

