/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.BarComponent;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.xml.parsers.ChartParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.SILKElementInfoReader;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class ClassicBarParser
extends ChartParser {
    protected SILKElementInfoReader barInfo = null;

    public ClassicBarParser() {
        this(null);
    }

    public ClassicBarParser(PropertyInterface instance) {
        String configFile = "com/sas/graphics/silk/xml/parsers/config/bar_classic.config";
        this.barInfo = new SILKElementInfoReader(configFile);
        this.barInfo.setInstance(instance);
    }

    @Override
    protected void loadFromStatgraph(Hashtable context, Element element) {
        ParserUtils.parseElement(context, element, this.barInfo);
        if (this.barInfo.getXmlTarget() instanceof PropertyInterface) {
            int end;
            int start;
            PropertyInterface bar = (PropertyInterface)this.barInfo.getXmlTarget();
            String displayBarRangeStart = element.getAttribute("displayBarRangeStart");
            String displayBarRangeEnd = element.getAttribute("displayBarRangeEnd");
            if (displayBarRangeStart != null && displayBarRangeStart.length() > 0 && displayBarRangeEnd != null && displayBarRangeEnd.length() > 0 && (start = ParserUtils.getIntValue((String)displayBarRangeStart)) < (end = ParserUtils.getIntValue((String)displayBarRangeEnd))) {
                bar.setPropertyValue(809, (Object)new int[]{start, end});
            }
        }
    }

    @Override
    protected void loadFromODS(Hashtable context, Element element) {
    }

    @Override
    protected Element getODSXML(Hashtable context, Object object) {
        return null;
    }

    @Override
    protected Element getStatgraphXML(Hashtable context, Object object) {
        Element rc = ParserUtils.toXML("BarClassic", context, object, this.barInfo);
        this.getChartXML(rc, object);
        return rc;
    }

    protected void getChartXML(Element elem, Object object) {
        int[] range;
        PropertyInterface bar = null;
        bar = object != null && object instanceof PropertyInterface ? (PropertyInterface)object : (PropertyInterface)this.barInfo.getXmlTarget();
        if (bar.hasUserSetValue(809) && object != null && (range = (int[])bar.getPropertyValue(809)) != null && range.length == 2) {
            elem.setAttribute("displayBarRangeStart", Integer.toString(range[0]));
            elem.setAttribute("displayBarRangeEnd", Integer.toString(range[1]));
        }
    }

    @Override
    public Object getObject() {
        return this.barInfo.getXmlTarget();
    }

    @Override
    public boolean setObject(Object instance) {
        if (instance == null || !(instance instanceof BarComponent)) {
            return false;
        }
        this.barInfo.setInstance(instance);
        return true;
    }
}

