/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.AxisParser;
import com.sas.graphics.silk.xml.parsers.ComponentParser;
import com.sas.graphics.silk.xml.parsers.LegendParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.silk.xml.parsers.RoleParser;
import com.sas.graphics.util.Extract;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;

public abstract class ChartParser
extends ComponentParser
implements ElementParserInterface {
    @Override
    public Object getFromXML(Hashtable context, Element element, Object instance) {
        int xmlType = SILKParser.getXMLType(context);
        this.setObject(instance);
        String n = element.getAttribute("name");
        this.name = n == null || n.length() == 0 ? (this.getObject() instanceof SILKComponent ? SILKGlobal.getUniqueName(this.getObject()) : ParserUtils.getUniqueChartName(context)) : n;
        if (context != null && this.getObject() != null) {
            Object obj = this.getObject();
            if (obj instanceof BaseComponentInterface) {
                ((BaseComponentInterface)obj).setId(this.name);
            }
            if (obj instanceof BaseElement && (context.get("OVERLAY_ACTIVE") == null || Boolean.FALSE.equals(context.get("OVERLAY_ACTIVE")))) {
                obj = new BaseElementComponent((BaseElement)obj);
                this.setObject(obj);
            }
            context.put(this.name, obj);
        }
        if (this.getObject() instanceof SourceInterface) {
            SourceInterface chart = (SourceInterface)this.getObject();
            String data = element.getAttribute("data");
            if (data != null && data.length() > 0 && chart.getDataSource() == null) {
                chart.setDataSource(SILKParser.getData(data, context));
            }
            if (chart.getDataSource() == null) {
                String sasData = element.getAttribute("sasData");
                SourceInterface dri = null;
                if (sasData != null && sasData.length() > 0 && (dri = SILKParser.getDataRepository(context)) != null) {
                    chart.setDataSource(dri.getDataSource((Object)sasData));
                }
            }
        }
        Element role = null;
        int i = 1;
        while ((role = ParserUtils.getChildWithTagName((String)"Role", (Element)element, (int)i)) != null) {
            RoleParser rp = new RoleParser();
            rp.getFromXML(context, role, this.getObject());
            ++i;
        }
        if (this.getObject() instanceof ComponentInterface) {
            ((ComponentInterface)this.getObject()).setId(this.name);
        }
        Object rc = super.getFromXML(context, element, instance);
        switch (xmlType) {
            case 1: {
                this.loadFromODS(context, element);
                break;
            }
            case 0: {
                this.loadFromStatgraph(context, element);
            }
        }
        SILKParser.addChart(context, this.getName());
        if (this.getObject() instanceof GraphInterface) {
            Element y2Axis;
            Element x2Axis;
            Element yAxis;
            GraphInterface graph = (GraphInterface)this.getObject();
            Element xAxis = ParserUtils.getChildWithTagName((String)"XAxis", (Element)element);
            if (xAxis != null) {
                AxisInterface axis = graph.getAxis("X");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, xAxis, axis);
            }
            if ((yAxis = ParserUtils.getChildWithTagName((String)"YAxis", (Element)element)) != null) {
                AxisInterface axis = graph.getAxis("Y");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, yAxis, axis);
            }
            if ((x2Axis = ParserUtils.getChildWithTagName((String)"X2Axis", (Element)element)) != null) {
                AxisInterface axis = graph.getAxis("X2");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, x2Axis, axis);
            }
            if ((y2Axis = ParserUtils.getChildWithTagName((String)"Y2Axis", (Element)element)) != null) {
                AxisInterface axis = graph.getAxis("Y2");
                AxisParser ap = new AxisParser(axis);
                ap.getFromXML(context, y2Axis, axis);
            }
            Element legend = null;
            int index = 1;
            while ((legend = ParserUtils.getChildWithTagName((String)"Legend", (Element)element, (int)index)) != null) {
                String type = legend.getAttribute("type");
                if (type == null || type.trim().length() == 0) {
                    type = null;
                }
                LegendParser.parseLegend(legend, graph.getLegend(type));
                ++index;
            }
            Element viewport = ParserUtils.getChildWithTagName((String)"Viewport", (Element)element);
            if (viewport != null && graph instanceof ViewportInterface) {
                String xMin = viewport.getAttribute("xMin");
                String xMax = viewport.getAttribute("xMax");
                if (xMin != null && xMin.length() > 0 && xMax != null && xMax.length() > 0) {
                    ((ViewportInterface)((Object)graph)).setViewport(1, 1, ParserUtils.getDoubleValue((String)xMin), ParserUtils.getDoubleValue((String)xMax));
                }
                String yMin = viewport.getAttribute("yMin");
                String yMax = viewport.getAttribute("yMax");
                if (yMin != null && yMin.length() > 0 && yMax != null && yMax.length() > 0) {
                    ((ViewportInterface)((Object)graph)).setViewport(1, 2, ParserUtils.getDoubleValue((String)yMin), ParserUtils.getDoubleValue((String)yMax));
                }
                String x2Min = viewport.getAttribute("x2Min");
                String x2Max = viewport.getAttribute("x2Max");
                if (x2Min != null && x2Min.length() > 0 && x2Max != null && x2Max.length() > 0) {
                    ((ViewportInterface)((Object)graph)).setViewport(1, 5, ParserUtils.getDoubleValue((String)x2Min), ParserUtils.getDoubleValue((String)x2Max));
                }
                String y2Min = viewport.getAttribute("y2Min");
                String y2Max = viewport.getAttribute("y2Max");
                if (y2Min != null && y2Min.length() > 0 && y2Max != null && y2Max.length() > 0) {
                    ((ViewportInterface)((Object)graph)).setViewport(1, 6, ParserUtils.getDoubleValue((String)y2Min), ParserUtils.getDoubleValue((String)y2Max));
                }
                String zMin = viewport.getAttribute("zMin");
                String zMax = viewport.getAttribute("zMax");
                if (zMin != null && zMin.length() > 0 && zMax != null && zMax.length() > 0) {
                    ((ViewportInterface)((Object)graph)).setViewport(1, 3, ParserUtils.getDoubleValue((String)zMin), ParserUtils.getDoubleValue((String)zMax));
                }
            }
        }
        if (rc instanceof LayerInterface) {
            if (element.hasAttribute("xAxis")) {
                String xMapping = element.getAttribute("xAxis");
                if ("x2".equalsIgnoreCase(xMapping)) {
                    ((LayerInterface)rc).setXAxisMapping(3);
                } else {
                    ((LayerInterface)rc).setXAxisMapping(0);
                }
            }
            if (element.hasAttribute("yAxis")) {
                String yMapping = element.getAttribute("yAxis");
                if ("y2".equalsIgnoreCase(yMapping)) {
                    ((LayerInterface)rc).setYAxisMapping(4);
                } else {
                    ((LayerInterface)rc).setYAxisMapping(1);
                }
            }
        }
        if (rc instanceof PropertyInterface) {
            ((PropertyInterface)rc).applyPropertyChanges();
        }
        return rc;
    }

    protected abstract void loadFromStatgraph(Hashtable var1, Element var2);

    protected abstract void loadFromODS(Hashtable var1, Element var2);

    @Override
    public Element putToXML(Hashtable context, Object object) {
        int xmlType = SILKParser.getXMLType(context);
        Element rc = null;
        switch (xmlType) {
            case 1: {
                rc = this.getODSXML(context, object);
                break;
            }
            case 0: {
                rc = this.getStatgraphXML(context, object);
            }
        }
        rc = super.putToXML(context, object, rc);
        if (object instanceof PropertyInterface) {
            PropertyInterface prop = (PropertyInterface)object;
            Object obj = prop.getPropertyValue(24);
            if (obj == null && prop instanceof GraphInterface) {
                obj = ((GraphInterface)prop).getLegend(null);
            }
            Enumeration e = Extract.elements((Object)obj);
            while (e.hasMoreElements()) {
                LegendParser parser;
                Element elem;
                Object o = e.nextElement();
                String type = null;
                if (!(o instanceof LegendInterface)) {
                    type = ParserUtils.getString(o);
                    prop.setPropertyValue(23, o);
                    o = prop instanceof GraphInterface ? ((GraphInterface)prop).getLegend(o) : null;
                }
                if (o == null || (elem = (parser = new LegendParser()).putToXML(context, o)) == null) continue;
                if (type != null) {
                    elem.setAttribute("type", type);
                }
                rc.appendChild(elem);
            }
        }
        if (object instanceof GraphInterface) {
            AxisParser aParser = new AxisParser();
            Element e = aParser.putToXML(context, ((GraphInterface)object).getAxis("X"), "XAxis");
            if (e != null) {
                rc.appendChild(e);
            }
            if ((e = aParser.putToXML(context, ((GraphInterface)object).getAxis("Y"), "YAxis")) != null) {
                rc.appendChild(e);
            }
            if ((e = aParser.putToXML(context, ((GraphInterface)object).getAxis("X2"), "X2Axis")) != null) {
                rc.appendChild(e);
            }
            if ((e = aParser.putToXML(context, ((GraphInterface)object).getAxis("Y2"), "Y2Axis")) != null) {
                rc.appendChild(e);
            }
        }
        if (object instanceof LayerInterface) {
            LayerInterface l = (LayerInterface)object;
            if (l.getXAxisMapping() == 3) {
                rc.setAttribute("xAxis", "x2");
            }
            if (l.getYAxisMapping() == 4) {
                rc.setAttribute("yAxis", "y2");
            }
        }
        if (object instanceof ViewportInterface) {
            Element e = ParserUtils.newElement((Hashtable)context, (String)"Viewport");
            ViewportInterface viewport = (ViewportInterface)object;
            double[] o_range = viewport.getViewport(1, 1, 1);
            double[] range = viewport.getViewport(1, 2, 1);
            if (!(o_range == null || o_range.length <= 1 || range == null || range.length <= 1 || Double.isNaN(o_range[0]) || Double.isNaN(range[0]) || o_range[0] == range[0] && o_range[1] == range[1])) {
                e.setAttribute("xMin", range[0] + "");
                e.setAttribute("xMax", range[1] + "");
            }
            o_range = viewport.getViewport(1, 1, 5);
            range = viewport.getViewport(1, 2, 5);
            if (!(o_range == null || o_range.length <= 1 || range == null || range.length <= 1 || Double.isNaN(o_range[0]) || Double.isNaN(range[0]) || o_range[0] == range[0] && o_range[1] == range[1])) {
                e.setAttribute("x2Min", range[0] + "");
                e.setAttribute("x2Max", range[1] + "");
            }
            o_range = viewport.getViewport(1, 1, 2);
            range = viewport.getViewport(1, 2, 2);
            if (!(o_range == null || o_range.length <= 1 || range == null || range.length <= 1 || Double.isNaN(o_range[0]) || Double.isNaN(range[0]) || o_range[0] == range[0] && o_range[1] == range[1])) {
                e.setAttribute("yMin", range[0] + "");
                e.setAttribute("yMax", range[1] + "");
            }
            o_range = viewport.getViewport(1, 1, 6);
            range = viewport.getViewport(1, 2, 6);
            if (!(o_range == null || o_range.length <= 1 || range == null || range.length <= 1 || Double.isNaN(o_range[0]) || Double.isNaN(range[0]) || o_range[0] == range[0] && o_range[1] == range[1])) {
                e.setAttribute("y2Min", range[0] + "");
                e.setAttribute("y2Max", range[1] + "");
            }
            o_range = viewport.getViewport(1, 1, 3);
            range = viewport.getViewport(1, 2, 3);
            if (!(o_range == null || o_range.length <= 1 || range == null || range.length <= 1 || Double.isNaN(o_range[0]) || Double.isNaN(range[0]) || o_range[0] == range[0] && o_range[1] == range[1])) {
                e.setAttribute("zMin", range[0] + "");
                e.setAttribute("zMax", range[1] + "");
            }
            if (e.hasAttributes()) {
                rc.appendChild(e);
            }
        }
        return rc;
    }

    protected abstract Element getODSXML(Hashtable var1, Object var2);

    protected abstract Element getStatgraphXML(Hashtable var1, Object var2);

    @Override
    public abstract Object getObject();

    public abstract boolean setObject(Object var1);
}

