/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.util.GridCell;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.EntryTitleParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.xml.GraphParserFactory;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public class CellParser
implements ElementParserInterface {
    public static final String CURRENT_CELL = "CURRENT_CELL";

    public Object getFromXML(Hashtable context, Element element, Object instance) {
        GridCell rc = instance instanceof GridCell ? (GridCell)instance : new GridCell();
        context.put(CURRENT_CELL, rc);
        Vector previous = (Vector)context.get("CHART_LIST");
        if (previous == null) {
            previous = new Vector();
        }
        Object[] prev = new String[previous.size()];
        previous.copyInto(prev);
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.removeChart(context, (String)prev[i]);
        }
        SILKParser.load(context, element);
        Object[] charts = SILKParser.getCharts(context);
        Vector vec = (Vector)context.get("CHART_LIST");
        if (vec != null) {
            Object[] chartNames = new String[vec.size()];
            vec.copyInto(chartNames);
            Vector<Object> components = new Vector<Object>();
            for (int i = 0; i < charts.length; ++i) {
                Object obj = charts[i];
                if (obj instanceof JComponent) {
                    components.addElement(obj);
                }
                SILKParser.removeChart(context, (String)chartNames[i]);
            }
            Object[] children = new JComponent[components.size()];
            components.copyInto(children);
            if (children.length > 0) {
                rc.setChart((JComponent)children[0]);
            }
        }
        for (int i = 0; i < prev.length; ++i) {
            SILKParser.addChart(context, (String)prev[i]);
        }
        context.put("Cell" + rc.hashCode(), rc);
        SILKParser.addChart(context, "Cell" + rc.hashCode());
        context.remove(CURRENT_CELL);
        return rc;
    }

    public Object getObject() {
        return null;
    }

    public Element putToXML(Hashtable context, Object instance) {
        Element rc = ParserUtils.newElement((Hashtable)context, (String)"Cell");
        if (instance instanceof GridCell) {
            TextStyleInterface[] tsi;
            GridCell gc = (GridCell)instance;
            ElementParserInterface parser = GraphParserFactory.loadParser((Object)gc.getChart());
            if (parser != null) {
                Element compXML = parser.putToXML(context, (Object)gc.getChart());
                rc.appendChild(compXML);
            }
            if ((tsi = gc.getCellHeaders()) != null) {
                Element cellHeader = ParserUtils.newElement((Hashtable)context, (String)"CellHeader");
                for (int i = 0; i < tsi.length; ++i) {
                    if (tsi[i] == null) continue;
                    Element chXML = EntryTitleParser.getEntryStyleXML(context, tsi[i]);
                    cellHeader.appendChild(chXML);
                }
                rc.appendChild(cellHeader);
            }
        }
        return rc;
    }
}

